# Note that this is NOT a relocatable package

%define major 2
%define minor 1
%define micro 2
%define ver   %major.%minor.%micro

Name:		gtk+extra
Version:	%major.%minor.%micro
Release:	1%{?dist}
Summary:	A library of gtk+ widgets
Summary(fr):	Une bibliothèque de widgets gtk+

Group:		System Environment/Libraries
License:	LGPLv2+
URL:		http://gtkextra.sourceforge.net/
Source:		http://downloads.sourceforge.net/gtkextra/gtk+extra-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	gtk2-devel

%description
A library of dynamically linked gtk+ widgets including:
GtkSheet, GtkPlot, and GtkIconList

%description -l fr
Une bibliothèque de widgets gtk+ liés dynamiquement incluant :
GtkSheet, GtkPlot et GtkIconList

%package devel
Summary:	A library of gtk+ widgets
Summary(fr):	Une bibliothèque de widgets gtk+
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	gtk2-devel

%description devel
The %{name}-devel package includes the static libraries, header files,
and documentation for compiling programs that use gtk+extra widgets.

%description -l fr devel
Le paquetage %{name}-devel contient les bibliothèques statiques, les fichiers
d'en-têtes et la documentation nécessaires à la compilation des programmes
qui utilisent les widgets gtk+extra.

%prep
%setup -q
%{__chmod} a-x ChangeLog
%{__sed} -i 's/\r//' docs/{gtk*.ChangeLog,HELP,README,TODO,VERSION}
%{__sed} -i 's/\r//' docs/reference/*.html
%{__sed} -i 's/\r//' docs/tutorial/{*.html,gtksheet/*.{c,html}}


%build
%configure
make  %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING README
%{_libdir}/libgtkextra*.so.*

%files devel
%defattr(-,root,root,-)
%doc docs/{gtk*.ChangeLog,COPYING,HELP,README,TODO,VERSION}
%doc docs/reference/ docs/tutorial/
%dir %{_datadir}/gtk-doc/html/gtkextra/
%{_datadir}/gtk-doc/html/gtkextra/
%{_libdir}/*.a
%exclude %{_libdir}/*.la
%exclude %{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_includedir}/*


%changelog
* Sat Mar 20 2010 Roy Rankin <rrankin[AT]ihug[DOT]com[DOT]au> 
- Update from current Fedora spec file

* Fri Jan 21 2005 Adrian E. Feiguin <afeiguin@uci.edu>
- First version for gtkextra-2

* Fri Dec 20 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Make the rpm name a variable.
- Set rpm name to gtk+extra allowing both 0.99.x and 1.1.x to be installed.

* Mon Jul 22 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Corrected for use of pkg-config

* Wed Jul 17 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Corrected -install to use DESTDIR
- Make gtk+extra-devel package require gtk+extra
- Added *.so to devel files

* Wed Mar 15  2000 Conrad Steenberg <conrad@srl.caltech.edu>
- First spec file
