/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HONOKASETUPCORE_H
#define HONOKASETUPCORE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define Uses_SCIM_UTILITY

#include <scim.h>
#include <vector>
#include <cstdio>
#include <cstdlib>

#define HONOKA_SETUP_ITEM_ENTRY     "entry"
#define HONOKA_SETUP_ITEM_FILE      "file"
#define HONOKA_SETUP_ITEM_BOOL      "bool"
#define HONOKA_SETUP_ITEM_KEY       "key"
#define HONOKA_SETUP_ITEM_INT       "int"
#define HONOKA_SETUP_ITEM_SELECT    "select"
#define HONOKA_SETUP_ITEM_PAGE      "page"
#define HONOKA_SETUP_ITEM_SETUP     "setup"

using namespace scim;
using namespace std;


/**
	@author TAM (Teppei Tamra) <tam-t@par.odn.ne.jp>
*/
namespace Honoka {

class HonokaSetupCoreItem {
public:
    const String getType();
    const String getName();
    const String getLabel();
    const String getTip();
    const String getStringData();
    int getIntData();
    bool getBoolData();
    vector<String> getStringListData();
    int getIntUpper();
    int getIntLower();
    
    ~HonokaSetupCoreItem();
protected:
    HonokaSetupCoreItem(String _label,String _name,String _tip);
protected:
    String type;
    String label;
    String name;
    String tip;
    String stringData;
    bool boolData;
    int intData;
    int intUpper;
    int intLower;
    vector<String> stringListData;
};

class HonokaSetupCoreContainer {
public:
    const vector<HonokaSetupCoreItem *> getChildren();
    virtual void append(HonokaSetupCoreItem *item);
protected:
    HonokaSetupCoreContainer();
    ~HonokaSetupCoreContainer();
    vector<HonokaSetupCoreItem *> items;
};


class HonokaSetupCoreEntryItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreEntryItem(String _label,String _name,String _tip,String _default);
};

class HonokaSetupCoreKeyItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreKeyItem(String _label,String _name,String _tip,String _default);
};

class HonokaSetupCoreFileItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreFileItem(String _label,String _name,String _tip,String _default);
};

class HonokaSetupCoreBoolItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreBoolItem(String _label,String _name,String _tip,bool _default);
};

class HonokaSetupCoreIntItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreIntItem(String _label,String _name,String _tip,int _default,int _lower,int _upper);
};

class HonokaSetupCoreSelectItem : public HonokaSetupCoreItem {
public:
    HonokaSetupCoreSelectItem(String _label,String _name,String _tip,String _default,vector<String> _list);
};


class HonokaSetupCorePage: public HonokaSetupCoreItem ,public HonokaSetupCoreContainer {
public:
    HonokaSetupCorePage(String _label,String _name,String _tip);
};


class HonokaSetupCore: public HonokaSetupCoreItem ,public HonokaSetupCoreContainer {
public:
    HonokaSetupCore(String _label,String _name,String _tip);
};



}


#endif
