/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SKKDICCONVERSION_H
#define SKKDICCONVERSION_H

#define Uses_SCIM_CONFIG_BASE

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <scim.h>
#include <scim_iconv.h>
#include <scim_attribute.h>
#include <convertor.h>
#include <honokasetupcore.h>
#include <skkdic.h>

#define HONOKA_CONFIG_SKKDIC_DICFILE    "/IMEngine/Honoka/SKKDic/File"
#define HONOKA_DEFAULT_SKKDIC_DICFILE    "/usr/share/skk/SKK-JISYO.L"


using namespace std;
using namespace scim;

/**
@author TAM (Teppei Tamra)
*/
namespace Honoka {
class SKKDicConversion : public Convertor {
public:
    SKKDicConversion(ConfigPointer cfg);

    ~SKKDicConversion();
    virtual bool isConnected();
    virtual void reset();
    virtual void setYomiText(WideString yomi);
    virtual int ren_conversion();
    virtual int setPos(int p);
    virtual int getPos();
    virtual ResultList getResultList(int p = -1 ,ResultType kt = DEFAULT);
    virtual bool select(int p);
    virtual bool resizeRegion(int w);
    virtual void updateFrequency();
    virtual bool connect();
    virtual void disconnect();
    virtual String getName();
    virtual String getPropertyName();
    virtual const vector<Segment> getSegmentList();
    static HonokaSetupCorePage *setup();

protected:
    SKKDic *dic;
    vector<WideString> buns;
    vector<WideString> texts;
    ResultList list;
    int pos;

};
}
#endif
