/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class VersionHelper {
    private String version;
    private String title;
    private String productId;
    private String releaseMilestone;
    private String releaseMinor;
    private String releaseMajor;
    private String releaseCandidateToken;
    private String releaseNumber;
    private String releaseBuildNumber;
    private ProjectInformation projectInformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHelper(ProjectInformation projectInformation) {
        if (projectInformation == null) {
            throw new NullPointerException();
        }
        this.projectInformation = projectInformation;
        ClassLoader loader = projectInformation.getClass().getClassLoader();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream inputStream = url.openStream();
                try {
                    if (!this.init(inputStream)) continue;
                    return;
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean init(InputStream input) throws IOException {
        if (input == null) {
            return false;
        }
        try {
            Manifest props = new Manifest(input);
            Attributes attr = this.getAttributes(props, this.projectInformation.getInternalName());
            String maybeTitle = this.getValue(attr, "Implementation-Title", null);
            if (!ObjectUtilities.equal(this.projectInformation.getInternalName(), maybeTitle)) {
                return false;
            }
            this.title = maybeTitle;
            this.releaseMajor = this.getValue(attr, "Release-Major-Number", "0");
            this.releaseMinor = this.getValue(attr, "Release-Minor-Number", "0");
            this.releaseMilestone = this.getValue(attr, "Release-Milestone-Number", "0");
            this.releaseCandidateToken = this.getValue(attr, "Release-Candidate-Token", "");
            this.releaseBuildNumber = this.getValue(attr, "Release-Build-Number", "");
            this.releaseNumber = this.getValue(attr, "Release-Number", "");
            if (this.releaseNumber.length() == 0) {
                this.releaseNumber = this.createReleaseVersion();
            }
            this.version = this.getValue(attr, "Implementation-Version", "");
            if (this.version.length() == 0) {
                this.version = this.createVersion();
            }
            this.productId = this.getValue(attr, "Implementation-Product-Id", "");
            if (this.productId.length() == 0) {
                this.productId = this.createProductId();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Attributes getAttributes(Manifest props, String name) {
        Attributes attributes = props.getAttributes(name);
        if (attributes == null) {
            return props.getMainAttributes();
        }
        return attributes;
    }

    private String getValue(Attributes attrs, String name, String defaultValue) {
        String value = attrs.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    private String createProductId() {
        if (this.version.trim().length() == 0) {
            return this.title;
        }
        return this.title + '-' + this.version;
    }

    private String createVersion() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(this.releaseMajor);
        buffer.append('.');
        buffer.append(this.releaseMinor);
        buffer.append('.');
        buffer.append(this.releaseMilestone);
        return buffer.toString();
    }

    private String createReleaseVersion() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(this.releaseMajor);
        buffer.append('.');
        buffer.append(this.releaseMinor);
        buffer.append('.');
        buffer.append(this.releaseMilestone);
        if (this.releaseCandidateToken.length() > 0) {
            buffer.append('-');
            buffer.append(this.releaseCandidateToken);
        }
        if (this.releaseBuildNumber.length() > 0) {
            buffer.append(" (Build ");
            buffer.append(this.releaseBuildNumber);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getReleaseMilestone() {
        return this.releaseMilestone;
    }

    public String getReleaseMinor() {
        return this.releaseMinor;
    }

    public String getReleaseMajor() {
        return this.releaseMajor;
    }

    public String getReleaseCandidateToken() {
        return this.releaseCandidateToken;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getReleaseBuildNumber() {
        return this.releaseBuildNumber;
    }
}

