SET(K3D_REQUIRED_LIBRARIES)

SET(K3D_OPTIONAL_LIBRARY_CONFIGURATIONS)
SET(K3D_OPTIONAL_LIBRARIES)

MACRO(K3D_CHECK_REQUIRED_DEPENDENCY FOUND LIBRARY URLS DESCRIPTION)
	LIST(APPEND K3D_REQUIRED_LIBRARIES ${LIBRARY})
	IF(NOT ${FOUND})
		SET(MESSAGE_TEXT "Couldn't find ${LIBRARY}, which is required to build K-3D.")
		SET(MESSAGE_TEXT "${MESSAGE_TEXT} You can obtain ${LIBRARY} from")
		SET(DELIMITER "")
		FOREACH(URL ${URLS})
			SET(MESSAGE_TEXT "${MESSAGE_TEXT} ${DELIMITER} ${URL}")
			SET(DELIMITER "or")
		ENDFOREACH()
		SET(MESSAGE_TEXT "${MESSAGE_TEXT}.")
		SET(MESSAGE_TEXT "${MESSAGE_TEXT} ${DESCRIPTION}")
		MESSAGE(SEND_ERROR "${MESSAGE_TEXT}")
	ENDIF(NOT ${FOUND})
ENDMACRO(K3D_CHECK_REQUIRED_DEPENDENCY)

MACRO(K3D_CHECK_OPTIONAL_DEPENDENCY CONFIG FOUND LIBRARY)
	LIST(APPEND K3D_OPTIONAL_LIBRARY_CONFIGURATIONS ${CONFIG})
	LIST(APPEND K3D_OPTIONAL_LIBRARIES ${LIBRARY})

	IF(${CONFIG})
		IF(NOT ${FOUND})
			MESSAGE(SEND_ERROR "Couldn't find the ${LIBRARY} library, which is required by ${CONFIG}.")
		ENDIF(NOT ${FOUND})
	ENDIF(${CONFIG})
ENDMACRO(K3D_CHECK_OPTIONAL_DEPENDENCY)

MACRO(K3D_CHECK_NGUI_DEPENDENCY CONFIG)
	IF(${CONFIG} AND NOT K3D_BUILD_NGUI_MODULE)
		MESSAGE(SEND_ERROR "K3D_BUILD_NGUI_MODULE is required by ${CONFIG}.")
	ENDIF(${CONFIG} AND NOT K3D_BUILD_NGUI_MODULE)
ENDMACRO(K3D_CHECK_NGUI_DEPENDENCY)

