/* board.c for kan netmaj */
#include "xnet.h"
#include "bitmap/misc.h"
#include "bitmap/textbitmap.h"
#include "strdef.h"
#include <sys/types.h>
#include <sys/time.h>

int mypos;
int adv_displayed;

extern int auto_play, auto_after_reach, in_choice, in_res;
extern int fonth[4], jfonth[2];

void select_pai(), select_dialog1(), select_dialog2();
void select_cancel(), select_main(), select_naki();
void draw_dlg1(), draw_dlg2(), draw_dlg3();

global_t *gl;

static char *digit_data[] = {
    ichi_bits, ni_bits, san_bits, yon_bits,
};

static int digit_w = ichi_width, digit_h = ichi_height;

static char *bturn_data[] = {
    bigton_bits, bignan_bits, bigsya_bits, bigpei_bits,
};

static int bturn_w = bigton_width, bturn_h = bigton_height;

static char *kaze_data[] = {
    ton_bits, nan_bits, sya_bits, pei_bits, ie_bits,
};

static int kaze_w = ton_width, kaze_h = ton_height;

void
draw_digit(win, x, y, w, col, num)
     int x, y, num, w, win;
     Pixel col;
{
    char buf[10];

    sprintf(buf, "%d", num);
    win_cleararea(win, x-w, y-fonth[NFNT]/2, w, fonth[NFNT]);
    draw_rtext (win, x, y, col, NFNT, buf);
}

void
draw_menu()
{
    ThreeDframe2(menu, 0, 0, win_width(menu), win_height(menu), 1);
    draw_button(menu_but);
}

char adv_txt1[100], adv_txt2[100], adv_txt3[100];
int advice_pai;


void
select_menu(num, sel)
     int num, sel;
{
    extern int gkind, selected;
    global_t *gp;

    gp = gl;

    win_unmap(menu);
    set_reg_responsive(num, 0);
    switch(sel)
      {
	case 0:
	  if (gkind == PROG_NETMAJ)
	    win_map_normal(talk_win);
	  break;
	case 1:
	  if (gkind == PROG_NETMAJ)
	    execute_auto("");
	  break;
	case 2:
	  if (auto_play%2) {
	      auto_play--;
	      set_buttonlabel(num, sel, menu_label[2]);
	  }
	  else {
	      auto_play++;
	      set_buttonlabel(num, sel, menu_label[7]);
	  }
	  break;
	case 3:
	  auto_after_reach = !auto_after_reach;
	  break;
	case 4:
	  if (in_choice) {
	      int save,ask;
	      save = ask_attr;
	      analize(gp,vself);
	      ask = ask_attr;
	      ask_attr = save;
	      sprintf(adv_txt1,"--- advice in choice ---");
	      if (T_GET(ask) == T_HN_TSM) {
		  sprintf(adv_txt2, "ĥ⡡");
		  advice_pai = 0;
	      }
	      else if (T_GET(ask) == T_RV_RCH) {
		  sprintf(adv_txt2, "ʥ꡼");
		  advice_pai = ask_pai;
	      }
	      else {
		  sprintf(adv_txt2, "");
		  advice_pai = ask_pai;
	      }
	      sprintf(adv_txt3,"%s",analize_message(gp));
	  }
	  else if (in_res) {
	      int ask,how;
	      int save;
	
	      save = ask_attr;
	      ask = analize_res(gp,&how);
	      ask_attr = save;
	      sprintf(adv_txt1,"--- advice in responce ---");
	      sprintf(adv_txt3, "");
	      advice_pai = 0;
	      if (ask == R_TIE) {
		  sprintf(adv_txt2, "");
		  advice_pai = how;
	      }
	      else if (ask == R_RON)
		sprintf(adv_txt2, "");
	      else if (ask == R_PON)
		sprintf(adv_txt2, "ݥ");
	      else if (ask == R_KAN)
		sprintf(adv_txt2, "");
	      else
		sprintf(adv_txt2, "äˤʤ");
	  }
	  win_map(msg4);
	  while(1) {
	      selected = SEL_NONE;
	      while(selected == SEL_NONE)
		  ui_event_wait (gp, 0);
	      if (selected == -1 || selected == SEL_CANCEL)
		break;
	  }
	  win_unmap(msg4);
	  set_reg_responsive(adv_but, 0);
	  selected = SEL_NONE;
	  break;
	case 5:
	  open_help();
	  break;
	case 6:
	  do_disconnect(gp);
	  term ();
	  break;
      }
}

void
select_main(num, sel)
     int num, sel;
{
    win_map(menu);
}

void
set_object(obj, num, x, y, w, h)
     struct object *obj;
     int num, x, y;
{
    obj[num].x = x;
    obj[num].y = y;
    obj[num].wth = w;
    obj[num].hgt = h;
}

void
set_object2(obj, num, x, y, w, h, dt)
     struct object *obj;
     int num, x, y, dt;
{
    obj[num].x = x;
    obj[num].y = y;
    obj[num].wth = w;
    obj[num].hgt = h;
    obj[num].dt = dt;
}

get_drawing_pos(num, add, x, y)
     int num, add, *x, *y;
{
    struct object obj;

    get_obj_from_win(main_win, 10, &obj);

    *x = obj.x+4;
    *y = obj.y+((num+mypos)%4+add)*obj.hgt+4;
}

void
draw_advice()
{
    int h = nmax(fonth[SLFNT], jfonth[SLFNT]);

    win_cleararea(msg4, 0, 0, win_width(msg4), win_height(msg4));
    ThreeDframe2(msg4, 0, 0, win_width(msg4), win_height(msg4), 2);
    draw_cotext(msg4, 20, 10+h/2, cols.mess, SLFNT, adv_txt1);
    if (advice_pai)
      draw_pai (msg4, advice_pai, 0, 0, 30, 20+h+fthsize);
    draw_cotext(msg4, 40+(advice_pai!=0)*(ftwsize+20), 20+h+fthsize/2, 
		cols.mess, SLFNT, adv_txt2);
    draw_cotext(msg4, 20, 30+h+fthsize+h/2, cols.mess, SLFNT, adv_txt3);

    draw_button(adv_but);
}


void
unmap_advice(num, sel)
     int num, sel;
{
    extern int selected;

    selected = -1;
}

char *talk_str;

void
talk_call(num, sel)
     int num, sel;
{
    global_t *gp;
    gp = gl;

    if (sel) {
	win_unmap_normal(talk_win);
	set_reg_responsive(talk_txt, 0);
	set_reg_responsive(talk_but1, 0);
	set_reg_responsive(talk_but2, 0);
    }
    else {
	if (talk_str)
	  free(talk_str);
	get_textbox(talk_txt, &talk_str);
	msgTalk(gp,talk_str);
    }
}

void
map_talk()
{
    int i, j;
    int w = win_width(talk_win), h = win_height(talk_win);

    win_cleararea(talk_win, 0, 0, w, h);
    ThreeDframe2(talk_win, 0, 0, w, h, 2);

    set_reg_position(talk_txt, 20, 20);
    draw_textbox(talk_txt);

    set_reg_position(talk_but2, 20, 40+region_height(talk_txt));
    draw_button(talk_but2);
    j = region_height(talk_but2)/9;

    for (i = 0; i < 9; i++)
      draw_cotext(talk_win, 30+region_width(talk_but2), 
		  40+region_height(talk_txt)+i*j+j/2, 
		  cols.mess, SLFNT, talk_mes[i]);

    set_reg_position(talk_but1, w-4-region_width(talk_but1), 
		     h-4-region_height(talk_but1));
    draw_button(talk_but1);
}

void
select_mess(num, sel)
     int num, sel;
{
    set_textbox(talk_txt, talk_mes[sel]);
    draw_textbox(talk_txt);
}

void
popup_talkmess()
{
    int w = win_width(msg5), h = win_height(msg5);
    extern char tmessage[50];

    win_cleararea(msg5, 0, 0, w, h);
    ThreeDframe2(msg5, 0, 0, w, h, 1);
    draw_cotext(msg5, 10, h/2, cols.mess, SLFNT, tmessage);
}


void
make_board ()
{
    int i, j, k, winw, winh, sspc, pos;
    int pfldw, pfldh, kfldw, kfldh, sfldh, nfldw, nfldh;
    char *sp[9];
    char *win_name = "KAN NetMaj";
    char *talk_name = "KAN NetMaj Talk";
    struct object obj[20];

    win_init();
    init_color ();
    set_pai_size();

    pai_init ();

    pfldw = ftwsize*21+fywsize+4;
    pfldh = fthsize+ftwsize+fyhsize+11;
    kfldw = kaze_w+12;
    kfldh = kaze_h*2+16;
    sfldh = fthsize*2-fywsize+5;

    nfldw = textwidth("--------", SLFNT);
#ifndef ASCII_MESSAGE
    nfldw = 20+nmax(nfldw, textwidth("", SLFNT));
#endif
    nfldh = fonth[3]+nmax(jfonth[SLFNT], fonth[SLFNT])+30;
    nfldh = (pfldh-fthsize-5<nfldh)?pfldh-fthsize-5:nfldh;

    i = bturn_w+digit_w+kyoku_width+xpm_width(bou1_xpm)
      +textwidth("22", NFNT)+textwidth(miscchar[6], BGFNT)+ftwsize*7
	+textwidth(VERSION, SLFNT);
    winw = nmax(i, pfldw+kfldw);
    winh = sfldh+4*pfldh;
    sspc = (winw-i)/4;

    /* main_window */
    main_win = make_window(-1, win_name, ( ExposureMask | ButtonPressMask |
					  ButtonReleaseMask | KeyPressMask), 1);
    resize_win(main_win, winw, winh);

    i = (sfldh-4-bturn_w)/2;

    pos = 4;
    set_object(obj, 0, pos, i, bturn_w+digit_w+kyoku_width, bturn_h);
    pos += obj[0].wth+sspc;
    i = (sfldh-4-xpm_height(bou1_xpm)-xpm_height(bou2_xpm))/3;
    set_object(obj, 1, pos, 2+i, xpm_width(bou1_xpm), xpm_height(bou1_xpm));
    set_object(obj, 2, pos, sfldh-4-i-xpm_height(bou2_xpm),
	       xpm_width(bou2_xpm), xpm_height(bou2_xpm));

    pos += obj[1].wth+textwidth("22", NFNT);
    set_object(obj, 3, pos, 2+i+xpm_height(bou1_xpm)/2,
	       textwidth("22", NFNT), fonth[NFNT]);
    set_object(obj, 4, pos, sfldh-4-i-xpm_height(bou2_xpm)/2,
	       textwidth("22", NFNT), fonth[NFNT]);

    i = (sfldh-4-textheight(miscchar[6], BGFNT)-fonth[NFNT])/3;
    pos += sspc;
    set_object(obj, 5, pos, 2+i+textheight(miscchar[6], BGFNT)/2,
	       textwidth(miscchar[6], BGFNT), textheight(miscchar[6], BGFNT));

    pos += obj[5].wth;
    set_object(obj, 6, pos, sfldh-4-i-fonth[NFNT]/2,
	       textwidth("222", NFNT), fonth[NFNT]);

    pos += sspc;
    set_object(obj, 7, pos, 2, ftwsize*7, fthsize*2-fywsize+1);

    set_object(obj, 8, 0, 0, winw, sfldh); /* status part */
    set_object(obj, 9, 0, sfldh, kfldw, kfldh); /* kaze part */
    set_object(obj, 10, kfldw, sfldh, pfldw, pfldh); /* pai part */
    set_object(obj, 11, winw-nfldw, sfldh+pfldh-nfldh, nfldw, nfldh); /* name part */
    set_object(obj, 12, kfldw/2, sfldh+pfldh-9-xpm_height(reachbou_xpm), 
	       xpm_width(reachbou_xpm),xpm_height(reachbou_xpm)); /* reach_bou */
    i = nmax(fonth[SLFNT], jfonth[SLFNT]);
    j = fonth[NFNT];
    k = (nfldh-i-j)/3;
    set_object(obj, 13, winw-10, sfldh+pfldh-nfldh+k+i/2, nfldw-20,i); /* name */
    set_object2(obj, 14, winw-10, sfldh+pfldh-k-j/2, nfldw-20, j, pfldh); /* point */

    set_obj_to_win(main_win, 15, obj);


    /* dialog1 */
    dlg1 = make_window(main_win, "", MASK, 0);
    set_expose_func(dlg1, (void *)draw_dlg1);
    /* buttons in dialog1 */
    for (i = 0; i < 3; i++)
      sp[i] = but1_label[i];
    dlg1_but = make_button(dlg1, VERT, 3, sp, SLFNT, (void *)select_dialog1);
    set_reg_position(dlg1_but, 2, 2);
    resize_win(dlg1, region_width(dlg1_but)+4, region_height(dlg1_but)+4);

    /* dialog2 */
    dlg2 = make_window(main_win, "", MASK, 0);
    set_expose_func(dlg2, (void *)draw_dlg2);
    /* buttons in dialog2 */
    for (i = 0; i < 5; i++)
      sp[i] = but2_label[i];
    dlg2_but = make_button(dlg2, VERT, 5, sp, SLFNT, (void *)select_dialog2);
    set_reg_position(dlg2_but, 2, 2);
    resize_win(dlg2, region_width(dlg2_but)+4, region_height(dlg2_but)+4);

    /* dialog3 */
    dlg3 = make_window(main_win, "", MASK, 0);
    set_expose_func(dlg3, (void *)draw_dlg3);
    /* buttons in dialog3 */
    sp[0] = but3_label[0];
    dlg3_but = make_button(dlg3, VERT, 1, sp, SLFNT, (void *)select_cancel);
    set_reg_position(dlg3_but, 2, 2+(fthsize+5)*3);
    resize_win(dlg3, ftwsize*4+4, region_height(dlg3_but)+(fthsize+5)*3+4);

    /* slection part in dialog3 */
    naki_sel = make_selection_box(dlg3, VERT, 3, ftwsize*4, fthsize+5, 
				  (void *)select_naki);
    set_reg_position(naki_sel, 2, 2);

    /* slection part of hand pai */
    pai_sel = make_selection_box(main_win, HORIZ, 15, ftwsize, fthsize, 
				 (void *)select_pai);
    set_reg_position(pai_sel, kfldw+4, sfldh+4*pfldh-4-fthsize);

    /* menu */
    menu = make_window(main_win, "", MASK, 0);
    set_expose_func(menu, (void *)draw_menu);
    /* buttons in menu */
    for (i = 0; i <7; i++)
      sp[i] = menu_label[i];
    menu_but = make_button(menu, VERT, 7, sp, SLFNT, (void *)select_menu);
    set_reg_position(menu_but, 2, 2);
    resize_win(menu, region_width(menu_but)+4, region_height(menu_but)+4);
    move_win(menu, winw-win_width(menu), sfldh);

    /* menu button */
    sp[0] = but4_label[0];
    main_but = make_menubutton(main_win, sp, SLFNT, menu);
    set_reg_position(main_but, winw-2-region_width(main_but), 
		     sfldh-2-region_height(main_but));

    /* advice window */
    msg4 = make_window(main_win, "", MASK, 0);
    set_expose_func(msg4, (void *)draw_advice);
    sp[0] = but9_label[0];
    adv_but = make_button(msg4, VERT, 1, sp, SLFNT, (void *)unmap_advice);
    i = textwidth("", SLFNT)*25+50;
    j = jfonth[SLFNT]*2+fthsize+region_height(adv_but)+50;
    resize_win(msg4, i, j);
    move_win(msg4, (winw-i)/2, (winh-j)/2);
    set_reg_position(adv_but, i-region_width(adv_but)-4, 
		     j-region_height(adv_but)-4);

    /* talk window */
    talk_win = make_window(-1, talk_name, MASK | PropertyChangeMask, 0);
    set_expose_func(talk_win, (void *)map_talk);

    /* buttons in talk */
    for (j = 0; j < 2; j++)
      sp[j] = but10_label[j];
    talk_but1 = make_button(talk_win, HORIZ, 2, sp, SLFNT, (void *)talk_call);
    for (j = 0; j < 9; j++)
      sp[j] = but11_label[j];
    talk_but2 = make_button(talk_win, VERT, 9, sp, SLFNT, (void *)select_mess);
    /* text box */
    talk_txt = make_textbox(talk_win, textwidth("", SLFNT)*25+50, 
			    nmax(fonth[SLFNT], jfonth[SLFNT])+12, 
			    FFNT, 40, miscchar[12], (void *)0);

    i = 40+region_width(talk_txt)+textwidth(miscchar[12], SLFNT);
    j = 60+region_height(talk_txt)+region_height(talk_but1)
      +region_height(talk_but2);
    resize_win(talk_win, i, j);

    msg5 = make_window(main_win, "", MASK, 0);
    set_expose_func(msg5, (void *)popup_talkmess);
}


void
board_redraw ()
{
    static int i = 0;
    if ( i++ % 2 )
      open_win1(main_win, 100);
    else
      open_win2(main_win, 100);
}

void
board_reset (gp)
     global_t *gp;
{
    int i, j, pp, tpos, w, h;
    char buffer[20];
    struct object obj, obj1, obj2, obj3;
    w = win_width(main_win);
    h = win_height(main_win);

    gl = gp;

    mypos = 3 - pplayer[vself];

    init_val();

    get_obj_from_win(main_win, 8, &obj); /* status part */

    win_cleararea(main_win, 0, 0, w, h);
    ThreeDframe(main_win, 0, 0, obj.wth, obj.hgt, 2, 0);

    get_obj_from_win(main_win, 9, &obj1); /* kaze part */
    get_obj_from_win(main_win, 10, &obj2); /* pai part */
    get_obj_from_win(main_win, 11, &obj3); /* name part */

    for (i = 0; i < 4; i++) {
	ThreeDframe(main_win, 0, obj1.y+obj2.hgt*i, obj1.wth, obj1.hgt, 2, 0);
	ThreeDframe(main_win, obj3.x, obj3.y+obj2.hgt*i, obj3.wth, obj3.hgt, 2, 0);
	ThreeDframe2(main_win, 0, obj2.y+obj2.hgt*i, w, obj2.hgt, 2);
	win_cleararea(main_win, 2, obj1.y+obj2.hgt*i+2, obj1.wth-4, obj1.hgt-4);
	win_cleararea(main_win, obj3.x+2, obj3.y+obj2.hgt*i+2, 
		      obj3.wth-4, obj3.hgt-4);
    }

    /*  */
    get_obj_from_win(main_win, 0, &obj);
    draw_bitmap(main_win, bturn_data[big_turn], obj.x, obj.y, 
		bturn_w, bturn_h, cols.kazetx);

    /* ܤ */
    draw_bitmap(main_win, digit_data[small_turn], obj.x+bturn_w, 
		obj.y, digit_w, digit_h, cols.kazetx);
    draw_bitmap(main_win, kyoku_bits, obj.x+bturn_w+digit_w, obj.y, 
		kyoku_width, kyoku_height, cols.kazetx);

    /* ܾ줫 */
    get_obj_from_win(main_win, 1, &obj);
    misc2pixmap(main_win, bou1_xpm, obj.x, obj.y);
    get_obj_from_win(main_win, 2, &obj);
    misc2pixmap(main_win, bou2_xpm, obj.x, obj.y);
    draw_digitobject(main_win, 3, cols.mess, small_turn_cnt, 0);

    get_obj_from_win(main_win, 5, &obj);
    draw_text(main_win, obj.x, obj.y, cols.kazetx, BGFNT, miscchar[6]);

    /* פ */
    get_obj_from_win(main_win, 7, &obj);
    for (i = 0; i < 7; i ++) {
	draw_pai (main_win, 0, 0, 1, obj.x+i*ftwsize, obj2.y-2);
	draw_pai (main_win, 0, 0, 1, obj.x+i*ftwsize, obj.y+fthsize);
    }

    draw_rtext(main_win, w-6, (obj2.y-region_height(main_but))/2, 
	       cols.title, SLFNT, VERSION);

    /* menu button */
    draw_menubutton(main_but);

    /* ƥ桼 */
    get_obj_from_win(main_win, 13, &obj);
    for (i = 0; i < 4; i++) {
	pp = pplayer[i];
	tpos = (pp-pplayer[vself]+3) % 4;

	/* ƥ桼 */
	draw_bitmap(main_win, kaze_data[i], 6, obj1.y+tpos*obj2.hgt+6, 
		    kaze_w, kaze_h, cols.kazetx);
	draw_bitmap(main_win, ie_bits, 6, obj1.y+tpos*obj2.hgt+kaze_h+10,
		    kaze_w, kaze_h, cols.kazetx);

	/* ƥ桼̾ */
	strncpy(buffer, player[pp].name, 8);
	buffer[8] = '\0';
	draw_rtext(main_win, obj.x, obj.y+tpos*obj2.hgt, 
		   cols.nametx, SLFNT, buffer);
    }
    win_flush();
}


static int yakuman_data[8][14] =
{
    {4, 36, 40, 72, 76, 108, 112, 116, 120, 124, 128, 132, 136, 4}, /*  */
    {4, 8, 12, 84, 84, 128, 128, 132, 132, 132, 136, 136, 136, 128}, /* 绰 */
    {80, 80, 80, 84, 84, 88, 88, 104, 104, 104, 132, 132, 132, 80}, /* а쿧 */
    {4, 4, 4, 36, 36, 72, 72, 72, 76, 76, 76, 108, 108, 36}, /* ϷƬ */
    {112, 112, 112, 120, 120, 124, 124, 124, 128, 128, 128, 136, 136, 136}, /* 쿧 */
    {4, 4, 4, 8, 12, 16, 21, 24, 28, 32, 36, 36, 36, 21}, /* Ϣ */
    {60, 64, 68, 112, 112, 116, 116, 120, 120, 120, 124, 124, 124, 112}, /* ʹ */
    {100, 100, 112, 112, 112, 116, 116, 116, 120, 120, 120, 124, 124, 124}, /* ʹ */
};

void make_title()
{
    int i, j, h, x, y, hh[8], ww, wh;
    char *cr = "Copyright";
    char *p1 = "original version: Kouji Suzuki";
    char *p2 = "XNetMaj: Keishiro Tanaka";
    char *p3 = "KAN NetMaj: Ushio Yamamoto";

    ww = win_width(main_win);
    wh = win_height(main_win);
    win_cleararea(main_win, 0, 0, ww, wh);

    hh[0] = title_height;
    hh[1] = hh[0]+textheight(VERSION, BGFNT);
    hh[2] = hh[1]+fthsize;
    hh[3] = hh[2]+textheight(cr, BGFNT);
    hh[4] = hh[3]+textheight(p1, SLFNT);
    hh[5] = hh[4]+textheight(p2, SLFNT);
    hh[6] = hh[5]+textheight(p3, SLFNT);

    h = (wh-hh[6])/5;

    draw_bitmap(main_win, title_bits, (ww-title_width)/2, h, 
		title_width, title_height, cols.title);

    draw_ctext(main_win, ww/2, hh[0]+2*h, cols.mess, BGFNT, VERSION);
    j = time(NULL)%8;
    for (i = 0; i < 14; i++)
      draw_pai (main_win, yakuman_data[j][i], 0, 1, 
		ww/2-7*ftwsize+i*ftwsize+(i==13)*ftwsize/4, hh[1]+3*h+fthsize);

    draw_ctext(main_win, ww/2, hh[2]+4*h, cols.mess, BGFNT, cr);
    draw_ctext(main_win, ww/2, hh[3]+4*h, cols.mess, SLFNT, p1);
    draw_ctext(main_win, ww/2, hh[4]+4*h, cols.mess, SLFNT, p2);
    draw_ctext(main_win, ww/2, hh[5]+4*h, cols.mess, SLFNT, p3);

    win_flush();
}
