/* drwfnc.c for kan netmaj */
#include "xnet.h"

Display *display;
XFontStruct *fonts[4], *jfonts[2];
int fonth[4], jfonth[2];
int screen, depth;
Colormap colormap;
GC gc;
Atom text_atom;
Pixel bg, flcol, fdcol;

#define UNMAP     0
#define MAP       1
#define INVISIBLE 2


struct wwindow {
  Window win;
  int x, y, width, height, parent, status, onum, rnum;
  int *reg, *rst;
  struct object *obj;
  Pixmap base;
  void (*callback)();
} *wwin;


int wnum = 0;

char *fontstr[6];

void
load_font()
{
  int i;

  for (i = 0; i < 4; i++) {
    fonts[i] = XLoadQueryFont (display, fontstr[i]);
    if (!fonts[i]) 
      fonts[i] = XLoadQueryFont(display, "fixed");
    fonth[i] = fonts[i]->ascent + fonts[i]->descent;
  }
#ifndef ASCII_MESSAGE
  for (i = 0; i < 2; i++) {
    jfonts[i] = XLoadQueryFont (display, fontstr[i+4]);
    if (!jfonts[i]) 
      jfonts[i] = XLoadQueryFont(display, "k14");
    jfonth[i] = jfonts[i]->ascent + jfonts[i]->descent;
  }
#endif
}

Pixel
nametopixel(s)
     char *s;
{
  XColor xcolor;

  XParseColor(display, colormap, s, &xcolor);
  XAllocColor(display, colormap, &xcolor);
  return xcolor.pixel;
}


void 
make_colormap()
{
  colormap = XCopyColormapAndFree(display, colormap);
  XInstallColormap (display, colormap);
}      

Pixel
make_darkcolor(col, add)
     Pixel col;
     unsigned short add;
{
  XColor xcolor;

  xcolor.pixel = col;
  XQueryColor(display, colormap, &xcolor);
  if ((xcolor.red -= add) > 65535 - add) xcolor.red = 0;
  if ((xcolor.green -= add) > 65535 - add) xcolor.green = 0;
  if ((xcolor.blue -= add) > 65535 - add) xcolor.blue = 0;
  XAllocColor(display, colormap, &xcolor);
  return  xcolor.pixel;
}

Pixel
make_lightcolor(col, add)
     Pixel col;
     unsigned short add;
{
  XColor xcolor;

  xcolor.pixel = col;
  XQueryColor(display, colormap, &xcolor);
  if ((xcolor.red += add) < add) xcolor.red = 65535;
  if ((xcolor.green += add) < add) xcolor.green = 65535;
  if ((xcolor.blue += add) < add) xcolor.blue = 65535;
  XAllocColor(display, colormap, &xcolor);
  return  xcolor.pixel;
}

set_background_color(col, add)
     Pixel col;
     unsigned short add;
{
  bg = col;
  flcol = make_lightcolor(col, add);
  fdcol = make_darkcolor(col, add);
}

void
win_cleararea(num, x, y, w, h)
     int x, y, w, h, num;
{
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, bg);
  XFillRectangle (display, win, gc, x, y, w, h);
}


int
win_width(num)
     int num;
{
  return wwin[num].width;
}

int
win_height(num)
     int num;
{
  return wwin[num].height;
}

Window
get_wid(num)
     int num;
{
  return wwin[num].win;
}

get_obj_from_win(win, num, obj)
     int win, num;
     struct object *obj;
{
  (*obj).x = wwin[win].obj[num].x;
  (*obj).y = wwin[win].obj[num].y;
  (*obj).wth = wwin[win].obj[num].wth;
  (*obj).hgt = wwin[win].obj[num].hgt;
  (*obj).dt = wwin[win].obj[num].dt;
}

void
set_obj_to_win(win, num, obj)
     int win, num;
     struct object *obj;
{
  int i;

  wwin[win].onum = num;
  wwin[win].obj = (struct object *)malloc(sizeof(struct object)*num);
  for (i = 0; i < num; i++) {
    wwin[win].obj[i].x = obj[i].x;
    wwin[win].obj[i].y = obj[i].y;
    wwin[win].obj[i].wth = obj[i].wth;
    wwin[win].obj[i].hgt = obj[i].hgt;
    wwin[win].obj[i].dt = obj[i].dt;
  }
}

void
set_region_to_win(win, reg)
     int win, reg;
{
  if (!wwin[win].rnum) {
    wwin[win].reg = (int *)malloc(sizeof(int));
    wwin[win].rst = (int *)malloc(sizeof(int));
  }
  else {
    wwin[win].reg = (int *)realloc(wwin[win].reg, sizeof(int)*(wwin[win].rnum+1));
    wwin[win].rst = (int *)realloc(wwin[win].rst, sizeof(int)*(wwin[win].rnum+1));
  }

  wwin[win].reg[wwin[win].rnum] = reg;
  wwin[win].rst[wwin[win].rnum] = 0;

  wwin[win].rnum++;
}


void
init_wwindow()
{
  if (!wnum)
    wwin = (struct wwindow *)malloc(sizeof(struct wwindow));
  else
    wwin = (struct wwindow *)realloc(wwin, sizeof(struct wwindow)*(wnum+1));

  wwin[wnum].win = 0;
  wwin[wnum].x = wwin[wnum].y = wwin[wnum].width = wwin[wnum].height = 0;
  wwin[wnum].parent = -1;
  wwin[wnum].status = UNMAP;
  wwin[wnum].base = 0;
  wwin[wnum].onum = wwin[wnum].rnum = 0;
  wwin[wnum].callback = 0;
}

int
make_window(win, name, mask, back)
     int win, back;
     char *name;
     long mask;
{
  Window parent;
  char *argv[2];
  XTextProperty name_prop;
  XWMHints wm_hints;
  XSetWindowAttributes winattr;
  int bw = 0;

  init_wwindow();

  if (win == -1) {
    parent = XDefaultRootWindow(display);
    bw = 2;
  }
  else
    parent = wwin[win].win;

  wwin[wnum].win = XCreateSimpleWindow(display, parent, 0, 0, 10, 10, bw, 
				      BlackPixel(display, screen), bg);

  XStringListToTextProperty(&name, 1, &name_prop);

  argv[0] = name, argv[1] = 0;
  XSetWMProperties(display, wwin[wnum].win, &name_prop, &name_prop, argv,
		   1, NULL, NULL, NULL);
  
  wm_hints.flags = InputHint;
  wm_hints.input = True;
  XSetWMHints(display, wwin[wnum].win, &wm_hints);

  XSelectInput(display, wwin[wnum].win, mask);

  winattr.colormap = colormap;
  XChangeWindowAttributes(display, wwin[wnum].win, CWColormap, &winattr);

  wwin[wnum].parent = win;

  if (back)
    wwin[wnum].base = XCreatePixmap(display, XDefaultRootWindow(display), 
				    10, 10, depth);

  wnum++;

  return (wnum-1);
}


void
grab_pointer(num)
{
  XGrabPointer(display, wwin[num].win, False, ButtonReleaseMask, GrabModeAsync,
	       GrabModeAsync, None, None, CurrentTime);
}

void
ungrab_pointer()
{
  XUngrabPointer(display, CurrentTime);
}

/* ref from xboing-2.3 */
void
xpmerror (ErrorStatus, tag)
     int ErrorStatus;
     char *tag;
{
  char *err = NULL;
  char *warn = NULL;

  switch (ErrorStatus)
    {
    case XpmSuccess:
      return;
    case XpmColorError:
      warn = "Could not parse or alloc requested colour";
      break;
    case XpmNoMemory:
      err = "Not enough memory for pixmap creation";
      break;
    case XpmColorFailed:
      warn = "Colormap is full. Make a new colormap";
      break;
    case XpmOpenFailed:
      err = "Unable to open pixmap file";
      break;
    case XpmFileInvalid:
      err = "XPM file contains invalid or corrupt data";
      break;
    default:
      err = "Unexpected xpm error code";
      break;
    }

  if (warn)
    fprintf (stdout, "$s %s - Warning: %s.\n", tag, warn);

  if (err) {
      fprintf (stderr, "$s %s - Error: %s.\n", tag, err);
      exit(2);
    }
}


int
create_imagefromdata (data, image)
     char **data;
     XImage **image;
{
  int XpmErrStatus;
  XpmAttributes attr;
  XpmColorSymbol symbol;
  int i;

  symbol.name = NULL;
  symbol.value = "none";
  symbol.pixel = bg;
  attr.valuemask = XpmColormap | XpmColorSymbols;
  attr.colormap  = colormap;
  attr.colorsymbols = &symbol;
  attr.numsymbols = 1;

  XpmErrStatus = XpmCreateImageFromData(display, data, image, NULL, &attr);

  xpmerror (XpmErrStatus, "XpmCreateImageFromData");
  return XpmErrStatus;
}

int
get_connection_number()
{
  return XConnectionNumber(display);
}

void
win_init ()
{
  display = XOpenDisplay(NULL);
  if (display == NULL)
    {
      fprintf(stderr, "unable to open display: please specify DISPLAY");
      exit(2);
    }

  screen = XDefaultScreen (display);
  depth = XDefaultDepth (display, screen);
  colormap = XDefaultColormap(display, screen);
  gc = XCreateGC(display, XDefaultRootWindow(display), 0, 0);

  initialize ();
  load_font();

  text_atom = XInternAtom(display, "COMPOUND_TEXT", False);
}

void
resize_win(win, w, h)
     int win, w, h;
{
  XSizeHints size_hints;

  size_hints.flags = PSize | PMinSize | PMaxSize;
  size_hints.width = size_hints.min_width = size_hints.max_width = w;
  size_hints.height = size_hints.min_height = size_hints.max_height = h;

  XSetWMProperties(display, wwin[win].win, NULL, NULL, NULL,
		   0, &size_hints, NULL, NULL);

  XResizeWindow(display, wwin[win].win, w, h);
  wwin[win].width = w;
  wwin[win].height = h;

  if (wwin[win].base) {
    XFreePixmap(display, wwin[win].base);
    wwin[win].base = XCreatePixmap(display, XDefaultRootWindow(display), 
				    w, h, depth);
  }
}

void
move_win(win, x, y)
     int win, x, y;
{
  XMoveWindow(display, wwin[win].win, x, y);
  wwin[win].x = x;
  wwin[win].y = y;
}

void
raise_win(win)
     int win;
{
  XRaiseWindow(display, wwin[win].win);
}

void
textcnv(str, xcstr, num)
     char *str;
     XChar2b *xcstr;
     int num;
{
  int i = 0;

  for (i = 0; i < num; i++) {
    xcstr[i].byte1 = (unsigned char) *(str++) - 128;
    xcstr[i].byte2 = (unsigned char) *(str++) - 128;
  }
}

int
textwidth(text, sc)
     char *text;
     int sc;
{
  XChar2b xcstr[BUFSIZ];
  char *tp, str[BUFSIZ];
  int count, w = 0, sc2;

  while(*text != '\0') {
    count = 0;
    if ((unsigned char) *text > 160) { /* if 2-byte code */
      tp = text;
      text += 2;
      count++;
      while(*text != '\0' && (unsigned char) *text > 160) {
	count++;
	text += 2;
      }
      textcnv(tp, xcstr, count);
      sc2 = (sc==FFNT)?SLFNT:sc;
      w += XTextWidth16(jfonts[sc2], xcstr, count);
    }
    else {
      tp = text;
      text++;
      count++;
      while(*text != '\0' && (unsigned char) *text < 160) {
	count++;
	text++;
      }
      strncpy(str, tp, count);
      w += XTextWidth(fonts[sc], str, count);
    }
  }
  return w;
}


int
textheight(text, sc)
     char *text;
     int sc;
{
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    return jfonts[sc]->ascent+jfonts[sc]->descent;
  }
  else
    return fonts[sc]->ascent+fonts[sc]->descent;
}


void 
draw_text (num, x, y, col, sc, text)
     int x, y, sc, num;
     Pixel col;
     char *text;
{
  int count = strlen(text);
  XChar2b xcstr[30];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, col);
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    XSetFont (display, gc, jfonts[sc]->fid);
    textcnv(text, xcstr, count/2);
    XDrawString16(display, win, gc, x, 
		  y+jfonts[sc]->ascent-jfonth[sc]/2, xcstr, count/2);
  }
  else {
    XSetFont (display, gc, fonts[sc]->fid);
    XDrawString (display, win, gc, x,
		 y+fonts[sc]->ascent-fonth[sc]/2, text, count);
  }
}

void 
draw_image_text (num, x, y, fcol, bcol, sc, text)
     int x, y, sc, num;
     Pixel fcol, bcol;
     char *text;
{
  int count = strlen(text);
  XChar2b xcstr[30];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, fcol);
  XSetBackground (display, gc, bcol);
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    XSetFont (display, gc, jfonts[sc]->fid);
    textcnv(text, xcstr, count/2);
    XDrawImageString16(display, win, gc, x, 
		  y+jfonts[sc]->ascent-jfonth[sc]/2, xcstr, count/2);
  }
  else {
    XSetFont (display, gc, fonts[sc]->fid);
    XDrawImageString (display, win, gc, x,
		 y+fonts[sc]->ascent-fonth[sc]/2, text, count);
  }
  XSetBackground (display, gc, bg);
}

void 
draw_rev_text (num, x, y, col, sc, text)
     int x, y, sc, num;
     Pixel col;
     char *text;
{
  int count = strlen(text);
  XChar2b xcstr[30];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, bg);
  XSetBackground (display, gc, col);
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    XSetFont (display, gc, jfonts[sc]->fid);
    textcnv(text, xcstr, count/2);
    XDrawImageString16(display, win, gc, x, 
		  y+jfonts[sc]->ascent-jfonth[sc]/2, xcstr, count/2);
  }
  else {
    XSetFont (display, gc, fonts[sc]->fid);
    XDrawImageString (display, win, gc, x,
		 y+fonts[sc]->ascent-fonth[sc]/2, text, count);
  }
  XSetBackground (display, gc, bg);
}

void 
draw_ctext (num, x, y, col, sc, text)
     int x, y, sc, num; /* (x, y) is the center of the text */
     Pixel col;
     char *text;
{
  int w, count = strlen(text);
  XChar2b xcstr[30];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, col);
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    XSetFont (display, gc, jfonts[sc]->fid);
    textcnv(text, xcstr, count/2);
    w = XTextWidth16(jfonts[sc], xcstr, count/2);
    XDrawString16(display, win, gc, x-w/2, 
		  y+jfonts[sc]->ascent-jfonth[sc]/2, xcstr, count/2);
  }
  else {
    XSetFont (display, gc, fonts[sc]->fid);
    w = XTextWidth(fonts[sc], text, count);
    XDrawString (display, win, gc, x-w/2,
		 y+fonts[sc]->ascent-fonth[sc]/2, text, count);
  }
}

void 
draw_rtext (num, x, y, col, sc, text)
     int x, y, sc, num;
     Pixel col;
     char *text;
{
  int w, count = strlen(text);
  XChar2b xcstr[30];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, col);
  if ((unsigned char) *text > 160) { /* if 2-byte font */
    if (sc == FFNT) sc = SLFNT;
    XSetFont (display, gc, jfonts[sc]->fid);
    textcnv(text, xcstr, count/2);
    w = XTextWidth16(jfonts[sc], xcstr, count/2);
    XDrawString16(display, win, gc, x-w, 
		  y+jfonts[sc]->ascent-jfonth[sc]/2, xcstr, count/2);
  }
  else {
    XSetFont (display, gc, fonts[sc]->fid);
    w = XTextWidth(fonts[sc], text, count);
    XDrawString (display, win, gc, x-w,
		 y+fonts[sc]->ascent-fonth[sc]/2, text, count);
  }
}

void
draw_cotext(num, x, y, col, sc, text)
     int x, y, sc, num;
     Pixel col;
     char *text;
{
  XChar2b xcstr[BUFSIZ];
  char *tp, str[BUFSIZ];
  int count, x2 = x, sc2;
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, col);

  while(*text != '\0') {
    count = 0;
    if ((unsigned char) *text > 160) { /* if 2-byte code */
      tp = text;
      text += 2;
      count++;
      while(*text != '\0' && (unsigned char) *text > 160) {
	count++;
	text += 2;
      }
      textcnv(tp, xcstr, count);
      sc2 = (sc==FFNT)?SLFNT:sc;
      XSetFont (display, gc, jfonts[sc2]->fid);
      XDrawString16 (display, win, gc, x2, 
		     y+jfonts[sc2]->ascent-jfonth[sc2]/2, xcstr, count);
      x2 += XTextWidth16(jfonts[sc2], xcstr, count);
    }
    else {
      tp = text;
      text++;
      count++;
      while(*text != '\0' && (unsigned char) *text < 160) {
	count++;
	text++;
      }
      strncpy(str, tp, count);
      XSetFont (display, gc, fonts[sc]->fid);
      XDrawString (display, win, gc, x2, 
		   y+fonts[sc]->ascent-fonth[sc]/2, str, count);
      x2 += XTextWidth(fonts[sc], str, count);
    }
  }
}

int win_have_event()
{
  return XEventsQueued(display, QueuedAfterReading);
}


void
set_linewidth(w)
     int w;
{
  XSetLineAttributes(display, gc, w, LineSolid, CapButt, JoinMiter);
}


void
ThreeDframe (num, x, y, w, h, lw, pos)
     int pos, x, y, w, h, lw, num;
{
  XPoint points[6];
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  points[0].x = points[5].x = x;
  points[0].y = points[1].y = y;
  points[1].x = x + w;
  points[2].x = x + w - lw;
  points[2].y = points[3].y = y + lw;
  points[3].x = points[4].x = x + lw;
  points[4].y = y + h - lw;
  points[5].y = y + h;

  set_linewidth(1);

  if (!pos)
    XSetForeground (display, gc, flcol);
  else
    XSetForeground (display, gc, fdcol);

  XFillPolygon (display, win, gc, points, 6, Nonconvex, CoordModeOrigin);

  points[0].x = points[1].x;
  points[0].y = points[5].y;
  points[3].x = points[2].x;
  points[3].y = points[4].y;

  if (pos)
    XSetForeground (display, gc, flcol);
  else
    XSetForeground (display, gc, fdcol);

  XFillPolygon (display, win, gc, points, 6, Nonconvex, CoordModeOrigin);
}


void
ThreeDframe2 (win, x, y, w, h, lw)
     int x, y, w, h, lw, win;
{
  ThreeDframe (win, x, y, w, h, lw, 0);
  ThreeDframe (win, x+lw, y+lw, w-lw*2, h-lw*2, lw, 1);
}


void
win_copyarea(win1, win2, x1, y1, w, h, x2, y2)
     int x1, y1, w, h, x2, y2, win1, win2;
{
  Drawable w1, w2;

  w1 = (wwin[win1].base)?wwin[win1].base:wwin[win1].win;
  w2 = (wwin[win2].base)?wwin[win2].base:wwin[win2].win;
  XCopyArea(display, w1, w2, gc, x1, y1, w, h, x2, y2);
}


void
win_flush ()
{
  XFlush (display);
}



void
mapping(num, x, y, w, h)
     int num, x, y, w, h;
{
  if (wwin[num].base)
    XCopyArea(display, wwin[num].base, wwin[num].win, gc, x, y, w, h, x, y);
}

void open_win1(win, num)
     int win, num;
{
  int i, whalf, hhalf, nwpix, nhpix, w, h;

  w = win_width(win);
  h = win_height(win);
  whalf = w/2;
  hhalf = h/2;
  nwpix = (whalf/num)+1;
  nhpix = (hhalf/num)+1;

  for (i = 1; i < num ; i++) {
    mapping(win, whalf-i*nwpix, hhalf-i*nhpix, 2*i*nwpix, nhpix);
    mapping(win, whalf-i*nwpix, hhalf+(i-1)*nhpix, 2*i*nwpix, nhpix);
    mapping(win, whalf-i*nwpix, hhalf-i*nhpix, nwpix, 2*i*nhpix);
    mapping(win, whalf+(i-1)*nwpix, hhalf-i*nhpix, nwpix, 2*i*nhpix);
    win_flush();
  }
}


void open_win2(win, num)
     int win, num;
{
  int i, whalf, hhalf, nwpix, nhpix, w, h;

  w = win_width(win);
  h = win_height(win);
  whalf = w/2;
  hhalf = h/2;
  nwpix = (whalf/num)+1;
  nhpix = (hhalf/num)+1;

  for (i = 0; i < num ; i++) {
    mapping(win, i*nwpix, i*nhpix, w-2*i*nwpix, nhpix);
    mapping(win, i*nwpix, h-(i+1)*nhpix, w-2*i*nwpix, nhpix);
    mapping(win, i*nwpix, i*nhpix, nwpix, h-2*i*nhpix);
    mapping(win, w-(i+1)*nwpix, i*nhpix, nwpix, h-2*i*nhpix);
    win_flush();
  }
}


Pixmap
create_pixmap(w, h)
     int w, h;
{
  return XCreatePixmap(display, XDefaultRootWindow(display), w, h, depth);
}

void
draw_rectangle(num, x, y, w, h, col)
     int x, y, w, h, num;
     Pixel col;
{
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XSetForeground (display, gc, col);
  XDrawRectangle(display, win, gc, x, y, w, h);
}

void
draw_bitmap(num, data, x, y, w, h, col)
     char *data;
     int x, y, w, h, num;
     Pixel col;
{
  Pixmap pmap;
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  pmap = XCreatePixmapFromBitmapData(display, XDefaultRootWindow(display), 
				     data, w, h, col, bg, depth);
  XCopyArea(display, pmap, win, gc, 0, 0, w, h, x, y);

  XFreePixmap(display, pmap);
}


void
get_image(num, image, x, y, w, h)
     int x, y, w, h, num;
     XImage **image;
{
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  *image = XGetImage(display, win, x, y, w, h, AllPlanes, ZPixmap);
}


void
put_image(num, image, x, y, w, h)
     int x, y, w, h, num;
     XImage *image;
{
  Drawable win;

  win = (wwin[num].base)?wwin[num].base:wwin[num].win;
  XPutImage(display, win, gc, image, 0, 0, x, y, w, h);
}

void
expose_win(num)
     int num;
{
  if (wwin[num].base)
    mapping(num, 0, 0, wwin[num].width, wwin[num].height);
  else if (wwin[num].callback)
    (*(wwin[num].callback)) ();

  wwin[num].status = MAP;
}

void
set_expose_func(num, func)
     int num;
     void (*func) ();
{
  wwin[num].callback = func;
}

#define RegionSelected 100
#define Exposed 150
#define Invisible 200

void
win_map (win)
     int win;
{
  int i;
  XWindowAttributes attr;

  XMapWindow (display, wwin[win].win);
  win_flush();
  wwin[win].status = MAP;
  XGetWindowAttributes(display, wwin[win].win, &attr);
  if (attr.map_state != IsUnviewable) {
    while((i = win_handle_event ()) != Exposed+win 
	  && i != Invisible+win);
    if (i == Invisible+win)
      wwin[win].status = INVISIBLE;
  }
  else
    wwin[win].status = INVISIBLE;
}

void
win_map_normal (win)
     int win;
{
  XMapWindow (display, wwin[win].win);
  win_flush();
  wwin[win].status = MAP;
}

void
win_unmap (win)
     int win;
{
  if (wwin[win].status == UNMAP)
    return;

  XUnmapWindow (display, wwin[win].win);
  win_flush();

  if (wwin[win].status == MAP) 
    while(win_handle_event () != Exposed+wwin[win].parent
	  && wwin[win].status == MAP);

  wwin[win].status = UNMAP;
}

void
win_unmap_normal (win)
     int win;
{
  XUnmapWindow (display, wwin[win].win);
  win_flush();
  wwin[win].status = UNMAP;
}

int
win_handle_event ()
{
  int i, j, flag = 0;
  XEvent xevent;

  XNextEvent (display, &xevent);

  switch (xevent.type)
    {
    case VisibilityNotify:
      for (i = 0; i < wnum; i++)
	if (xevent.xvisibility.window == wwin[i].win) {
	  if (xevent.xvisibility.state == VisibilityFullyObscured) {
	    wwin[i].status = INVISIBLE;
	    flag = Invisible+i;
	  }
	  else 
	    wwin[i].status = MAP;
	  break;
	}
      break;
    case Expose:
      for (i = 0; i < wnum; i++)
	if (xevent.xexpose.window == wwin[i].win) {
	  expose_win(i);
	  flag = Exposed+i;
	  break;
	}
      break;
    case ButtonPress:
      for (i = 0; i < wnum; i++)
	if (xevent.xbutton.window == wwin[i].win) {
	  if (xevent.xbutton.button == 1)
	    check_region(xevent.type, i, xevent.xbutton.x, xevent.xbutton.y);
	  break;
	}
      break;
    case ButtonRelease:
      flag = 1;
      switch (xevent.xbutton.button)
	{
	case 1:
	  for (i = 0; i < wnum; i++)
	    if (xevent.xbutton.window == wwin[i].win) {
	      if (check_region(xevent.type, i,
			       xevent.xbutton.x, xevent.xbutton.y))
		flag = RegionSelected;
	      break;
	    }
	  draw_released_button();
	  break;
	case 3:
	  select_cancel(0);
	  flag = RegionSelected;
	  break;
	case 2:
	  XConvertSelection(display, XA_PRIMARY, text_atom, None,
			    xevent.xbutton.window, CurrentTime);
	  break;
	}
      break;
    case KeyPress:
      input_textbox(xevent.xkey);
      break;
    case SelectionNotify:
      paste_textbox(xevent.xselection);
      break;
    case ClientMessage:
      KinputCheckClientMessage ((XClientMessageEvent *)&xevent);
      break;
    case PropertyNotify:
      input_from_kinput((XPropertyEvent *)&xevent);
      break;
    }
  win_flush();
  return flag;
}
