/* msg.c for kan netmaj */
#include "xnet.h"
#include "strdef.h"

int mkind, ckind;
extern int fonth[4], jfonth[2];
char tmessage[50];

void
popup_playmessage ()
{
  win_cleararea(msg2, 0, 0, 300, 60);
  ThreeDframe2(msg2, 0, 0, 300, 60, 1);
  draw_ctext(msg2, 150, 30, cols.mess, SLFNT, conn_mes[ckind]);
}

void
popup_declmessage()
{
  int w = win_width(msg1), h = win_height(msg1);
  char *str;

  win_cleararea(msg1, 0, 0, w, h);
  ThreeDframe2(msg1, 0, 0, w, h, 1);
  if (mkind > 3)
    str = but1_label[mkind-4];
  else
    str = but2_label[mkind];
    
  draw_ctext(msg1, w/2, h/2, cols.mess, BGFNT, str);
}

void 
message_init()
{
  int i, w, h;

  w = 0;
  for (i = 0; i < 3; i++) {
    if (textwidth(but1_label[i], BGFNT) > w)
      w = textwidth(but1_label[i], BGFNT);
  }
  for (i = 0; i < 4; i++) {
    if (textwidth(but2_label[i], BGFNT) > w)
      w = textwidth(but2_label[i], BGFNT);
  }
  w += 10;

  h  = nmax(fonth[BGFNT], jfonth[BGFNT])+10;
  /* some message windows */
  msg1 = make_window(main_win, "", MASK, 0);
  resize_win(msg1, w, h);
  set_expose_func(msg1, (void *)popup_declmessage);
  msg2 = make_window(main_win, "", MASK, 0);
  resize_win(msg2, 300, 60);
  set_expose_func(msg2, (void *)popup_playmessage);

  move_win(msg2, win_width(main_win)/2 - 150, win_height(main_win)/2 - 60);
}


void
ui_message_connecting ()
{
  ckind = 0;
  win_map(msg2);
  sleep (2);
  win_unmap(msg2);
}

void
ui_message_connect ()
{
  ckind = 1;
  win_map(msg2);
  sleep (5);
  win_unmap(msg2);
}

void
ui_message_disconnect ()
{
  ckind = 2;
  win_map(msg2);
  sleep (2);
  win_unmap(msg2);
}

void
draw_message(i)
     int i;
{
  int x, y;

  get_drawing_pos(i, 0, &x, &y);
  move_win(msg1, x+5, y+5);
  win_map(msg1);
  sleep (2);
  win_unmap(msg1);
}


void
ui_message_reach (i)
{
  mkind = 4;
  draw_message(i);
}

void
ui_message_tumo (i)
{
  mkind = 6;
  draw_message(i);
}

void
ui_message_ron (i)
{
  mkind = 3;
  draw_message(i);
}

void
ui_message_naki(i,kind) 
     int i, kind;
{
  mkind = kind;
  draw_message(i);
}


void
ui_message_player (gp)
     global_t *gp;
{
  ui_draw(gp, 1);
}

void
ui_message_play (gp) {}

void
comment (i, mode, str, time)
     int i, mode, time;
     char *str;
{
  int x, y;

  strcpy(tmessage, str); 
  get_drawing_pos(i, 0, &x, &y);
  resize_win(msg5, textwidth(tmessage, SLFNT)+20, 
	     nmax(fonth[SLFNT], jfonth[SLFNT])+12);
  move_win(msg5, x+5, y+5);
  win_map(msg5);
  sleep (time/10);
  win_unmap(msg5);
}
