// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *               2003 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVWIDGET_H
#define KDETVWIDGET_H

#include <qhbox.h>

#include "kdetv.h"
#include "libkdetv_export.h"

class QPopupMenu;

/**
 * A widget that displays a television picture.
 *
 * @author Richard Moore, rich@kde.org
 */

class KdetvWidget : public QHBox
{
    Q_OBJECT

public:
    /**
     * Creates a TV widget.
     */
    LIBKDETV_EXPORT KdetvWidget( QWidget *parent=0, const char *name=0, int wflags=0 );

    /**
     * Creates a TV widget with a specified driver.
     */
    LIBKDETV_EXPORT KdetvWidget( Kdetv *ktv, QWidget *parent=0, const char *name=0, int wflags=0 );

    /**
     * Cleans up.
     */
    virtual ~KdetvWidget();

    /**
     * Returns the Kdetv object driving the TV picture.
     */
    Kdetv *driver() const { return ktv; }

    /**
     * Returns the internal screen widget.
     */
    KdetvView *view() const { return screen; }

    /**
     * Returns a DCOP reference to the driver object.
     */
    DCOPRef driverIface() const;

    /**
     * Returns the current channel store.
     */
    ChannelStore *channels() const { return (ktv ? ktv->channels() : 0); }

    /**
     * Returns the current view manager.
     */
    ViewManager *views() const { return (ktv ? ktv->views() : 0); }

    /**
     * Adds the specified context menu to the screen widget.
     *
     * @see KContextMenuManager
     */
    LIBKDETV_EXPORT void addContextMenu( QPopupMenu *pop );


public slots:
    /**
     * Sets the Kdetv object that drives the TV picture.
     */
    void setDriver( Kdetv *ktv );


private:
    Kdetv *ktv;
    KdetvView *screen;
};

#endif
