// -*- c++ -*-
/***************************************************************************
                           channelsuitedialogimpl.h
                           ------------------------
    begin                : Sat Apr 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __CHANNELSUITEWIDGETIMPL_H
#define __CHANNELSUITEWIDGETIMPL_H

#include "channelsuitewidget.h"

class Channel;
class Kdetv;
class SettingsDialogPage;
class ChannelSuiteDb;
class KConfig;

class ChannelSuiteWidgetImpl : public ChannelSuiteWidget
{
    Q_OBJECT

public:
    ChannelSuiteWidgetImpl( Kdetv* ktv, KConfig* cfg, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~ChannelSuiteWidgetImpl();


public slots:
    void apply();
    void cancel();


private slots:
    void loadClicked();
    void loadDone(bool);
    void nowClicked();
    void importClicked();
    void importDone(bool);
    void contributeClicked();
    void suiteSelectionChanged();
    void countrySelectionChanged();
    void updateMetaInfo();


private:
    Kdetv*              _ktv;
    SettingsDialogPage* _sdlg;
    ChannelSuiteDb*     _db;
    KConfig*            _cfg;
};

#endif
