/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005,2008 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#include "uploaddlg.h"

#include <QLabel>
#include <QPushButton>
#include <QProgressBar>
#include <QApplication>

#include <ui_uploaddlg.h>

class UploadDlg::PrivateData
{
 public:
  PrivateData()
    : overall(-1)
  {
  }

  Ui::UploadDlg ui;              /// The widget UI

  /** Needed to track progress since the doco says you can have
   *  -ve progress yet if set to  -ve progress() returns 0??
   *  @todo maybe check in QT4 if this is fixed and remove this workaround.
   */
  int overall;
};

UploadDlg::UploadDlg(QWidget* parent)
  : QDialog(parent)
  , d(*(new UploadDlg::PrivateData()))
{
  // Initialize widgets
  d.ui.setupUi(this);

  d.ui.overallProgress->setValue(0);
  d.ui.pixmap->setScaledContents(false);
}


UploadDlg::~UploadDlg()
{
  delete &d;
}

void UploadDlg::setPixmap(const QPixmap& pixmap)
{
  d.ui.pixmap->setPixmap(pixmap);
}

void UploadDlg::setNumPhotos(int total)
{
  d.ui.overallProgress->setMaximum(total);
}

void UploadDlg::setNumCompleted(int num)
{
  d.overall = num;
  d.ui.overallProgress->setValue(d.overall);
}

void UploadDlg::advance(int amount)
{
  d.overall += amount;
  d.ui.overallProgress->setValue(d.overall);
}
