typedef struct
{
	gint player_x, player_y;
	gint playlist_x, playlist_y, playlist_width, playlist_height;
	gint equalizer_x, equalizer_y;
	guint snap_distance;
	gboolean use_realtime, shuffle, repeat, doublesize, autoscroll,
	         analyzer_peaks;
	gboolean playlist_visible, equalizer_visible, equalizer_active,
	         player_visible;
	gboolean equalizer_autoload, easy_move, player_shaded, playlist_shaded, equalizer_shaded;
	gboolean allow_multiple_instances, always_show_cb;
	gboolean convert_underscore, convert_twenty;
	gboolean show_numbers_in_pl, snap_windows, save_window_position;
	gboolean dim_titlebar, save_playlist_position;
	gboolean open_rev_order, get_info_on_load;
	gboolean get_info_on_demand, eq_doublesize_linked;
	gboolean sort_jump_to_file, use_eplugins, always_on_top, sticky;
	gboolean no_playlist_advance, smooth_title_scroll;
	gboolean use_backslash_as_dir_delimiter, random_skin_on_play;
	gfloat equalizer_preamp, equalizer_bands[10];
	gchar *skin, *outputplugin, *filesel_path, *playlist_font;
	gchar *effectplugin;
	gchar *disabled_iplugins, *enabled_gplugins, *enabled_vplugins;
	gint timer_mode, vis_type, analyzer_mode, analyzer_type, scope_mode,
	     vu_mode, vis_refresh;
	gint analyzer_falloff, peaks_falloff;
	gint playlist_position;
	gint pause_between_songs_time;
	gboolean pause_between_songs;
	gint mouse_change;
} Config;

extern Config cfg;


typedef struct _Widget
{
	GdkPixmap *parent;
	GdkGC *gc;
	gint x, y, width, height, visible;
	void (*button_press_cb) (GtkWidget *, GdkEventButton *, gpointer);
	void (*button_release_cb) (GtkWidget *, GdkEventButton *, gpointer);
	void (*motion_cb) (GtkWidget *, GdkEventMotion *, gpointer);
	void (*draw) (struct _Widget *);
	gboolean redraw;
	pthread_mutex_t mutex;
}
Widget;

typedef struct
{
	Widget es_widget;
	gint es_position;
	gboolean es_isdragging;
	gint es_drag_y;
}
EqSlider;

extern EqSlider *equalizerwin_bands[10];
void eqslider_set_position(EqSlider * es, gfloat pos);
void equalizerwin_eq_changed(void);
void equalizerwin_on_pushed(gboolean toggled);
