/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITABBSVIEW_H_
#define _KITABBSVIEW_H_

#include <kparts/browserextension.h>

#include <qwidget.h>

#include "bbsviewbase.h"

class KURL;
class QCp932Codec;

namespace Kita
{
    class Board;
    class Category;
    class ListViewItem;
}

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class KitaBBSView : public KitaBBSViewBase
{
    Q_OBJECT
    Kita::ListViewItem* m_favorites;
    static QCp932Codec* m_cp932Codec;

    /* list color */
    QColor m_textColor;
    QColor m_baseColor;
    QColor m_backColor;
    QColor m_altColor;

    QString getCategory( const QString& line ) const;
    QString getBoardURL( const QString& line ) const;
    bool isBoardURL( const QString& url ) const;
    QValueList<Kita::Category> getCategoryList( const QString& html ) const;

    void saveOpened();

private slots:
    void loadBoard( QListViewItem* item );
    void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
    void slotMouseButtonClicked( int, QListViewItem* );
    void refreshFavoriteBoards();
    void filter( const QString& str );

public:
    KitaBBSView( QWidget *parent, const char *name = 0 );
    ~KitaBBSView();

    void loadOpened();

public slots:
    void updateBoardList();
    void showBoardList();
    void setFont( const QFont& font );
    virtual void setFocus();

private:
    void loadExtBoard();
    bool downloadBoardList();

signals:
    void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                            QString mimetype = QString::null,
                            int usr1 = 0,
                            const KURL& usrUrl1 = KURL() );
    void sigShowSubject();
};

#endif
