/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "listviewitem.h"

using namespace Kita;

ListViewItem::ListViewItem( QListView *parent, QListViewItem *after,
                            QString label1, QString label2, QString label3, QString label4,
                            QString label5, QString label6, QString label7, QString label8 )
        : KListViewItem( parent, after, label1, label2, label3, label4, label5, label6, label7, label8 )
{
    init();
}

ListViewItem::ListViewItem( QListViewItem *parent, QListViewItem *after,
                            QString label1, QString label2, QString label3, QString label4,
                            QString label5, QString label6, QString label7, QString label8 )
        : KListViewItem( parent, after, label1, label2, label3, label4, label5, label6, label7, label8 )
{
    init();
}

ListViewItem::ListViewItem( QListView* parent, QString label1, QString label2 )
        : KListViewItem( parent, label1, label2 )
{
    init();
}

ListViewItem::ListViewItem( QListViewItem* parent, QString label1, QString label2 )
        : KListViewItem( parent, label1, label2 )
{
    init();
}

ListViewItem::~ListViewItem()
{}

/* private */
void ListViewItem::init()
{
    QColorGroup colors = listView() ->viewport() ->colorGroup();
    m_textColor = colors.text();
    m_baseColor = colors.base();
}

/* public */
void ListViewItem::setColor( QColor textColor, QColor baseColor )
{
    m_textColor = textColor;
    m_baseColor = baseColor;
}

/* public */ /* virtual */
void ListViewItem::paintCell( QPainter *p, const QColorGroup &cg,
                              int column, int width, int align )
{
    QColorGroup color = cg;
    color.setColor( QColorGroup::Text, m_textColor );
    color.setColor( QColorGroup::Base, m_baseColor );
    KListViewItem::paintCell( p, color, column, width, align );
}
