/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef FAVORITETHREADS_H
#define FAVORITETHREADS_H

#include <kurl.h>

#include <qmap.h>
#include <qxml.h>
#include <qptrlist.h>
#include <qdict.h>

class QDomNode;

/**
@author Hideki Ikemoto
*/
class FavoriteThreadItem
{
public:
    QString m_datURL;
    FavoriteThreadItem();
    FavoriteThreadItem( const QString& datURL ) { m_datURL = datURL; }
    ~FavoriteThreadItem();

    bool operator==( const FavoriteThreadItem& item ) const;
};

class FavoriteThreads
{
    static FavoriteThreads* instance;
    QValueList<FavoriteThreadItem> m_threadList;
    FavoriteThreads();
    ~FavoriteThreads();
    const QValueList<FavoriteThreadItem> threadList() const;
public:
    static FavoriteThreads* getInstance();
    void insert( const QString& datURL );
    void remove( const QString& datURL );
    static bool contains( const QString& datURL );
    const QString toXML() const;
    static bool readFromXML( const QString& xml );
    static void processThreadNode( QDomNode& node );
    static void replace( QString fromURL, QString toURL );
    // FIXME: use Iterator
    static QString getDatURL( int i );
static int count() { return getInstance() ->m_threadList.count(); }
};

#endif
