/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "instwizard.h"

instWizard::instWizard(QWidget *parent, const char *name, QString * driver) : QDialog(parent, name, true)
{
QString commentText = tr("The wizard will help you to locate the appropriate inf-file and the according sys-file for the \
installation of the windows driver.\n\nFirst select the proper device from the device list.\n\nBy pressing the button right \
to the list, the offline file from the ndiswrapper wiki (card known to work) is displayed. You maybe find helpful information \
for your hardware.\n\nNext you have to tell the wizard from where to start the search run. If you got a dual boot system and the \
appropriate driver is already installed in the windows system you may mount the windows partition and give the mountpoint as \
starting point for the search run.\n\nThe result of the search run is displayed in the list below.\nSelect a driver from the list \
and press the install button.\n\nThe wizard even tries to find the correct sys-file if it is not located in the same folder as the \
inf-file.");

QString delPath = (QString)"rm -rf " + (QString)getenv("HOME") + (QString)"/.kndiswrapper/temp";
  this->setCaption(tr("KNDISWrapper Installation Wizard"));
  system(delPath);
  driverRC = driver;
  this->setFixedSize(750,400);

  comment = new QMultiLineEdit(this);
  comment->setFont(QFont("Helvetic",10,QFont::Normal,true));
  comment->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  comment->setText(commentText);
  comment->setReadOnly(true);

  headerLabel = new QLabel(tr("Installation Wizard"),this,"headerLabel");
  headerLabel->setFont(QFont("Helvetic",24,QFont::Bold,true));
  headerLabel->setFrameStyle(QFrame::Panel|QFrame::Raised);

  lsusbProcess = new QProcess(this);
  lsusbProcess->addArgument("lsusb");
  connect(lsusbProcess,SIGNAL(processExited()),this,SLOT(slot_lsusbProcessExited()));

  mainFrame = new QFrame(this);
  mainFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  driverFrame = new QFrame(this);
  driverFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  driverLabel = new QLabel(tr("Driver : "),this,"driverLabel");
  driverLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));

  driverEdit = new QLineEdit(this,"driverEdit");
  driverEdit->setReadOnly(false);

  deviceLabel = new QLabel(tr("Select Device : "),this,"deviceLabel");
  deviceLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));

  searchLabel = new QLabel(tr("start search from : "),this,"searchLabel");
  searchLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));

  possibleHitsLabel = new QLabel(tr("Possible Hits :"),this,"possibleHitsLabel");
  possibleHitsLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));

  deviceComboBox = new QComboBox(this,"deviceComboBox");
  searchPath = new QLineEdit("/",this,"searchPath");

  startSearchButton = new QPushButton(tr("search driver"),this,"startSearchButton");
  startSearchButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
  connect(startSearchButton,SIGNAL(clicked()),this,SLOT(slot_startSearchButtonClicked()));

  fileSelectButton = new QPushButton("...",this,"fileSelectButton");
  QToolTip::add(fileSelectButton,tr("Click to select a folder from where the search should start ..."));
  connect(fileSelectButton,SIGNAL(clicked()),this,SLOT(slot_fileSelectButtonClicked()));

  wikiLookupButton = new QPushButton("...",this,"wikiLookupButton");
  QToolTip::add(wikiLookupButton,tr("Click to open the offline ndiswrapper wiki"));
  connect(wikiLookupButton,SIGNAL(clicked()),this,SLOT(slot_wikiLookupButtonClicked()));

  startInstButton = new QPushButton(tr("Start Installation"),this,"startInstButton");
  QToolTip::add(startInstButton,tr("Start the installation of the selected windows driver."));
  connect(startInstButton,SIGNAL(clicked()),this,SLOT(slot_startInstButtonClicked()));

  cancelInstButton = new QPushButton(tr("Cancel Installation"),this,"cancelInstButton");
  QToolTip::add(cancelInstButton,tr("Cancel the installation."));
  connect(cancelInstButton,SIGNAL(clicked()),this,SLOT(slot_cancelInstButtonClicked()));

  searchProcess = new QProcess(this);
  connect(searchProcess,SIGNAL(processExited()),this,SLOT(slot_searchProcessExited()));

  searchProcess2 = new QProcess(this);
  connect(searchProcess2,SIGNAL(processExited()),this,SLOT(slot_searchProcess2Exited()));

  resultTable = new QTable(0,2,this,"resultTable");
  resultTable->horizontalHeader()->setLabel(0,tr("No."));
  resultTable->horizontalHeader()->setLabel(1,tr("Path"));
  connect(resultTable,SIGNAL(clicked(int,int,int,const QPoint &)),this,SLOT(slot_resultTableClicked()));

  lsusbProcess->start();
}


instWizard::~instWizard()
{
}

void instWizard::resizeEvent(QResizeEvent * e){
  e = e; // just to keep the compiler happy ....

  comment->setGeometry(5,5,240,this->height()-10);
  headerLabel->setGeometry(250,5,this->width()-260,40);
  mainFrame->setGeometry(250,55,this->width()-260,this->height()-130);
  deviceLabel->setGeometry(mainFrame->x()+5,mainFrame->y()+5,120,20);
  deviceComboBox->setGeometry(deviceLabel->x()+deviceLabel->width()+5,deviceLabel->y(),mainFrame->width()-deviceLabel->width()-65,20);
  wikiLookupButton->setGeometry(deviceComboBox->x()+deviceComboBox->width()+5,deviceComboBox->y(),40,20);
  searchLabel->setGeometry(deviceLabel->x(),deviceLabel->y()+deviceLabel->height()+10,deviceLabel->width(),deviceLabel->height());
  searchPath->setGeometry(searchLabel->x()+searchLabel->width()+5,searchLabel->y(),deviceComboBox->width(),deviceComboBox->height());
  fileSelectButton->setGeometry(searchPath->x()+searchPath->width()+5,searchPath->y(),40,20);
  possibleHitsLabel->setGeometry(mainFrame->x()+5,searchPath->y()+searchPath->height()+15,100,20);
  startSearchButton->setGeometry(mainFrame->x()+mainFrame->width()-160,possibleHitsLabel->y(),150,possibleHitsLabel->height());
  resultTable->setGeometry(mainFrame->x()+5,searchPath->y()+searchPath->height()+40,mainFrame->width()-10,mainFrame->height()-100);
  resultTable->setColumnWidth(0,50);
  resultTable->setColumnWidth(1,resultTable->width()-100);
  driverFrame->setGeometry(mainFrame->x(),mainFrame->y()+mainFrame->height()+5,mainFrame->width(),30);
  driverLabel->setGeometry(driverFrame->x()+5,driverFrame->y()+5,50,20);
  driverEdit->setGeometry(driverLabel->x()+driverLabel->width()+5,driverLabel->y(),driverFrame->width()-driverLabel->width()-15,driverLabel->height());
  startInstButton->setGeometry(this->width()-160,this->height()-30,150,20);
  cancelInstButton->setGeometry(mainFrame->x(),startInstButton->y(),startInstButton->width(),startInstButton->height());
}


void instWizard::slot_lsusbProcessExited(){
QString line;
QString entry;
QStringList lst;
int pos;

  while (lsusbProcess->canReadLineStdout()){
    line = lsusbProcess->readLineStdout();
    pos = line.find("ID ");
    entry = line.mid(pos+3);
    if (entry.find("0000:0000")) lst << entry;
  }
  deviceComboBox->insertStringList(lst);
}

void instWizard::slot_fileSelectButtonClicked(){
QString path = QFileDialog::getExistingDirectory("/home",this,tr("Select the directory to start the search from ..."),tr("Select the directory to start the search from ..."),true);

  searchPath->setText(path);
}

void instWizard::slot_wikiLookupButtonClicked(){
wikiLookup * wiki = new wikiLookup(this,"wiki",1);
  wiki->exec();
}

void instWizard::slot_startSearchButtonClicked(){
  startSearchButton->setEnabled(false);
  while (resultTable->numRows() > 0) resultTable->removeRow(0);
  searchProcess->clearArguments();
  searchProcess->addArgument("find");
  searchProcess->addArgument(searchPath->text());
  searchProcess->addArgument("-iname");
  searchProcess->addArgument("*.inf");
  searchProcess->addArgument("-print");
  searchProcess->start();
}

void instWizard::slot_searchProcessExited(){
QString line;
QString line2;
QString searchTerm="VID_" + deviceComboBox->currentText().left(4) + "&PID_" + deviceComboBox->currentText().mid(5,4);
QFile file;
bool found=false;

int count=1;
  while (searchProcess->canReadLineStdout()){
    found = false;
    line = searchProcess->readLineStdout();
    file.setName(line);
    if (file.open(IO_ReadOnly)){
      QTextStream stream(&file);
      while ((found == false) && (!stream.atEnd())){
        line2 = stream.readLine();
        if (line2.find(searchTerm,0,false) != -1){
          found = true;
        }
      }
    }
    file.close();
    if (found){
      resultTable->insertRows(resultTable->numRows(),1);
      resultTable->setText(resultTable->numRows()-1,0,QString::number(count++));
      resultTable->setText(resultTable->numRows()-1,1,line);
    }
  }
  possibleHitsLabel->setText(tr("Possible Hits : ") + QString::number(resultTable->numRows()));
  startSearchButton->setEnabled(true);
}

void instWizard::slot_resultTableClicked(){
  driverEdit->setText(resultTable->text(resultTable->currentRow(),resultTable->currentColumn()));
}

void instWizard::slot_cancelInstButtonClicked(){
  this->done(QDialog::Rejected);
}

void instWizard::slot_startInstButtonClicked(){
bool ok=false;
QString serviceBinary;
QString line;
QString temp = driverEdit->text();
int pos=temp.findRev("/");
QString path = temp.left(pos+1);
QString infFile = temp.mid(pos+1);

  if (driverEdit->text() == ""){
    QMessageBox::information(this,tr("WARNING"),tr("You must select a driver from the list first!"));
  } else {
    QFile file(driverEdit->text());
    if (file.open(IO_ReadOnly)){
      QTextStream stream(&file);
      while (!stream.atEnd()){
        line = stream.readLine();
        if (line.find("servicebinary",0,false) != -1){
          pos = line.findRev("\\");
          serviceBinary=line.mid(pos+1);
          ok = QFile::exists(path+serviceBinary);
          if (!ok) {
            serviceBinary=line.mid(pos+1).lower();
            ok = QFile::exists(path+serviceBinary);
          }
        }
      }
    }
    if (ok){
      *driverRC = driverEdit->text();
      this->done(QDialog::Accepted);
    } else {
        QMessageBox::critical(this,tr("ERROR"),tr("The file \"") + serviceBinary + tr("\" is required and was not found in \"") + path + tr("\".\nI will try to find the file in the given searchpath (1 level up)."));
        tryAgain(path,infFile,serviceBinary);
    }
  }
}

void instWizard::tryAgain(QString infPath, QString infFile, QString serviceBinary){
QString temp = searchPath->text();
QString path = temp;

  infFileGlobal = infFile;
  system((QString)"mkdir " + getenv("HOME") + "/.kndiswrapper/temp");
  system("cp " + infPath + "/" + infFile + " " + getenv("HOME") + "/.kndiswrapper/temp");
  startSearchButton->setEnabled(false);

  if (temp.findRev("/") != -1) path = temp.left(temp.findRev("/"));

  searchProcess2->clearArguments();
  searchProcess2->addArgument("find");
  searchProcess2->addArgument(path);
  searchProcess2->addArgument("-iname");
  searchProcess2->addArgument(serviceBinary);
  searchProcess2->addArgument("-print");
  searchProcess2->start();
}

void instWizard::slot_searchProcess2Exited(){
QString line;
bool found = false;

  while ((searchProcess2->canReadLineStdout()) && (found == false)){
    line = searchProcess2->readLineStdout();
    found = true;
    system("cp " + line + " " + getenv("HOME") + "/.kndiswrapper/temp");
  }
  if (found){
    QMessageBox::information(this,tr("Attention"),tr("Found a matching file. Try to continue the installtion"));
    *driverRC = (QString)getenv("HOME") + (QString)"/.kndiswrapper/temp/" + infFileGlobal;
    this->done(QDialog::Accepted);
  } else {
    QMessageBox::information(this,tr("Attention"),tr("No matching file was found. Installation aborted!"));
    this->done(QDialog::Rejected);
  }
}

#include "instwizard.moc"
