/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wikilookup.h"
#include <qmessagebox.h>

wikiLookup::wikiLookup(QWidget *parent, const char *name,int mode) : QDialog(parent, name, true)
{
// mode = 0 --> Installationsroutine
// mode = 1 --> Wiki Modus.
modus = mode;
QString path="/usr/local/translations/kndiswrapper/cards_known_to_work.txt";
QFile file(path);
  this->setMinimumSize(700,300);
  if (file.open(IO_ReadOnly)){
    QTextStream stream (&file);
    while (!stream.atEnd()){
      workingCards = workingCards + stream.readLine() + "\n";
    }
    file.close();
  }

  outputWindow = new QMultiLineEdit(this,"outputWindow");
  searchButton = new QPushButton(tr("lookup"),this,"searchbutton");
  searchButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
  if (mode == 0) cancelButton = new QPushButton(tr("cancel installation"),this,"cancelButton"); else cancelButton = new QPushButton(tr("close window"),this,"cancelButton");
  cancelButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
  if (mode == 0){
    installButton = new QPushButton(tr("continue installation"),this,"installButton");
    installButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
  }
  searchLabel = new QLabel(tr("Search : "),this,"searchlabel");
  searchLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));
  wikiLabel = new QLabel("NDISWrapper Wiki",this,"wikilabel");
  wikiLabel->setFont(QFont("Helvetic",16,QFont::Bold,true));
  searchEdit = new QLineEdit(this);
  searchEdit->setFont(QFont("Helvetic",10,QFont::Normal,false));

  lsusbProcess = new QProcess(this);
  lsusbProcess->clearArguments();
  lsusbProcess->addArgument("lsusb");
  connect(lsusbProcess,SIGNAL(processExited()),this,SLOT(slot_lsusbProcessExited()));
  if (mode == 0) connect(installButton,SIGNAL(clicked()),this,SLOT(slot_installButtonClicked()));
  connect(cancelButton,SIGNAL(clicked()),this,SLOT(slot_cancelButtonClicked()));
  connect(searchButton,SIGNAL(clicked()),this,SLOT(slot_searchButtonClicked()));
  lsusbProcess->start();
}


wikiLookup::~wikiLookup()
{
}

void wikiLookup::resizeEvent(QResizeEvent * e){
  e = e; // Just to keep the compiler happy ....
  if (modus == 0) installButton->setGeometry(5,this->height()-30,150,25);
  cancelButton->setGeometry(this->width()-155,this->height()-30,150,25);
  outputWindow->setGeometry(5,35,this->width()-10,this->height()-75);
  searchButton->setGeometry(this->width()-85,5,80,25);
  searchEdit->setGeometry(searchButton->x()-255,7,250,20);
  searchLabel->setGeometry(searchEdit->x()-85,7,80,20);
  wikiLabel->setGeometry(5,1,250,24);
}

void wikiLookup::slot_lsusbProcessExited(){
QString line;
int start,stop,temp;
cardsFound="";

  while (lsusbProcess->canReadLineStdout()){
    line=lsusbProcess->readLineStdout();
    start = line.find(":");
    if (start > 0){
      start = line.find(":",start+1);
      start-=4;
      stop=9;
      line = line.mid(start,stop);
      start = 0;
      while (workingCards.find(line,start,false) != -1) {
        start = workingCards.find(line,start,false);
        start = workingCards.findRev("\n\n",start);
        if (start == -1) start=1;
        stop = workingCards.find("\n\n",start + 2);
        temp = stop;
        stop = stop-start;
        cardsFound = cardsFound + workingCards.mid(start+2,stop-2) + "\n------------------------------------------------------------------\n";
        start = temp;
      }
    }
  }
  if (cardsFound == "")
    cardsFound = tr("Sorry. No information for your hardware found in the ndiswrapper wiki!");
  else
    cardsFound = "Information obtained from the ndiswrapper wiki page.\n\n------------------------------------------------------------------\n" + cardsFound + tr("\nTo continue the installation you must find the appropriate .inf-File. Maybe the information above from the ndiswrapper wiki gives you some help. The driver may be packed in an archiv file (*.cab, *.zip or even *.exe). Search for this files and try cabextrac for *.cab, unzip for *.zip and unshield for .exe files.\nGood luck.");

  outputWindow->setText(cardsFound);
  searchButton->setFocus();
}

void wikiLookup::slot_installButtonClicked(){
  this->done(0);
}

void wikiLookup::slot_cancelButtonClicked(){
  this->done(-1);
}

void wikiLookup::slot_searchButtonClicked(){
QString line = searchEdit->text();
int start,stop,temp;
cardsFound="";

  if (line == "") line = " ";
  start = 0;
  while (workingCards.find(line,start,false) != -1) {
      start = workingCards.find(line,start,false);
      start = workingCards.findRev("\n\n",start);
      if (start == -1) start=1;
      stop = workingCards.find("\n\n",start + 2);
      temp = stop;
      stop = stop-start;
      cardsFound = cardsFound + workingCards.mid(start+2,stop-2) + "\n------------------------------------------------------------------\n";
      start = temp;
  }
  if (cardsFound == "")
    cardsFound = tr("Sorry. No information found for the keyword you enterd!");
  else
    cardsFound = cardsFound + tr("\nTo continue the installation you must find the appropriate .inf-File. Maybe the information above from the ndiswrapper wiki gives you some help. The driver may be packed in an archiv file (*.cab, *.zip or even *.exe). Search for this files and try cabextrac for *.cab, unzip for *.zip and unshield for .exe files.\nGood luck.");

  outputWindow->setText(cardsFound);
  searchButton->setFocus();
}

#include "wikilookup.moc"
