/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkddatabase.h"
#include "../kkaddressbook/kkacontactdata.h"

#include <qdom.h>

using namespace KKDesigner;

KKDDataBase::KKDDataBase( const QPoint& l
						, const QSize& s
						, const QFont& f
						, const QColor& c
						, Orientation o
						, DataType t
						, QObject* parent
						)
	: KKDTextBase( l, s, f, c, o, parent )
	, m_type( t )
{
}

KKDDataBase::KKDDataBase( QDomElement e, QObject* parent )
	: KKDTextBase( e, parent )
{
	m_type = e.hasAttribute( "type" ) ? (DataType)e.attribute( "type" ).toInt() : Receiver;
}

KKDDataBase::KKDDataBase( const KKDDataBase* item, QObject* parent )
	: KKDTextBase( (KKDTextBase*)item, parent )
	, m_type( item->m_type )
{
}

KKDDataBase::~KKDDataBase()
{
}

QDomElement KKDDataBase::toElement( QDomDocument& doc, const QString& t )
{
	QString tag( t == QString::null ? tagName() : t );
	QDomElement elem = KKDTextBase::toElement( doc, tag );
	elem.setAttribute( "type", m_type );
	return elem;
}

void KKDDataBase::setDataType( DataType t )
{
	if( locked() ) return;
	if( m_type == t ) return;
	m_type = t;
	emit repaint( rect() );
	emit dataTypeChanged();
}
