/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktcategoryview.h"
#include "kktcategoryitem.h"

#include <qdir.h>

#include <kdebug.h>
#include <klocale.h>

#include <kstandarddirs.h>

using namespace KKTemplate;

KKTCategoryView::KKTCategoryView( QWidget* parent, const char* name )
	: KListView( parent, name )
{
	addColumn( i18n( "Category" ) );
// 	addColumn( i18n( "Sort" ) );
	setFullWidth( true );
	setRootIsDecorated( true );
	setSorting( 1 );
	readData();
}

KKTCategoryView::~KKTCategoryView()
{
}

void KKTCategoryView::readData()
{
	QString path = KGlobal::dirs()->findResource( "data", KGlobal::instance()->instanceName() + "/templates/" );

	QDir dir( path );
	QStringList list = dir.entryList( QDir::Dirs|QDir::Readable, QDir::Name );

	int i = 0;
	for( QStringList::iterator it = list.begin(); it != list.end(); ++it )
	{
		if( (*it)[0] != '.' )
		{
			KKTCategoryItem* item = new KKTCategoryItem( this, path + *it + "/" );
			item->setText( 1, QString( "%1" ).arg( i++, QString::number( list.size() ).length() ) );
		}
	}
}
