/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "syndock.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>
#include <kuniqueapplication.h>
#include <kwin.h>
#include <klocale.h>
#include <kdemacros.h>

#include <qstring.h>
#include <qwidget.h>

extern "C" KDE_EXPORT int kdemain( int argc, char *argv[] )
{
  KAboutData aboutData( "syndock", I18N_NOOP( "Synaptics Touchpad" ),
    I18N_NOOP( "0.2.3" ), I18N_NOOP( "Synaptics Touchpad" ), KAboutData::License_GPL_V2,
    "(c) 2004 Nadeem Hasan" );
  aboutData.addAuthor( "Nadeem Hasan", I18N_NOOP( "Author" ),
    "nhasan@kde.org" );

  KCmdLineArgs::init( argc, argv, &aboutData );
  KUniqueApplication::addCmdLineOptions();

  if ( !KUniqueApplication::start() )
  {
    kdDebug() << k_funcinfo << "Already running." << endl;
    return 0;
  }

  KUniqueApplication app;
  app.disableSessionManagement();

  SynDock *dock = new SynDock( 0, "SynDock" );

  KWin::setSystemTrayWindowFor( dock->winId(), 0 );
  dock->show();

  app.setMainWidget( dock );

  int ret = app.exec();
  delete dock;

  return ret;
}
