/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qevent.h>

#include <klocale.h>

#include "CfgFile.h"
#include "TextEdit.h"
#include "LineEdit.h"
#include "ComboBox.h"
#include "OptionsWidget.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

Option::Option(QString strLabel, QString strDefault, QString strComment)

  : m_strLabel(strLabel),
    m_strDefault(strDefault),
    m_strValue(strDefault),
    m_strComment(strComment)

{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void OptionEditor::slotLostFocus()
{
    if ( m_bDirty )
    {
        m_bDirty = false;
        emit optionChanged(this, getOptionValue());
    }
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void OptionEditor::slotGotFocus()
{
    emit activated(this);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

StringOptionEditor::StringOptionEditor(QWidget    * pParent,
                                       const char * pName,
                                       QString      strMask)

  : OptionEditor( new LineEdit(pParent, pName) )

{
    QLineEdit * pWidget = dynamic_cast<LineEdit *>(getWidget());

    if ( !strMask.isEmpty() )
        pWidget->setInputMask(strMask);

    connect(pWidget, SIGNAL(textChanged(const QString &)),
            this,    SLOT(slotOptionChanged(const QString &)));

    connect(pWidget, SIGNAL(lostFocus()), this, SLOT(slotLostFocus()));
    connect(pWidget, SIGNAL(gotFocus()), this, SLOT(slotGotFocus()));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void StringOptionEditor::setOptionValue(const QString & strValue)
{
    dynamic_cast<LineEdit *>(getWidget())->setText(strValue);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString StringOptionEditor::getOptionValue() const
{
    return dynamic_cast<const LineEdit *>(getWidget())->text();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString StringOption::convertValueForEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString StringOption::convertValueFromEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString IntOption::convertValueForEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString IntOption::convertValueFromEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

TextOptionEditor::TextOptionEditor(QWidget * pParent, const char * pName)

  : OptionEditor( new TextEdit(pParent, pName) )

{
    QTextEdit * pWidget = dynamic_cast<TextEdit *>(getWidget());

    connect(pWidget, SIGNAL(textChanged()),
            this,    SLOT(slotTextChanged()));

    connect(pWidget, SIGNAL(lostFocus()), this, SLOT(slotLostFocus()));
    connect(pWidget, SIGNAL(gotFocus()), this, SLOT(slotGotFocus()));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void TextOptionEditor::setOptionValue(const QString & strValue)
{
    dynamic_cast<TextEdit *>(getWidget())->setText(strValue);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString TextOptionEditor::getOptionValue() const
{
    return dynamic_cast<const TextEdit *>(getWidget())->text();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString TextOption::convertValueForEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString TextOption::convertValueFromEditor (QString strValue) const
{
    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

BoolOptionEditor::BoolOptionEditor(QWidget * pParent, const char * pName)
  : OptionEditor( new ComboBox(pParent, pName) )
{
    ComboBox * pComboBox = dynamic_cast<ComboBox *>(getWidget());

    pComboBox->insertItem(i18n("no"));
    pComboBox->insertItem(i18n("yes"));

    pComboBox->setEditable(false);

    connect(pComboBox, SIGNAL(activated(const QString &)),
            this,      SLOT(slotOptionChanged(const QString &)));

    connect(pComboBox, SIGNAL(gotFocus()), this, SLOT(slotGotFocus()));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void BoolOptionEditor::setOptionValue(const QString & strValue)
{
    ComboBox * pComboBox = dynamic_cast<ComboBox *>(getWidget());

    if ( strValue == "1" || strValue == i18n("yes") )
        pComboBox->setCurrentItem(1);
    else
        pComboBox->setCurrentItem(0);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString BoolOptionEditor::getOptionValue() const
{
    const ComboBox * pComboBox = dynamic_cast<const ComboBox *>(getWidget());

    if ( 1 == pComboBox->currentItem() )
        return "1";
    else
        return "0";
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString BoolOption::convertValueForEditor (QString strText) const
{
    if ( strText == i18n("1") )
    {
        strText = i18n("yes");
    }
    else if ( strText != i18n("yes") )
    {
        strText = i18n("no");
    }

    return strText;
}


/***************************************************************************/
/**
 *  Convert text from editor to output format, i.e. "1" for true and "0"
 *  for false.
 *
 ***************************************************************************/

QString BoolOption::convertValueFromEditor (QString strText) const
{
    if ( strText == i18n("yes") )
        strText = "1";
    else if ( strText != "1" )
        strText = "0";

    return strText;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

OptionEditor * FileOption::createEditor(QWidget * pParent) const
{
    return new StringOptionEditor(pParent);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

DirOption::DirOption(QString strLabel, QString strDefault, QString strComment)

  : StringOption(strLabel, adjustPath(strDefault), "", strComment)

{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString DirOption::adjustPath(QString strDir)
{
    if ( !strDir.isEmpty() && !strDir.endsWith("/") )
        strDir += '/';

    return strDir;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

OptionEditor * DirOption::createEditor(QWidget * pParent) const
{
    return new StringOptionEditor(pParent);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString DirOption::convertValueForEditor (QString strValue) const
{
    if ( !strValue.isEmpty()
            && strValue.length() != 1
            && strValue.endsWith("/") )
    {
        strValue.remove(strValue.length() - 1);
    }

    return strValue;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QString DirOption::convertValueFromEditor (QString strValue) const
{
    return adjustPath(strValue);
}

