# -*- coding: utf-8 -*-
#
# pylast - A Last.fm Music Tracker for Linux.
# Copyright (C) 2008-2009  Amr Hassan
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

import gtk
import pylast
from htmlentitydefs import name2codepoint
import pango

class BigLabel(gtk.VBox):
	def __init__(self):
		gtk.VBox.__init__(self)
		
		self.label = gtk.Label()
		self.label.set_line_wrap(True)
		self.label.set_alignment(0, 0)
		
		self.scrolled = gtk.ScrolledWindow()
		self.scrolled.add_with_viewport(self.label)
		self.scrolled.get_child().set_shadow_type(gtk.SHADOW_NONE)
		self.scrolled.show_all()
		
		self.pack_start(self.scrolled)
		
		self.use_small_text = True
		self.use_scrollbars = True
		self.text = ''
	
	def set_text(self, text):
		self.text = self._get_preped_text(text)
		
		if self.use_small_text:
			self.label.set_markup('<small>' + self.text + '</small>')
		else:
			self.label.set_markup(self.text)
	
	def _get_preped_text(self, text):	
		while text.find('<') >= 0:
			i = text.find('<')
			f = text.find('>', i)
			
			text = text[:i] + text[f+1:]
		
		e = name2codepoint
		for i in e.keys():
			to_remove = unicode('&' + i + ';')
			to_insert = unichr(e[i])
			
			text = text.replace(to_remove, to_insert)
		
		text = text.replace('&', '&amp;')
		
		return text
	
	def reset_text(self):
		self.set_text('')
	
	def set_use_scrollbars(self, value):
		self.use_scrollbars = value
		
		if self.use_scrollbars:
			self.scrolled.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
		else:
			self.scrolled.set_policy(gtk.POLICY_NEVER, gtk.POLICY_NEVER)
	
	def set_use_small_text(self, value):
		self.use_small_text = value
		
		self.set_text(self.text)
