/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.FontException;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;

public class TrueTypeFontRecord
implements FontSource {
    private int collectionIndex;
    private long offset;
    private boolean bold;
    private boolean italics;
    private boolean oblique;
    private FontFamily family;
    private boolean embeddable;
    private boolean nonWindows;
    private TrueTypeFontIdentifier identifier;
    private String name;
    private String variant;

    public TrueTypeFontRecord(TrueTypeFont trueTypeFont, FontFamily family) throws IOException, FontException {
        if (trueTypeFont == null) {
            throw new NullPointerException("The font must not be null");
        }
        if (family == null) {
            throw new NullPointerException("The font-family must not be null");
        }
        this.family = family;
        this.collectionIndex = trueTypeFont.getCollectionIndex();
        this.offset = trueTypeFont.getOffset();
        OS2Table table = (OS2Table)trueTypeFont.getTable(1330851634L);
        if (table != null) {
            this.embeddable = !table.isRestricted();
            this.nonWindows = false;
        } else {
            this.nonWindows = true;
        }
        NameTable nameTable = (NameTable)trueTypeFont.getTable(1851878757L);
        if (nameTable == null) {
            throw new FontException("This font does not have a 'name' table. It is not valid.");
        }
        this.name = nameTable.getPrimaryName(4);
        this.variant = nameTable.getPrimaryName(2);
        FontHeaderTable headTable = (FontHeaderTable)trueTypeFont.getTable(1751474532L);
        if (headTable != null) {
            this.bold = headTable.isBold();
            this.italics = headTable.isItalic();
        } else {
            OS2Table os2Table = (OS2Table)trueTypeFont.getTable(1330851634L);
            if (os2Table != null) {
                this.bold = os2Table.isBold();
                this.italics = os2Table.isItalic();
            } else {
                this.bold = this.variant.toLowerCase().indexOf("bold") >= 0;
                this.italics = this.variant.toLowerCase().indexOf("italic") >= 0;
            }
        }
        this.oblique = this.oblique || this.variant.toLowerCase().indexOf("oblique") >= 0;
        this.identifier = new TrueTypeFontIdentifier(trueTypeFont.getFilename(), this.name, this.variant, this.collectionIndex, this.offset);
    }

    public long getOffset() {
        return this.offset;
    }

    public FontFamily getFamily() {
        return this.family;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italics;
    }

    public boolean isOblique() {
        return this.oblique;
    }

    public String getFontSource() {
        return this.identifier.getFontSource();
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontRecord that = (TrueTypeFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.embeddable != that.embeddable) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        if (this.oblique != that.oblique) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.variant.equals(that.variant);
    }

    public FontIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isNonWindows() {
        return this.nonWindows;
    }

    public int hashCode() {
        int result = this.bold ? 1 : 0;
        result = 29 * result + (this.italics ? 1 : 0);
        result = 29 * result + (this.oblique ? 1 : 0);
        result = 29 * result + (this.embeddable ? 1 : 0);
        result = 29 * result + this.name.hashCode();
        result = 29 * result + this.variant.hashCode();
        return result;
    }
}

