/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;

public class HSSFRequest {
    private HashMap records = new HashMap(50);

    public void addListener(HSSFListener lsnr, short sid) {
        ArrayList<HSSFListener> list = null;
        Object obj = this.records.get(new Short(sid));
        if (obj != null) {
            list = (ArrayList<HSSFListener>)obj;
        } else {
            list = new ArrayList<HSSFListener>(1);
            list.add(lsnr);
            this.records.put(new Short(sid), list);
        }
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes = RecordFactory.getAllKnownRecordSIDs();
        int k = 0;
        while (k < rectypes.length) {
            this.addListener(lsnr, rectypes[k]);
            ++k;
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        Object obj = this.records.get(new Short(rec.getSid()));
        short userCode = 0;
        if (obj != null) {
            List listeners = (List)obj;
            int k = 0;
            while (k < listeners.size()) {
                HSSFListener listener;
                Object listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode != 0) {
                        break;
                    }
                } else {
                    listener = (HSSFListener)listenObj;
                    listener.processRecord(rec);
                }
                ++k;
            }
        }
        return userCode;
    }
}

