/* vim: set shiftwidth=4 tabstop=8 softtabstop=4: */
/* $Id: error.c,v 1.3 2003/01/15 16:00:37 shinra Exp $ */

#define IN_LIBSPT
#include "sptprivate.h"
#include <stdio.h>

static const char *errtab[] = {
    "No error", /* 0: SPT_E_NONE */
    "Invalid argument", /* 1: SPT_E_INVAL */
    "Out of memory", /* 2: SPT_E_NOMEM */
    "Unknwon error", /* 3: SPT_E_UNKNOWN */
    "Sptagent version mismatch", /* 4: SPT_E_AGENT_VERSION */
    "Cannot execute sptagent", /* 5: SPT_E_AGENT_EXEC */
    "Sptagent is not properly installed", /* 6: SPT_E_AGENT_INST */
    "Fatal error in sptagent", /* 7: SPT_E_AGENT_FATAL */
    "Sptagent is dead", /* 8: SPT_E_AGENT_DEAD */
    "Cannot chmod/chown slave tty", /* 9: SPT_E_CHOWN_FAIL */
    "Cannot update utmp/wtmp/lastlog", /* 10: SPT_E_UTMP_FAIL */
    "No ttys are available", /* 11: SPT_E_NOTTY */
    "Lack of some kind of resource", /* 12: SPT_E_RESOURCE */
    "Cleanup failure", /* 13: SPT_E_CLEANUP_FAIL */
    "Cannot initialize slave tty", /* 14: SPT_E_TTYINIT_FAIL */
    "Cannot detach or change controlling tty", /* 15: SPT_E_CTTY_FAIL */
};

SPT_EXPORT(const char *)
spt_strerror(int errnum)
{
    if (errnum >= ARRAYLEN(errtab))
	return "spt_strerror(): Invalid error number!";
    return errtab[errnum];
}

SPT_EXPORT(void)
spt_perror(const char *str, int errnum)
{
    int errno_save = errno;
    if (errnum >= ARRAYLEN(errtab))
	fprintf(stderr,
		"spt_perror(): Invalid error number! (errnum=%d)\n",
		errnum);
    else if (str)
	fprintf(stderr, "%s: %s\n", str, errtab[errnum]);
    else
	fprintf(stderr, "%s\n", errtab[errnum]);
    errno = errno_save;
}
