/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class ParserEntityResolver
implements EntityResolver {
    private static final Log logger = LogFactory.getLog(ParserEntityResolver.class);
    private final HashMap deprecatedDTDs;
    private final HashMap dtds = new HashMap();
    private static ParserEntityResolver singleton;

    private ParserEntityResolver() {
        this.deprecatedDTDs = new HashMap();
    }

    public boolean setDTDLocation(String publicID, URL location) {
        if (this.isValid(location)) {
            this.dtds.put(publicID, location);
            return true;
        }
        logger.warn((Object)("Validate location failed for " + publicID + " location: " + location));
        return false;
    }

    public boolean setDTDLocation(String publicID, String systemId, URL location) {
        if (this.isValid(location)) {
            this.dtds.put(publicID, location);
            this.dtds.put(systemId, location);
            return true;
        }
        logger.warn((Object)("Validate location failed for " + publicID + " location: " + location));
        return false;
    }

    public URL getDTDLocation(String publicID) {
        return (URL)this.dtds.get(publicID);
    }

    private boolean isValid(URL reportDtd) {
        if (reportDtd == null) {
            return false;
        }
        try {
            InputStream uc = reportDtd.openStream();
            uc.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            if (publicId == null) {
                URL location;
                if (systemId != null && (location = this.getDTDLocation(systemId)) != null) {
                    InputSource inputSource = new InputSource(location.openStream());
                    inputSource.setSystemId(systemId);
                    return inputSource;
                }
                return null;
            }
            URL location = this.getDTDLocation(publicId);
            if (location != null) {
                InputSource inputSource = new InputSource(location.openStream());
                inputSource.setSystemId(systemId);
                inputSource.setPublicId(publicId);
                return inputSource;
            }
            String message = this.getDeprecatedDTDMessage(publicId);
            if (message != null) {
                logger.info((Object)message);
            } else {
                logger.info((Object)"A public ID was given for the document, but it was unknown or invalid.");
            }
            return null;
        }
        catch (IOException ioe) {
            logger.warn((Object)"Unable to open specified DTD", (Throwable)ioe);
            return null;
        }
    }

    public static synchronized ParserEntityResolver getDefaultResolver() {
        if (singleton == null) {
            singleton = new ParserEntityResolver();
        }
        return singleton;
    }

    public void setDeprecatedDTDMessage(String publicID, String message) {
        this.deprecatedDTDs.put(publicID, message);
    }

    public String getDeprecatedDTDMessage(String publicID) {
        return (String)this.deprecatedDTDs.get(publicID);
    }
}

