#ifndef MFILER2_DIRWND
#define MFILER2_DIRWND

extern "C"
{
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
}

/// t@C ///
struct sFile{
    char mName[PATH_MAX];           // fBXN̖O
    char mNameView[PATH_MAX];       // \鎞̖O(iconvŕϊ)
    char mLinkTo[PATH_MAX];         // N
    struct stat mStat;              // stat()̃LbV
    struct stat mLStat;             // lstat()̃LbV
    bool mMark;                     // }[NĂ邩ǂ
    char mUser[256];                // [U[
    char mGroup[256];               // O[v

    char mView[256];                // `ʗp̃obt@
    int mViewAttr;                  // `ʗp̃obt@

    int mSortRandom;                // _\[g̐l

    sFile(char* name, char* name_view, char* linkto, struct stat* stat_, struct stat* lstat_, bool mark, char* user, char* group, int uid, int gid)
    {
        strcpy(mName, name);
        strcpy(mNameView, name_view);
        strcpy(mLinkTo, linkto);
        mStat = *stat_;
        mLStat = *lstat_;
        mMark = mark;
        if(user == NULL) {
            sprintf(mUser, "%d", uid);
        }
        else {
            strcpy(mUser, user);
        }
        if(group == NULL) {
            sprintf(mGroup, "%d", gid);
        }
        else {
            strcpy(mGroup, group);
        }

        mSortRandom = 0;
    }
};

/// fBNg ///
struct sDirInfo {
    char mPath[512];
    int mScrollTop;
    int mCursor;
};

class cDirWnd {
    char mPath[PATH_MAX];               // ݂̃pX Ō̕'/'
    char mPathBefore[PATH_MAX];         // ÕpX
    hash_obj* mMarkFiles;               // }[Nt@C
    hash_obj* mFileNum;
    list_obj* mFileNum2;

    vector_obj* mFiles;
    
    int mScrollTop;
    int mCursor;

    char mMask[1024];
    
    list_obj* mDirStack;
   
    static BOOL sort_name(void* left, void* right);
    static BOOL sort_name_reverse(void* left, void* right);
    static BOOL sort_ext(void* left, void* right);
    static BOOL sort_ext_reverse(void* left, void* right);
    static BOOL sort_size(void* left, void* right);
    static BOOL sort_size_reverse(void* left, void* right);
    static BOOL sort_time(void* left, void* right);
    static BOOL sort_time_reverse(void* left, void* right);
    static BOOL sort_user(void* left, void* right);
    static BOOL sort_user_reverse(void* left, void* right);
    static BOOL sort_group(void* left, void* right);
    static BOOL sort_group_reverse(void* left, void* right);
    static BOOL sort_permission(void* left, void* right);
    static BOOL sort_permission_reverse(void* left, void* right);
    static BOOL sort_random(void* left, void* right);

    static const int kMaxYMinus = 4;

    void read();
    bool check_path(char* new_path);
    void clear_dir_stack();
    void hash_file_num_reset();
    void make_file_stat(sFile* file, char* buf);
    void make_file_name(sFile* file, char* fname, char** ext, char* dot, int name_len);
public:
    cDirWnd(char* path, bool active);
    ~cDirWnd();

    static void Init();
    static void Final();

    static void* operator new(size_t size) { return MALLOC(size); }
    static void operator delete(void* p) { FREE(p); }

    static const int kDirStackSize = 500;
    static bool gRemainMarks;

    /// properties ///
    bool mActive;
   
    enum eSortKind { kName, kNameReverse, kExt, kExtReverse, kSize, kSizeReverse, kTime, kTimeReverse, kUser, kUserReverse, kGroup, kGroupReverse, kPermission, kPermissionReverse, kRandom, kNone, kSortMax };
    eSortKind mSortKind;

    static char* kSortName[cDirWnd::kSortMax];

    enum eViewOption { kAll, kOneDir, kOneDir2, kOneDir3, kOneDir5 };
    static eViewOption gViewOption;
    bool mViewNameOnly;

    static bool gViewMTime;
    static bool gViewSize;
    static bool gViewGroup;
    static bool gViewOwner;
    static bool gViewNLink;
    static bool gViewPermission;
    static bool gViewFnameDivideExt;

    bool mViewFocusBack;
    bool mViewRemoveDir;
    
    vector_obj* Files() { return mFiles; }
    sFile* CursorFile();

    struct stat* CursorFileLStat() {
        return &((sFile*)vector_item(mFiles, mCursor))->mLStat;
    }


    sFile* File(int num);
    char* Path() { return mPath; }
    VALUE MarkFiles();
    VALUE MarkFilesFullPath();
    VALUE MarkFilesConvert();
    VALUE MarkFilesFullPathConvert();
    ALLOCATED string_obj* MarkFilesNoSQuote();
    ALLOCATED string_obj* MarkFilesNoSQuoteFullPath();
    ALLOCATED string_obj* MarkFilesSQuote();
    ALLOCATED string_obj* MarkFilesSQuoteFullPath();
    int MarkFileNum();
    double MarkFileSize();
    int FileNum(char* fname);

    bool Marking();                                // ݃}[NH
    bool IsSameExtensionMarked(char* result);      // gq̃t@C}[NH
    bool IsDirectoryMarked();                      // fBNg}[NH
    bool IsExecutiveFileMarked();                  // st@C}[NH
    bool IsLinkMarked();                           // N}[NH

    bool IsLeftDir();
    bool IsRightDir();

    /// methods ///
    int Cursor();
    int CursorMax();
    int CursorX();
    int CursorY();
    int CursorMaxX();
    int CursorMaxY();
    void MoveCursor(int index);
    int ScrollTop();
    void SetScrollTop(int index);
    
    void Mark();
    void Mark2(int index);      // ]
    void Mark3(int index);      // }[N
    void MarkAll();
    void MarkAllFiles();
    void MarkOff(int index);
    void MarkOff(char* fname);
    void ResetMarks();
    
    void Activate(cDirWnd* current);
   
    bool Move(char* path);        // last char don't have to be '/'
    void MoveBack();

    void SelectTab();
    void PushDir(int num, char* path, int scroll_top, int cursor);
    void PushBackTab();
    static void CloseTab(int num);
    void UpTab(int num);
    static int TabMax();
    static void TabNew(int num, char* path, int scroll_top, int cursor);
    static char* TabPath(int num);
    static int TabScrollTop(int num);
    static int TabCursor(int num);
    static VALUE TabOutOfFind(int num);
   
    void Sort();
    void View();
    void ChangeSort();

    void MakeSizeStr2(char* result, double size);
    void SelectDirView();
    void SelectDirInput(int meta, int key);

    void DeleteFileFromFileList(int num);

    void Reread();
    bool ChangeMask(char* mask);
    char* Mask() { return mMask; }
    
    void AddFile(char* fname);      // fBXNɂstatłꍇ
    void AddFile2(char* fname, char* linkto, int kind, bool user_r, bool user_w, bool user_x, bool group_r, bool group_w, bool group_x, bool other_r, bool other_w, bool other_x, int size, time_t mtime, char* user, char* group);
        // kind 0: M[t@C 1: fBNg 2: N
};

extern cDirWnd* ActiveDir();
extern cDirWnd* SleepDir();
extern bool gSelectDir;
extern vector_obj* gDirStack;                   // fBNgX^bN sDirInfo̔z
extern int gDirScrollTop;                   // fBNgX^bNIʂ̃XN[ʒu
extern int gDirCursor;                      // fBNgX^bNIʂ̃J[\ʒu
extern int gViewHookLineNum;                // t@Cʂ̃tbN̕`ʍs

extern VALUE gOptionPageViewWay;          // ݂̃y[Wp[Zg\邩

enum eFileSizeViewWay { kFSHuman = 0, kFSNormal, kFSPlane };
extern VALUE gFileSizeViewWay;              // t@C̃TCY\ǂ邩

extern VALUE gSortMarkFileUp;                       // }[Nt@Cɏグ邩ǂ
extern VALUE gSortDirUp;                    // \[gfBNgɏグ邩ǂ

int convert_fname(char* src, char* des, int des_size); // file mei convert

#endif
