#include "common.h"

///////////////////////////////////////////////////////////////////////////////
// ^u
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::PushBackTab()
{
    sDirInfo* dinfo = (sDirInfo*)MALLOC(sizeof(sDirInfo));

    strcpy(dinfo->mPath, mPath);
    dinfo->mScrollTop = mScrollTop;
    dinfo->mCursor = mCursor;

    vector_add(gDirStack, dinfo);
}

void cDirWnd::CloseTab(int num)
{
    if(num >=0 && num < vector_size(gDirStack)) {
        void* item = vector_erase(gDirStack, num);
        FREE(item);
    }
}

void cDirWnd::UpTab(int num)
{
    if(num >=0 && num < vector_size(gDirStack)) {
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, num);
        
        Move((char*)dinfo->mPath);
        SetScrollTop(dinfo->mScrollTop);
        MoveCursor(dinfo->mCursor);
    }
}

int cDirWnd::TabMax()
{
    return vector_size(gDirStack);
}

void cDirWnd::TabNew(int num, char* path, int scroll_top, int cursor)
{
    if(num >= 0 && num <= vector_size(gDirStack)) {
        if(path[strlen(path)-1] != '/') {
            strcat(path, "/");
        }

        sDirInfo* dinfo = (sDirInfo*)MALLOC(sizeof(sDirInfo));
        strcpy(dinfo->mPath, path);
        dinfo->mScrollTop = scroll_top;
        dinfo->mCursor = cursor;
        

        vector_insert(gDirStack, num, dinfo);
    }
}

char* cDirWnd::TabPath(int num)
{
    if(num >=0 && num < vector_size(gDirStack)) {
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, num);

        return dinfo->mPath;
    }

    return NULL;
}

int cDirWnd::TabScrollTop(int num)
{
    if(num >=0 && num < vector_size(gDirStack)) {
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, num);

        return dinfo->mScrollTop;
    }

    return -1;
}

int cDirWnd::TabCursor(int num)
{
    if(num >=0 && num < vector_size(gDirStack)) {
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, num);

        return dinfo->mCursor;
    }

    return -1;
}

void cDirWnd::SelectTab()
{
/*
    if(vector_size(gDirStack) == 1) {
        PushFrontDir();
        
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, 1);
        
        Move((char*)dinfo->mPath);
        SetScrollTop(dinfo->mScrollTop);
        MoveCursor(dinfo->mCursor);
        
        FREE(dinfo);
        vector_erase(gDirStack, 1);
    }
*/
    if(vector_size(gDirStack) > 0) {

        gDirScrollTop = 0;
        gDirCursor = 0;
        gSelectDir = true;
    }
}

void cDirWnd::SelectDirInput(int meta, int key)
{
    if(key == 14 || key == KEY_DOWN || key == 9) {    // CTRL-N CTRL-I
        gDirCursor++;
    }
    else if(key == 16 || key == KEY_UP) {    //CTRL-P
        gDirCursor--;
    }
    else if(key == 6 || key == KEY_RIGHT) {    // CTRL-F
        gDirCursor++;
    }
    else if(key == 2 || key == KEY_LEFT) {    // CTRL-B
        gDirCursor--;
    }
    else if(key == 10 || key == 13) {		// CTRL-J CTRL-M
        PushBackTab();
        
        sDirInfo* dinfo = (sDirInfo*)vector_item(gDirStack, gDirCursor);
        
        Move((char*)dinfo->mPath);
        SetScrollTop(dinfo->mScrollTop);
        MoveCursor(dinfo->mCursor);
        
        FREE(dinfo);
        vector_erase(gDirStack, gDirCursor);
        
        gSelectDir = false;
    }
    else if(key == 4 || key == KEY_NPAGE) {    // CTRL-D
        gDirCursor+=5;
    }
    else if(key == 21 || key == KEY_PPAGE) {    // CTRL-U
        gDirCursor-=5;
    }
    else if(key == 3 || key == 7 || key == 27 || key == 8 || key == KEY_BACKSPACE || key == 127 || key == KEY_DC) { // CTRL-C CTRL-G Escape Bs
        gSelectDir = false;
    }
    
    if(gDirCursor < 0) {
        gDirCursor = vector_size(gDirStack)-1;
    }
    if(gDirCursor >= vector_size(gDirStack)) {
        gDirCursor = 0;
//        gDirCursor = vector_size(gDirStack)-1;
    }

    const int maxy = mgetmaxy();
    if(gDirCursor < gDirScrollTop) {
        gDirScrollTop = (gDirCursor/(maxy-2))*(maxy-2);
    }
    if(gDirCursor > gDirScrollTop + maxy-3) {
        gDirScrollTop = (gDirCursor/(maxy-2))    *(maxy-2);
    }
}

void cDirWnd::SelectDirView()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    mbox(0,0, maxx, maxy);
    
    for(int i=gDirScrollTop; i<vector_size(gDirStack) && i-gDirScrollTop<maxy-2; i++)
    {
        char* item = ((sDirInfo*)vector_item(gDirStack, i))->mPath;
            
        char buf[PATH_MAX];
        
        if(gKanjiCode == kUtf8)
            str_cut2(item, maxx-2, buf, PATH_MAX);
        else
            cut(item, buf, maxx-2);
        
        if(gDirCursor == i) mattron(kCAReverse);
        mmvprintw(i-gDirScrollTop+1, 1, "%s", buf);
        if(gDirCursor == i) mattroff();
    }
}
