INFO_PATH = ENV['HOME'] + "/.mfinfo"

###############################################################################
# ファイラーの状態をセーブ／読み込み
###############################################################################
def save_filer_stat()
    f = open(INFO_PATH, "w")

    f.puts "<Left dir path>"
    f.puts ldir_path()
    f.puts "<Right dir path>"
    f.puts rdir_path()

    f.puts "<tab>"
    f.puts tab_max()

    i = 0
    while i < tab_max()
        f.puts tab_path(i)
        f.puts tab_scrolltop(i)
        f.puts tab_cursor(i)

        i+=1
    end

    f.puts "<Left Dir Sort Kind>"
    f.puts sort_kind(0)

    f.puts "<Right Dir sort Kind>"
    f.puts sort_kind(1)

    f.puts "<Left Sort dir up>"
    f.puts "dummy"

    f.puts "<Right Sort dir up>"
    f.puts "dummy"

    f.puts "<Left Dir Name only>"
    f.puts view_nameonly(0)

    f.puts "<Right Dir Name only>"
    f.puts view_nameonly(1)

    f.puts "<Left Dir Focus Back>"
    f.puts view_focusback(0)

    f.puts "<Right Dir Focus Back>"
    f.puts view_focusback(1)

    f.puts "<Left Dir Remove Dir>"
    f.puts view_removedir(0)

    f.puts "<Right Dir Remove Dir>"
    f.puts view_removedir(1)

    f.puts "<Filer mode>"
    f.puts view_filer()

    f.puts "<color>"
    f.puts view_color()

    f.puts "<kanjicode file name>"
    f.puts kanjicode_filename()

    f.puts "<directory menu>"
    save_directory_menu(f)

    f.puts "<default dir>"
    f.puts $default_one_dir

    f.puts "<view option mtime>"
    f.puts view_mtime()
    f.puts "<view option size>"
    f.puts view_size()
    f.puts "<view option user>"
    f.puts view_user()
    f.puts "<view option group>"
    f.puts view_group()
    f.puts "<view option nlink>"
    f.puts view_nlink()
    f.puts "<view option permission>"
    f.puts view_permission()
    f.puts "<view fname divide ext>"
    f.puts view_fname_divide_ext()

    f.puts "<page view way>"
    f.puts $option_page_view_way

    f.puts "<file size view way>"
    f.puts $option_file_size_view_way

    f.puts "<Sort mark file up>"
    f.puts $option_sort_mark_file_up

    f.puts "<Sort dir up>"
    f.puts $option_sort_dir_up
    
    f.puts "<Commandline completion program files>"
    f.puts $cmdline_completion_programs.size
    
    $cmdline_completion_programs.each do |prog|
        f.puts prog
    end

    f.close
end

def load_filer_stat()
    if !File.exist?(INFO_PATH)
        return 
    end

    begin
        f = open(INFO_PATH, "r")

        f.readline
        line = f.readline.chomp!
        dir_move(0, line)

        f.readline
        line = f.readline.chomp!
        dir_move(1, line)

        f.readline
        max = f.readline.chomp!.to_i

        i = 0
        while i < max
            path = f.readline.chomp!
            scrolltop = f.readline.chomp!.to_i
            cursor = f.readline.chomp!.to_i

            tab_new(i, path, scrolltop, cursor)
            i += 1
        end

        f.readline
        line = f.readline.chomp!()
        set_sort_kind(0, line)

        f.readline
        line = f.readline.chomp!()
        set_sort_kind(1, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false

        f.readline
        line = f.readline.chomp!() == "true" ? true:false

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_nameonly(0, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_nameonly(1, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_focusback(0, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_focusback(1, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_removedir(0, line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_removedir(1, line)

        f.readline
        line = f.readline.chomp!()
        set_view_filer(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        set_view_color(line)

        f.readline
        line = f.readline.chomp!()
        set_kanjicode_filename(line)

        f.readline
        read_directory_menu(f)

        f.readline
        $default_one_dir = f.readline.chomp()

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_mtime(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_size(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_user(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_group(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_nlink(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_permission(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true: false
        set_view_fname_divide_ext(line)

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        $option_page_view_way = line

        f.readline
        line = f.readline.chomp!().to_i
        $option_file_size_view_way = line

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        $option_sort_mark_file_up = line

        f.readline
        line = f.readline.chomp!() == "true" ? true:false
        $option_sort_dir_up = line
        
        f.readline
        n = f.readline.chomp!().to_i
        
        n.times() do |i|
            prog = f.readline.chomp!()
            $cmdline_completion_programs.push(prog)
        end
    rescue
    end

    sort(0)
    sort(1)
end

