
def disk_read_hook_ldir()
    if $out_of_find_ldir
        dir = Dir.pwd()
        Dir.chdir(ldir_path())
        
        find_out = $out_of_find_ldir
    
        add_file(0, "..")
        
        find_out.each do |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            if fname[0..1] == "./"
                fname = fname[2..-1]
            end
            
            add_file(0, fname)
        end
        
        Dir.chdir(dir)
        
        return true
    elsif $mglob_ldir
        add_file(0, "..")

        $mglob_ldir.each do |file|
            add_file(0, file)
        end

        return true
    elsif $out_of_locate_ldir
        add_file(0, "..")

        locate_out = $out_of_locate_ldir
        
        locate_out.each do |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            add_file(0, fname)
        end
        
        return true
    elsif $out_of_grep_ldir
        dir = Dir.pwd()
        Dir.chdir(ldir_path())
        
        find_out = $out_of_grep_ldir
    
        add_file(0, "..")
        
        find_out.each do |line|
            line.chomp!()

            a = line.scan /(^.+):/
            if a
                b = a[0]

                if b
                    c = b[0]
                end
            end

            fname = c
            
            if fname 
                add_file(0, fname)
            end
        end
        
        Dir.chdir(dir)
        
        return true
    elsif $playlist_ldir
        add_file(0, "..")

        $playlist_ldir.each() do |fname|
            fname.chomp!()

            if fname[0] == "/"[0]
                fname = fname[1..-1]
            end

            add_file(0, fname)
        end

        return true
    else
        return nil
    end
end

def disk_read_hook_rdir()
    if $out_of_find_rdir
        dir = Dir.pwd()
        Dir.chdir(rdir_path())
        
        find_out = $out_of_find_rdir
        
        add_file(1, "..")
        
        find_out.each { |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            if fname[0..1] == "./"
                fname = fname[2..-1]
            end
            
            add_file(1, fname)
        }
        
        Dir.chdir(dir)
        
        return true
    elsif $out_of_locate_rdir
        add_file(1, "..")

        locate_out = $out_of_locate_rdir
        
        locate_out.each do |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            add_file(1, fname)
        end
        
        return true
    elsif $out_of_grep_rdir
        dir = Dir.pwd()
        Dir.chdir(rdir_path())
        
        find_out = $out_of_grep_rdir
    
        add_file(1, "..")
        
        find_out.each do |line|
            line.chomp!()

            a = line.scan /(^.+):/
            if a
                b = a[0]

                if b
                    c = b[0]
                end
            end

            fname = c
            
            if fname 
                add_file(1, fname)
            end
        end
        
        Dir.chdir(dir)
        
        return true
    elsif $mglob_rdir
        add_file(1, "..")

        $mglob_rdir.each do |file|
            add_file(1, file)
        end

        return true
    elsif $playlist_rdir
        add_file(1, "..")

        $playlist_rdir.each() do |fname|
            fname.chomp!()

            if fname[0] == "/"[0]
                fname = fname[1..-1]
            end

            add_file(1, fname)
        end

        return true
    else
        return nil
    end
end

def key_escape()
    if $playlist_ldir || $playlist_rdir || $out_of_find_ldir || $out_of_find_rdir || $out_of_grep_ldir || $out_of_grep_rdir || $out_of_locate_ldir || $out_of_locate_rdir || $mglob_ldir || $mglob_rdir
        finish_virtual_directory()
    else
        mark_clear(adir())
    end
end

def finish_virtual_directory()
    if is_adir_left
        $playlist_ldir = nil
        $out_of_locate_ldir = nil
        $out_of_find_ldir = nil
        $out_of_grep_ldir = nil
        $mglob_ldir = nil

        reread(0)
        reread(1)
    else
        $playlist_rdir = nil
        $out_of_locate_rdir = nil
        $out_of_find_rdir = nil
        $out_of_grep_rdir = nil
        $mglob_rdir = nil

        reread(0)
        reread(1)
    end
end

def path_change_hook(is_ldir)
    if is_adir_left
        $playlist_ldir = nil
        $out_of_locate_ldir = nil
        $out_of_find_ldir = nil
        $out_of_grep_ldir = nil
        $mglob_ldir = nil
    else
        $playlist_rdir = nil
        $out_of_locate_rdir = nil
        $out_of_find_rdir = nil
        $out_of_grep_rdir = nil
        $mglob_rdir = nil
    end
end

################################################################################
# mfind
################################################################################
def mfind(cmd)
    puts "searching disk..."
    
    set_signal_clear()
    if system(cmd)
        set_signal_mfiler2()

        f = open(ENV['MTEMP'] + "/mfiler_out_of_find", "r")
        out = f.read()
        f.close()

        if is_adir_left()
            $out_of_find_ldir = out
        else
            $out_of_find_rdir = out
        end

        reread(0)
        reread(1)
    else
        set_signal_mfiler2()
    end
end

if defined? MYCYGWINCOMPILE
    defmenu("find",
        "(a)ll",          KEY_a,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 21, \"mark_clear(adir())\") else cmdline_c(\"%R%q mfind(\\\"find .  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 20, nil) end",
        "(n)ame",          KEY_n,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -name '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -name '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "(r)egex",         KEY_r,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -regex '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 29, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -regex '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, nil) end",
        "(s)ize under",          KEY_s,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -size -c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -size -c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "(S)ize above",          KEY_S,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -size +c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -size +c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "S(i)ze just",          KEY_i,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -size c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -size c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 26, nil) end",
        "modified (m)in within",  KEY_m,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -mmin - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -mmin - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "modified (d)ay within", KEY_d,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -mtime - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 29, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -mtime - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, nil) end",
        "(u)ser",          KEY_u,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -user  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -user  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 26, nil) end",
        "(g)roup",         KEY_g,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -group  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -group  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "(p)ermision",     KEY_p,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -perm  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -perm  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 26, nil) end",
        "(P)ermision all bits",     KEY_P,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -perm -  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -perm -  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        "permision any bits (+)",     KEY_PLUS,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -perm + -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 28, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -perm + -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 27, nil) end",
        
        "t(y)pe",          KEY_y,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"find %m -type  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"find . -type  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 35, nil) end",
        "gr(e)p",          KEY_e,  "if marking(adir()) then cmdline_c(\"%R%q mvgrep(\\\"grep '' %m 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 20, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mvgrep(\\\"grep '' * 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 20, nil) end",
        "gr(E)p -r (recursive)",          KEY_E,  "if marking(adir()) then cmdline_c(\"%R%q mvgrep(\\\"grep -r '' %m 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 23, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mvgrep(\\\"grep -r '' * 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 23, nil) end",
        "(l)ocate",          KEY_l,  "cmdline_c(\"%R%q mlocate(\\\"locate  2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_locate\\\")\", 22, nil)",
        "(w)ild card",          KEY_w,  "cmdline_c('%R%q mglob(\"\")', -2, nil)"
    )
else
    defmenu("find",
        "(a)ll",          KEY_a,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 30, \"mark_clear(adir())\") else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find .  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 29, nil) end",
        "(n)ame",          KEY_n,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -name '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -name '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "(r)egex",         KEY_r,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -regex '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 38, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -regex '' -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, nil) end",
        "(s)ize under",          KEY_s,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -size -c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -size -c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "(S)ize above",          KEY_S,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -size +c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -size +c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "S(i)ze just",          KEY_i,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -size c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -size c -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 35, nil) end",
        "modified (m)in within",  KEY_m,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -mmin - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -mmin - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "modified (d)ay within", KEY_d,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -mtime - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 38, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -mtime - -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, nil) end",
        "(u)ser",          KEY_u,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -user  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -user  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 35, nil) end",
        "(g)roup",         KEY_g,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -group  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -group  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "(p)ermision",     KEY_p,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -perm  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -perm  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 35, nil) end",
        "(P)ermision all bits",     KEY_P,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -perm -  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -perm -  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "permision any bits (+)",     KEY_PLUS,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -perm + -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 37, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -perm + -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, nil) end",
        "t(y)pe",          KEY_y,  "if marking(adir()) then cmdline_c(\"%R%q mfind(\\\"/usr/bin/find %m -type  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 36, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mfind(\\\"/usr/bin/find . -type  -follow 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_find\\\")\", 35, nil) end",
        "gr(e)p",          KEY_e,  "if marking(adir()) then cmdline_c(\"%R%q mvgrep(\\\"grep '' %m 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 20, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mvgrep(\\\"grep '' * 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 20, nil) end",
        "gr(E)p -r (recursive)",          KEY_E,  "if marking(adir()) then cmdline_c(\"%R%q mvgrep(\\\"grep -r '' %m 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 23, \"mark_clear(adir())\"); else cmdline_c(\"%R%q mvgrep(\\\"grep -r '' * 2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep2\\\")\", 23, nil) end",
        "(l)ocate",          KEY_l,  "cmdline_c(\"%R%q mlocate(\\\"locate  2> /dev/null | tee '#{ENV['MTEMP']}'/mfiler_out_of_locate\\\")\", 22, nil)",
        "(w)ild card",          KEY_w,  "cmdline_c('%R%q mglob(\"\")', -2, nil)"
    )
end

def menu_find()
    menu('find')
end

###############################################################################
# プレイリスト
###############################################################################
def playlist_start(fname)
    if is_adir_left
        if $playlist_ldir == nil
            set_scrolltop(0, 0)
            cursor_move(0, 1)

            begin
                f = open(fname, "r")
                $playlist_ldir = f.read()
                f.close
            rescue
                puts fname
                exit(1)
                return false
            end

            ### 絶対パスのファイルリストを相対パスのファイルリストに変換 ###
            new_playlist_ldir = ""
            path2 = adir_path()

            $playlist_ldir.each() do |fname|
                fname.chomp!()
                
                path1 = fname

                n = path2.size - 1
                while n >= 0
                    if path1.include?(path2[0..n])
                        same = path2[0..n]
                        diff = path1[n+1..-1]
                        break
                    end

                    n = n -1
                end

                new_playlist_ldir += "../" * path2[same.size..-1].scan(/\//).size + diff
                new_playlist_ldir += "\n"
            end

            $playlist_ldir = new_playlist_ldir

            reread(0)
        end
    else 
        if $playlist_rdir == nil
            set_scrolltop(1, 0)
            cursor_move(1, 1)

            begin
                f = open(fname, "r")
                $playlist_rdir = f.read()
                f.close
            rescue
                puts fname
                exit(1)
                return false
            end

            ### 絶対パスのファイルリストを相対パスのファイルリストに変換 ###
            new_playlist_rdir = ""
            path2 = adir_path()

            $playlist_rdir.each() do |fname|
                fname.chomp!()
                
                path1 = fname

                n = path2.size - 1
                while n >= 0
                    if path1.include?(path2[0..n])
                        same = path2[0..n]
                        diff = path1[n+1..-1]
                        break
                    end

                    n = n -1
                end

                new_playlist_rdir += "../" * path2[same.size..-1].scan(/\//).size + diff
                new_playlist_rdir += "\n"
            end

            $playlist_rdir = new_playlist_rdir

            reread(1)
        end
    end
end

def playlist_start2(fname)
    if is_adir_left
        if $playlist_ldir == nil
            dir_move(0, "/")

            begin
                f = open(fname, "r")
                $playlist_ldir = f.read()
                f.close
            rescue
                return false
            end

            reread(0)
        end
    else 
        if $playlist_rdir == nil
            dir_move(1, "/")

            begin
                f = open(fname, "r")
                $playlist_rdir = f.read()
                f.close
            rescue
                return false
            end

            reread(1)
        end
    end
end

def make_new_playlist(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))

        $making_playlist_path = adir_path() + fname
    end
end

def add_cursor_file_to_making_playlist()
    if $making_playlist_path == nil
        message("$making_playlist_path is nil")
    else
        if marking(adir())
            f = open($making_playlist_path, "a")
            adir_mark_fullpath.each do |path|
                f.puts path
            end

            mark_clear(adir())
            f.close

            message("add marking files to " + $making_playlist_path)
        else
            f = open($making_playlist_path, "a")
            f.puts cursor_path()
            f.close

            message("add " + cursor_path + " to " + $making_playlist_path)
        end
    end
end

def change_making_playlist()
    if cursor_ext() == "list"
        $making_playlist_path = cursor_path()
        message('setted ' + cursor_path + ' as $making_playlist_path')
    else
        message("cursor file is not playlist")
    end
end


def mvgrep(cmd)
    puts "grepping disk..."
    
    set_signal_clear()
    if system(cmd)
        set_signal_mfiler2()

        f = open(ENV['MTEMP'] + "/mfiler_out_of_grep2", "r")
        out = f.read()
        f.close()

        if is_adir_left()
            $out_of_grep_ldir = out
        else
            $out_of_grep_rdir = out
        end

        reread(0)
        reread(1)
    else
        set_signal_mfiler2()
    end
end



def mglob(wc)
    if is_adir_left()
        $mglob_ldir = Dir::glob(wc)
    else
        $mglob_rdir = Dir::glob(wc)
    end
    
    reread(0)
    reread(1)
end

def mlocate(cmd)
    puts "searching disk..."
    
    set_signal_clear()
    if system(cmd)
        set_signal_mfiler2()

#        if File.new(ENV['MTEMP'] + "/mfiler_out_of_locate").stat.size != 0
            dir_move(adir(), "/")

            f = open(ENV['MTEMP'] + "/mfiler_out_of_locate", "r")
            out = f.read()
            f.close()

            if is_adir_left()
                $out_of_locate_ldir = out
            else
                $out_of_locate_rdir = out
            end

            reread(0)
            reread(1)
#        else
#            set_signal_mfiler2()
#        end
    else
        set_signal_mfiler2()
    end
end

