#include "config.h"
#include "minato_extra.h"
#include "minato_debug.h"
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

////////////////////////////////////////////////////////////////////////////////
// gqԂ
////////////////////////////////////////////////////////////////////////////////
ALLOCATED char* extname(char* name)
{
    char* p;
    
    for(p = name + strlen(name); p != name; p--) {
        if(*p == '.' && p == name + strlen(name)) {
            return STRDUP("");
        }
        else if(*p == '/') {
            return STRDUP("");
        }
        else if(*p == '.') {
            return (char*)STRDUP(p+1);
        }
    }

    return (char*)STRDUP("");
}

////////////////////////////////////////////////////////////////////////////////
// gqȊOԂ
////////////////////////////////////////////////////////////////////////////////
ALLOCATED char* noextname(char* name)
{
    char* max;
    char* p;
    
    max = name + strlen(name);
    for(p = name; p < max; p++) {
        if(*p == '.') {
            char* result = (char*)MALLOC(p - name + 1);
            memcpy(result, name, p - name);
            result[p - name] = 0;
            return result;
        }
    }

    return (char*)STRDUP(name);
}

////////////////////////////////////////////////////////////////////////////////
// efBNgԂ
////////////////////////////////////////////////////////////////////////////////
ALLOCATED char* parentname(char* path)
{
    char* p;
    
    if(strcmp(path, "/") == 0) return (char*)STRDUP("/");

    for(p=path + strlen(path)-2; p != path-1; p--) {
        if(*p == '/') {
            char* result = (char*)MALLOC(p-path + 2);
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return result;
        }
    }

    return (char*)STRDUP("/");
}

////////////////////////////////////////////////////////////////////////////////
// JgfBNgԂ
////////////////////////////////////////////////////////////////////////////////
ALLOCATED char* mygetcwd()
{
    int l;
    char* result;
    
    l = 50;
    result = (char*)MALLOC(l);
    
    while(!getcwd(result, l)) {
         l += 50;
         result = (char*)REALLOC(result, l);
    }

    return result;
}

////////////////////////////////////////////////////////////////////////////////
// stat烆[U[Ԃ
////////////////////////////////////////////////////////////////////////////////
char* mygetpwuid(struct stat* statbuf)
{
    struct passwd* ud;
    
    ud = getpwuid(statbuf->st_uid);
        
    if(ud)
        return ud->pw_name;
    else
        return NULL;
}

////////////////////////////////////////////////////////////////////////////////
// statO[vԂ
////////////////////////////////////////////////////////////////////////////////
char* mygetgrgid(struct stat* statbuf)
{
    struct group* gd;

    gd = getgrgid(statbuf->st_gid);
    if(gd)
        return gd->gr_name;
    else
        return NULL;
}

////////////////////////////////////////////////////////////////////////////////
// Ԃ
////////////////////////////////////////////////////////////////////////////////
char* mystrcasestr(const char *haystack, const char *needle)
{
    char* p;
    p = (char*)haystack;

    while(*p) {
        char* p2;
        char* p3;
        BOOL match;

        p2 = p;
        p3 = (char*)needle;
        
        match = TRUE;
        while(*p3) {
            if(*p2 == 0) {
                match = FALSE;
                break;
            }
            
            if(tolower(*p2) != tolower(*p3)) {
                match = FALSE;
                break;
            }
            
            p2++;
            p3++;
        }
        
        if(match) {
            return p;
        }
        
        p++;
    }
    
    return NULL;
}

////////////////////////////////////////////////////////////////////////////////
// Sɂ
////////////////////////////////////////////////////////////////////////////////
void mystrtolower(char* result)
{
    int i;

    for(i=0; i<strlen(result); i++) {
        result[i] = tolower(result[i]);
    }
}

