#include "common.h"

#include <kitutuki.h>
#include <errno.h>
#include <libgen.h>

#include "config.h"

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

BOOL commands_quit(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(kitutuki_job_num() == 0) {
        gMainLoop = FALSE;
        *rcode = 0;
    }
    else {
        if(mis_raw_mode()) {
            err_msg("jobs exist");
        }
        else {
            fprintf(stderr, "jobs exist\n");
        }
    }

    return TRUE;
}

BOOL commands_keycommand(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 5) {
        char* argv1 = string_c_str(vector_item(argv, 1));
        char* argv2 = string_c_str(vector_item(argv, 2));
        char* argv3 = string_c_str(vector_item(argv, 3));
        char* argv4 = string_c_str(vector_item(argv, 4));

        int meta = atoi(argv1);
        int keycode = atoi(argv2);

        filer_add_keycommand(meta, keycode, argv3, argv4);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_keymap(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 12) {
        char keys[kKeyMapKeysMax];

        keys[0] = atoi(string_c_str(vector_item(argv, 2)));
        keys[1] = atoi(string_c_str(vector_item(argv, 3)));
        keys[2] = atoi(string_c_str(vector_item(argv, 4)));
        keys[3] = atoi(string_c_str(vector_item(argv, 5)));
        keys[4] = atoi(string_c_str(vector_item(argv, 6)));
        keys[5] = atoi(string_c_str(vector_item(argv, 7)));
        keys[6] = atoi(string_c_str(vector_item(argv, 8)));
        keys[7] = atoi(string_c_str(vector_item(argv, 9)));
        keys[8] = atoi(string_c_str(vector_item(argv, 10)));
        keys[9] = atoi(string_c_str(vector_item(argv, 11)));

        madd_keymap(atoi(string_c_str(vector_item(argv, 1)))
                    , keys);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_cursor_move(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        char* argv2 = string_c_str((string_obj*)vector_item(argv, 1));

        int cursor_num;
        if(argv2[0] == '+') {
            char buf[BUFSIZ];
            memcpy(buf, argv2+1, strlen(argv2));
            sDir* dir2 = filer_dir(dir);
            if(dir2) {
                cursor_num = dir2->mCursor + atoi(buf);
            }
            else {
                cursor_num = 0;
            }
        }
        else if(argv2[0] == '-') {
            char buf[BUFSIZ];
            memcpy(buf, argv2+1, strlen(argv2));
            sDir* dir2 = filer_dir(dir);
            if(dir2) {
                cursor_num = dir2->mCursor - atoi(buf);
            }
        }
        else if(argv2[0] == '/') {
            char buf[BUFSIZ];
            memcpy(buf,argv2+1, strlen(argv2));
            cursor_num = filer_file2(dir, buf);
            if(cursor_num == -1) {
                cursor_num = 0;
            }
        }
        else {
            cursor_num = atoi(argv2);
        }

        if(dir < 0) {
            int j;
            for(j=0; j<vector_size(gDirs); j++) {
                filer_cursor_move(j, cursor_num);
            }
        }
        else {
            filer_cursor_move(dir, cursor_num);
        }

        *rcode = 0;
    }

    if(*rcode == 0) {
        char buf[128];
        sprintf(buf, "cursor_move_hook %d", dir);
        int rcode2 = kitutuki_shell(buf, "cursor_move_hook", nextout, nextin, nexterr);

        if(rcode2 < 0) {
            if(mis_raw_mode()) {
                err_msg("%s", gErrMsg);
            }
            else {
                fprintf(stderr, "%s", gErrMsg);
            }

            *rcode = 1;
            return FALSE;
        }
    }

    return TRUE;
}

BOOL commands_mcd(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int dir = adir();
    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(dir < 0) {
        err_msg("can't mcd -d all");
        return FALSE;
    }

    if(vector_size(argv) == 2) {
        char* arg1 = string_c_str(vector_item(argv, 1));

        if(strcmp(arg1, "+") == 0) {
            filer_history_forward(dir);
            *rcode = 0;
        }
        else if(strcmp(arg1, "-") == 0) {
            filer_history_back(dir);
            *rcode = 0;
        }
        else {
            filer_cd(dir, arg1);
            *rcode = 0;
        }
    }
    else if(vector_size(argv) == 1) {
        filer_cd(dir, "~");
        *rcode = 0;
    }

    /// եå ///
    if(*rcode == 0) {
        char buf[128];
        sprintf(buf, "mcd_hook %d", dir);

        int rcode2 = kitutuki_shell(buf, "mcd_hook", nextout, nextin, nexterr);
        if(rcode2 < 0) {
            if(mis_raw_mode()) {
                err_msg(gErrMsg);
            }
            else {
                fprintf(stderr, "%s", gErrMsg);
            }

            *rcode = 1;

            return FALSE;
        }
    }

    return TRUE;
}

BOOL commands_file_name(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        char* argv2 = string_c_str((string_obj*)vector_item(argv, 1));

        sFile* file = filer_file(dir, atoi(argv2));
        if(file) {
            char buf[BUFSIZ];
            sprintf(buf, "%s", string_c_str(file->mName));
            write(nextout, buf, strlen(buf));

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_path(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        sDir* dir2 = filer_dir(dir);
        if(dir2) {
            char buf[BUFSIZ];
            sprintf(buf, "%s", string_c_str(dir2->mPath));
            write(nextout, buf, strlen(buf));
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_file_ext(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        char* argv2 = string_c_str((string_obj*)vector_item(argv, 1));
        sFile* file = filer_file(dir, atoi(argv2));
        if(file) {
            char buf[BUFSIZ];
            extname(buf, string_c_str(file->mName));
            write(nextout, buf, strlen(buf));

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_file_index(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        char* argv1 = string_c_str((string_obj*)vector_item(argv, 1));

        char buf[BUFSIZ];
        sprintf(buf, "%d", filer_file2(dir, argv1));

        write(nextout, buf, strlen(buf));
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_file_user(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        int argv1 = atoi(string_c_str(vector_item(argv, 1)));

        sFile* file = filer_file(dir, argv1);

        if(file) {
            char buf[BUFSIZ];
            sprintf(buf, "%s", string_c_str(file->mUser));
            write(nextout, buf, strlen(buf));

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_file_group(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        int argv1 = atoi(string_c_str(vector_item(argv, 1)));

        sFile* file = filer_file(dir, argv1);

        if(file) {
            char buf[BUFSIZ];
            sprintf(buf, "%s", string_c_str(file->mGroup));
            write(nextout, buf, strlen(buf));

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_file_perm(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        int argv1 = atoi(string_c_str(vector_item(argv, 1)));

        sFile* file = filer_file(dir, argv1);

        if(file) {
            int n = file->mLStat.st_mode & S_ALLPERM;

            char buf[BUFSIZ];
            sprintf(buf, "%o", n);
            write(nextout, buf, strlen(buf));

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_file_num(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        sDir* dir2 = filer_dir(dir);
        if(dir2) {
            char buf[BUFSIZ];
            sprintf(buf, "%d", vector_size(dir2->mFiles));
            write(nextout, buf, strlen(buf));
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_dir_num(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 1) {
        char buf[BUFSIZ];
        sprintf(buf, "%d", vector_size(gDirs));
        write(nextout, buf, strlen(buf));
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_cursor_num(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(dir < 0) {
            err_msg("invalid option -d all");
            return FALSE;
        }

        sDir* dir2 = filer_dir(dir);

        if(dir2) {
            char buf[BUFSIZ];
            sprintf(buf, "%d", dir2->mCursor);
            write(nextout, buf, strlen(buf));
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_isearch(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    gISearch = TRUE;
    *rcode = 0;

    return TRUE;
}

BOOL commands_cmdline(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    BOOL quick = FALSE;
    BOOL continue_ = FALSE;
    int j=0;
    for(j=1; j<vector_size(argv); j++) {
        char* item = string_c_str(vector_item(argv, j));

        if(strcmp(item, "-q") == 0) {
            quick = TRUE;
            string_delete(vector_item(argv, j));
            vector_erase(argv, j);
            j--;
            continue;
        }
        else if(strcmp(item, "-c") == 0) {
            continue_ = TRUE;
            string_delete(vector_item(argv, j));
            vector_erase(argv, j);
            j--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        cmdline_start("", 0, quick, continue_);
        *rcode = 0;
    }
    else if(vector_size(argv) == 2) {
        char* init_str = string_c_str(vector_item(argv, 1));
        cmdline_start(init_str, -1, quick, continue_);
        *rcode = 0;
    }
    else if(vector_size(argv) == 3) {
        char* init_str = string_c_str(vector_item(argv, 1));
        int cursor = atoi(string_c_str(vector_item(argv, 2)));
        cmdline_start(init_str, cursor, quick, continue_);
        *rcode = 0;
    }
    else if(vector_size(argv) == 4) {
        char* init_str = string_c_str(vector_item(argv, 1));
        int cursor = atoi(string_c_str(vector_item(argv, 2)));

        string_obj* init_str2 = STRING_NEW("");
        cmdline_start(string_c_str(init_str2), cursor, quick, continue_);
        *rcode = 0;
    }

    if(*rcode == 0) {
        int rcode2 = kitutuki_shell("cmdline_hook", "cursor_move_hook", nextout, nextin, nexterr);

        if(rcode2 < 0) {
            if(mis_raw_mode()) {
                err_msg("%s", gErrMsg);
            }
            else {
                fprintf(stderr, "%s", gErrMsg);
            }

            *rcode = 1;
            return FALSE;
        }
    }

    return TRUE;
}

BOOL commands_external(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    BOOL hitanykey = TRUE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-q") == 0) {
            hitanykey = FALSE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        ///  ///
        const int maxy = mgetmaxy();
        mclear_online(maxy-2);
        mclear_online(maxy-1);
        mmove(maxy-2, 0);
        mrefresh();
        /*
        mclear();
        mmove(0,0);
        mrefresh();
        */
        mendwin();
        mreset_tty();

        /// ޥɼ¹ ///
        kitutuki_set_signal();
        int r = kitutuki_shell(string_c_str(vector_item(argv, 1)), "run", STDOUT_FILENO, STDIN_FILENO, STDERR_FILENO);
        set_signal_mfiler();

        if(r < 0) { printf("%s", gErrMsg); }
/*
        /// ǥ쥯ȥɤ߹ ///
        if(strcmp(getenv("VIEW_OPTION"), "2pain") == 0) {
            filer_reread(0);
            filer_reread(1);
        }
        else {
            filer_reread(adir());
        }
*/
        /// HIT ANY KEY ///
        if(hitanykey || r < 0) {
            putp(tigetstr("rev"));
            printf("HIT ANY KEY");
            putp(tigetstr("sgr0"));
            fflush(stdout);

            minitscr();
            int meta;
            mgetch(&meta);
        }
        else {
            minitscr();
        }

        //mclear_immediately();

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_activate(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 2) {
        int n = atoi(string_c_str(vector_item(argv, 1)));
        filer_activate(n);
        *rcode = 0;

        char buf[128];
        sprintf(buf, "activate_hook %d", n);

        int rcode2 = kitutuki_shell(buf, "activate_hook", nextout, nextin, nexterr);

        if(rcode2 < 0) {
            if(mis_raw_mode()) {
                err_msg(gErrMsg);
            }
            else {
                fprintf(stderr, "%s", gErrMsg);
            }
            *rcode = 1;
            return FALSE;
        }
    }


    return TRUE;
}

BOOL commands_defmenu(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    /// Υå ///
    if(vector_size(argv)%3 != 2) {
        err_msg("defmenu argument number err");
        return FALSE;
    }
    else {
        char* menu_name = string_c_str(vector_item(argv, 1));
        
        sMenu* new_menu = sMenu_new(menu_name);

        int j;
        for(j=2; j<vector_size(argv); j+=3) {
            char* argv1 = string_c_str(vector_item(argv, j));
            char* argv2 = string_c_str(vector_item(argv, j+1));
            char* argv3 = string_c_str(vector_item(argv, j+2));
            menu_append(new_menu, argv1, atoi(argv2), argv3);
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_addmenu(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    /// Υå ///
    if(vector_size(argv)%3 != 2) {
        err_msg("addmenu argument number err");
        return FALSE;
    }
    else {
        char* menu_name = string_c_str(vector_item(argv, 1));
        
        sMenu* menu = hash_item(gMenu, menu_name);

        if(menu) {
            int j;
            for(j=2; j<vector_size(argv); j+=3) {
                char* argv1 = string_c_str(vector_item(argv, j));
                char* argv2 = string_c_str(vector_item(argv, j+1));
                char* argv3 = string_c_str(vector_item(argv, j+2));
                menu_append(menu, argv1, atoi(argv2), argv3);
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_menu(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 2) {
        char* menu_name = string_c_str(vector_item(argv, 1));

        gActiveMenu = hash_item(gMenu, menu_name);
        if(gActiveMenu) {
            gActiveMenu->mScrollTop = 0;
            gActiveMenu->mCursor = 0;
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_reread(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(dir < 0) {
            int j;
            for(j=0; j<vector_size(gDirs); j++) {
                filer_reread(j);
            }
            *rcode = 0;
        }
        else {
            filer_reread(dir);
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_allfiles(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    BOOL fullpath = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-fullpath") == 0) {
            fullpath = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(fullpath) {
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    sDir* dir2 = filer_dir(i);

                    int j;
                    for(j=0; j<vector_size(dir2->mFiles); j++) {
                        sFile* file = vector_item(dir2->mFiles, j);

                        if(strcmp(string_c_str(file->mName), ".") != 0
                            && strcmp(string_c_str(file->mName), "..") != 0) 
                        {
                            char path[PATH_MAX];
                            strcpy(path, string_c_str(dir2->mPath));
                            strcat(path, string_c_str(file->mName));

                            string_obj* str = STRING_NEW("");
                            kitutuki_get_quoted_fname(path, str);

                            write(nextout, string_c_str(str), string_length(str));
                            write(nextout, " ", 1);

                            string_delete(str);
                        }
                    }
                }
            }
            else {
                sDir* dir2 = filer_dir(dir);

                int j;
                for(j=0; j<vector_size(dir2->mFiles); j++) {
                    sFile* file = vector_item(dir2->mFiles, j);
                    if(strcmp(string_c_str(file->mName), ".") != 0
                        && strcmp(string_c_str(file->mName), "..") != 0) 
                    {
                        char path[PATH_MAX];
                        strcpy(path, string_c_str(dir2->mPath));
                        strcat(path, string_c_str(file->mName));

                        string_obj* str = STRING_NEW("");
                        kitutuki_get_quoted_fname(path, str);

                        write(nextout, string_c_str(str), string_length(str));
                        write(nextout, " ", 1);

                        string_delete(str);
                    }
                }

            }

            *rcode = 0;
        }
    }
    else {
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    sDir* dir2 = filer_dir(i);

                    int j;
                    for(j=0; j<vector_size(dir2->mFiles); j++) {
                        sFile* file = vector_item(dir2->mFiles, j);

                        if(strcmp(string_c_str(file->mName), ".") != 0
                            && strcmp(string_c_str(file->mName), "..") != 0) 
                        {
                            string_obj* str = STRING_NEW("");
                            kitutuki_get_quoted_fname(string_c_str(file->mName)
                                                        , str);

                            write(nextout, string_c_str(str), string_length(str));
                            write(nextout, " ", 1);

                            string_delete(str);
                        }
                    }
                }
            }
            else {
                sDir* dir2 = filer_dir(dir);

                int j;
                for(j=0; j<vector_size(dir2->mFiles); j++) {
                    sFile* file = vector_item(dir2->mFiles, j);
                    if(strcmp(string_c_str(file->mName), ".") != 0
                        && strcmp(string_c_str(file->mName), "..") != 0) 
                    {
                        string_obj* str = STRING_NEW("");
                        kitutuki_get_quoted_fname(string_c_str(file->mName)
                                                    , str);

                        write(nextout, string_c_str(str), string_length(str));
                        write(nextout, " ", 1);

                        string_delete(str);
                    }
                }

            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_markfiles(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    BOOL fullpath = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-fullpath") == 0) {
            fullpath = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(fullpath) {
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    if(filer_marking(i)) {
                        sDir* dir2 = filer_dir(i);

                        int j;
                        for(j=0; j<vector_size(dir2->mFiles); j++) {
                            sFile* file = vector_item(dir2->mFiles, j);
                            if(file->mMark) {
                                char path[PATH_MAX];
                                strcpy(path, string_c_str(dir2->mPath));
                                strcat(path, string_c_str(file->mName));

                                string_obj* str = STRING_NEW("");
                                kitutuki_get_quoted_fname(path, str);

                                write(nextout, string_c_str(str), string_length(str));
                                write(nextout, " ", 1);

                                string_delete(str);
                            }
                        }
                    }
                    else {
                        sDir* dir2 = filer_dir(i);
                        sFile* file = filer_cursor_file(i);

                        char path[PATH_MAX];
                        strcpy(path, string_c_str(dir2->mPath));
                        strcat(path, string_c_str(file->mName));

                        string_obj* str = STRING_NEW("");
                        kitutuki_get_quoted_fname(path, str);

                        write(nextout, string_c_str(str)
                                , string_length(str));

                        string_delete(str);
                    }
                }
            }
            else {
                if(filer_marking(dir)) {
                    sDir* dir2 = filer_dir(dir);

                    int j;
                    for(j=0; j<vector_size(dir2->mFiles); j++) {
                        sFile* file = vector_item(dir2->mFiles, j);
                        if(file->mMark) {
                            char path[PATH_MAX];
                            strcpy(path, string_c_str(dir2->mPath));
                            strcat(path, string_c_str(file->mName));

                            string_obj* str = STRING_NEW("");
                            kitutuki_get_quoted_fname(path, str);

                            write(nextout, string_c_str(str)
                                        , string_length(str));
                            write(nextout, " ", 1);

                            string_delete(str);
                        }
                    }
                }
                else {
                    sDir* dir2 = filer_dir(dir);
                    sFile* file = filer_cursor_file(dir);

                    char path[PATH_MAX];
                    strcpy(path, string_c_str(dir2->mPath));
                    strcat(path, string_c_str(file->mName));

                    string_obj* str = STRING_NEW("");
                    kitutuki_get_quoted_fname(path, str);

                    write(nextout, string_c_str(str), string_length(str));

                    string_delete(str);
                }
            }

            *rcode = 0;
        }
    }
    else {
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    if(filer_marking(i)) {
                        sDir* dir2 = filer_dir(i);

                        int j;
                        for(j=0; j<vector_size(dir2->mFiles); j++) {
                            sFile* file = vector_item(dir2->mFiles, j);
                            if(file->mMark) {
                                string_obj* str = STRING_NEW("");
                                kitutuki_get_quoted_fname(
                                        string_c_str(file->mName), str);

                                write(nextout, string_c_str(str), string_length(str));
                                write(nextout, " ", 1);

                                string_delete(str);
                            }
                        }
                    }
                    else {
                        sFile* file = filer_cursor_file(i);

                        string_obj* str = STRING_NEW("");
                        kitutuki_get_quoted_fname(string_c_str(file->mName)
                                                    , str);

                        write(nextout, string_c_str(str), string_length(str));

                        string_delete(str);
                    }
                }
            }
            else {
                if(filer_marking(dir)) {
                    sDir* dir2 = filer_dir(dir);

                    int j;
                    for(j=0; j<vector_size(dir2->mFiles); j++) {
                        sFile* file = vector_item(dir2->mFiles, j);
                        if(file->mMark) {
                            string_obj* str = STRING_NEW("");
                            kitutuki_get_quoted_fname(string_c_str(file->mName)
                                                        , str);

                            write(nextout, string_c_str(str), string_length(str));
                            write(nextout, " ", 1);

                            string_delete(str);
                        }
                    }
                }
                else {
                    sFile* file = filer_cursor_file(dir);

                    string_obj* str = STRING_NEW("");
                    kitutuki_get_quoted_fname(string_c_str(file->mName)
                                                , str);

                    if(write(nextout, string_c_str(str), string_length(str)) < 0) 
                    {
                        perror("write");
                        exit(1);
                    }

                    string_delete(str);
                }
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_mark(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
// user group perm
    int l;
    BOOL toggle = FALSE;
    BOOL files = FALSE;
    BOOL number = FALSE;
    BOOL all = FALSE;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-t") == 0) {
            toggle = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-f") == 0) {
            files = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-n") == 0) {
            number = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-a") == 0) {
            all = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(dir < 0) {
        err_msg("invalid mark option. can't use to mark -d all");
        return FALSE;
    }

    /// ֻ ///
    if(!all && !toggle && vector_size(argv) == 2)
    {
        char* arg1 = string_c_str(vector_item(argv, 1));

        int arg1_num;
        if(number) {
            arg1_num = atoi(arg1);
        }
        else {
            arg1_num = filer_file2(dir, arg1);
        }

        if(arg1_num >= 0) {
            if(filer_mark(dir, arg1_num)) {
                if(write(nextout, "1", 1) < 0) {
                    perror("write");
                    exit(1);
                }

                *rcode = 0;
            }
            else {
                if(write(nextout, "0", 1) < 0) {
                    perror("write");
                    exit(1);
                }

                *rcode = 0;
            }
        }
    }
    /// ֥å all toggle ///
    else if(all && toggle && vector_size(argv) == 1) {
        sDir* dir2 = filer_dir(dir);
        int i;
        for(i=0; i<vector_size(dir2->mFiles); i++) {
            sFile* file = vector_item(dir2->mFiles, i);
            if(strcmp(string_c_str(file->mName), ".") != 0
                && strcmp(string_c_str(file->mName), "..") != 0)
            {
                if(!files || !S_ISDIR(file->mStat.st_mode)) {
                    file->mMark = !file->mMark;
                }
            }
        }

        *rcode = 0;
    }
    /// ֥å all toggle ͻ ///
    else if(all && !toggle && vector_size(argv) == 2) {
        int arg1 = atoi(string_c_str(vector_item(argv, 1)));

        sDir* dir2 = filer_dir(dir);
        int i;
        for(i=0; i<vector_size(dir2->mFiles); i++) {
            sFile* file = vector_item(dir2->mFiles, i);
            if(strcmp(string_c_str(file->mName), ".") != 0
                && strcmp(string_c_str(file->mName), "..") != 0)
            {
                if(!files || !S_ISDIR(file->mStat.st_mode)) {
                    file->mMark = arg1 != 0;
                }
            }
        }

        *rcode = 0;
    }

    /// ֥å եҤȤ ///
    else if(!all && !toggle && vector_size(argv) == 3) {
        char* arg1 = string_c_str(vector_item(argv, 1));

        int arg1_num;
        if(number) {
            arg1_num = atoi(arg1);
        }
        else {
            arg1_num = filer_file2(dir, arg1);
        }

        int arg2 = atoi(string_c_str(vector_item(argv, 2)));
        if(arg1_num >= 0) filer_set_mark(dir, arg1_num, arg2 != 0);

        *rcode = 0;
    }

    /// ֥å եҤȤ ///
    else if(!all && toggle && vector_size(argv) == 2) {
        char* arg1 = string_c_str(vector_item(argv, 1));

        int arg1_num;
        if(number) {
            arg1_num = atoi(arg1);
        }
        else {
            arg1_num = filer_file2(dir, arg1);
        }

        if(arg1_num >= 0) filer_toggle_mark(dir, arg1_num);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_new_dir(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(vector_size(argv) == 2) {
        char* dir = string_c_str(vector_item(argv, 1));
        filer_new_dir(dir);
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_del_dir(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(dir < 0) {
        err_msg("can't run marking -d all");
        return FALSE;
    }

    if(vector_size(argv) == 1) {
        filer_del_dir(dir);

        *rcode = 0;
    }

    return TRUE;
}



BOOL commands_marking(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(dir < 0) {
        err_msg("can't run marking -d all");
        return FALSE;
    }

    if(vector_size(argv) == 1) {
        if(filer_marking(dir)) {
            write(nextout, "1", 1);
        }
        else {
            write(nextout, "0", 1);
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_mask(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    int dir = adir();
    BOOL dotdir = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-d") == 0 && l+1 < vector_size(argv)) {
            char* darg = string_c_str(vector_item(argv, l+1));
            if(strcmp(darg, "all") == 0) {
                dir = -1;
            }
            else if(strcmp(darg, "adir") == 0) {
                dir = adir();
            }
            else if(strcmp(darg, "sdir") == 0) {
                dir = sdir();
            }
            else {
                dir = atoi(string_c_str(vector_item(argv, l+1)));
            }
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-dotdir") == 0) {
            dotdir = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(dotdir) {
        /// ֻ ///
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                err_msg("invalid use. mask -d all");
                return FALSE;
            }

            if(filer_dotdir_mask(dir)) {
                if(write(nextout, "1", 1) < 0) {
                    perror("write");
                    exit(1);
                }
            }
            else {
                if(write(nextout, "0", 1) < 0) {
                    perror("write");
                    exit(1);
                }
            }

            *rcode = 0;
        }

        /// ֥å ///
        else if(vector_size(argv) == 2) {
            int arg2 = atoi(string_c_str(vector_item(argv, 1)));

            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    filer_set_dotdir_mask(i, arg2 != 0);
                }
            }
            else {
                filer_set_dotdir_mask(dir, arg2 != 0);
            }

            *rcode = 0;
        }
    }
    else {
        /// ֻ ///
        if(vector_size(argv) == 1) {
            if(dir < 0) {
                err_msg("invalid use. mask -d all");
                return FALSE;
            }

            char* p = filer_mask(dir);
            if(write(nextout, p, strlen(p)) < 0) {
                perror("write");
                exit(1);
            }

            *rcode = 0;
        }

        /// ֥å ///
        else if(vector_size(argv) == 2) {
            if(dir < 0) {
                int i;
                for(i=0; i<vector_size(gDirs); i++) {
                    filer_set_mask(i, string_c_str(vector_item(argv, 1)));
                }

                filer_reread(0);
                filer_reread(1);
            }
            else {
                filer_set_mask(dir, string_c_str(vector_item(argv, 1)));

                if(dir == 0)
                    filer_reread(0);
                else if(dir == 1) 
                    filer_reread(1);
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL commands_vd(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    filer_vd_start(adir());
    filer_vd_add(adir(), "..");

    string_obj* str = STRING_NEW("");
    while(1) {
        char buf[BUFSIZ+1];
        int r;
        r = read(nextin, buf, BUFSIZ);

        if(r < 0) {
            if(errno == EINTR) {
                err_msg("interrupt");
                string_delete(str);
                return FALSE;
            }
            perror("read");
            goto vd_end;
        }
        if(r == 0) {
            break;
        }
        if(gSaphireSigInt) {            // CTRL-C줿
            err_msg("ctrl-c pressed. interrupt.");
            string_delete(str);
            return FALSE;
        }

        buf[r] = 0;
        string_push_back(str, buf);
    }
    
    char* p = string_c_str(str);

    string_obj* str2 = STRING_NEW("");
    while(*p) {
        if(*p == '\n') {
            p++;
            if(strcmp(string_c_str(str2), "") != 0) {
                filer_vd_add(adir(), string_c_str(str2));
            }
            string_delete(str2);
            str2 = STRING_NEW("");
        }
        else {
            string_push_back2(str2, *p++);
        }

        if(gSaphireSigInt) {
            err_msg("interrupt");
            string_delete(str2);
            string_delete(str);
            return FALSE;
        }
    }

    if(strcmp(string_c_str(str2), "") != 0) {
        filer_vd_add(adir(), string_c_str(str2));
    }

    string_delete(str2);

    string_delete(str);

vd_end:

    return TRUE;
}

BOOL commands_mrename(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    int l;
    BOOL reread = FALSE;
    BOOL cursor_move = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        if(strcmp(arg, "-r") == 0) {
            reread = TRUE;

            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        else if(strcmp(arg, "-c") == 0) {
            cursor_move = TRUE;

            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 3) {
        char* source = string_c_str(vector_item(argv, 1));
        char* distination = string_c_str(vector_item(argv, 2));

        if(access(source, F_OK) != 0) {
            if(mis_raw_mode()) {
                err_msg("%s does not exist.", source);
            }
            else {
                fprintf(stderr, "%s does not exist.", source);
            }
            return FALSE;
        }

        if(access(distination, F_OK) == 0) {
            if(mis_raw_mode()) {
                err_msg("%s exists. can't rename", distination);
            }
            else {
                fprintf(stderr, "%s exists. can't rename", distination);
            }
            return FALSE;
        }

        if(rename(source, distination) < 0) {
            if(mis_raw_mode()) {
                err_msg("rename error");
            }
            else {
                fprintf(stderr, "rename error");
            }
            return FALSE;
        }

        if(reread) {
            filer_reread(adir());
        }
        
        if(cursor_move) {
            int n = filer_file2(adir(), distination);
            filer_cursor_move(adir(), n);
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_row(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[BUFSIZ];
    sprintf(buf, "%d", filer_row(adir()));
    if(write(nextout, buf, strlen(buf)) < 0) {
        perror("write");
        exit(1);
    }
    *rcode = 0;

    return TRUE;
}

BOOL commands_row_max(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[BUFSIZ];
    sprintf(buf, "%d", filer_row_max(adir()));
    if(write(nextout, buf, strlen(buf)) < 0) {
        perror("write");
        exit(1);
    }
    *rcode = 0;

    return TRUE;
}

BOOL commands_line(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[BUFSIZ];
    sprintf(buf, "%d", filer_line(adir()));
    if(write(nextout, buf, strlen(buf)) < 0) {
        perror("write");
        exit(1);
    }

    *rcode = 0;

    return TRUE;
}

BOOL commands_line_max(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[BUFSIZ];
    sprintf(buf, "%d", filer_line_max(adir()));
    if(write(nextout, buf, strlen(buf)) < 0) {
        perror("write");
        exit(1);
    }

    *rcode = 0;

    return TRUE;
}

//// ü椬 ///
static int gProgressMark = 0;

static void draw_progress_box(int mark_num)
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    const int y = maxy/2;
    
    mbox(y, (maxx-22)/2, 22, 3);
    mmvprintw(y, (maxx-22)/2+2, "progress");
    mmvprintw(y+1, (maxx-22)/2+1, "(%d/%d) files", gProgressMark, mark_num);
}

BOOL commands_mcp(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    if(vector_size(argv) == 2) {
        gCopyOverride = kNone;
        gWriteProtected = kWPNone;

        /// å ///
        char distination[PATH_MAX];
        strcpy(distination, string_c_str(vector_item(argv, 1)));

        /// оݤǥ쥯ȥ꤫å ///
        if(distination[strlen(distination)-1] != '/')
        {
            strcat(distination, "/");
        }

        /// ǥ쥯ȥ̵꤬ʤ ///
        if(access(distination, F_OK) != 0) {
            char* str[] = {
                "yes", "no"
            };

            char buf[BUFSIZ];
            sprintf(buf, "%s doesn't exist. create?", distination);

            if(select_str(buf, str, 2, 1) == 0) {
                sprintf(buf, "mkdir -p %s", distination);
                system(buf);
            }
            else {
                err_msg("mcp: destination err(%s)", distination);
                return FALSE;
            }
        }

        /// ɸǥ쥯ȥ꤬ǥ쥯ȥꤸʤʤ饨顼 ///
        struct stat dstat;
        if(stat(distination, &dstat) < 0 || !S_ISDIR(dstat.st_mode)) {
            err_msg("mcp: distination is not directory");
            return FALSE;
        }

        /// go ///
        vector_obj* markfiles = filer_mark_files(adir());
        const int mark_file_num = vector_size(markfiles);
        gProgressMark = mark_file_num;

        sDir* dir = filer_dir(adir());
        int j;
        for(j=0; j<mark_file_num; j++) {
            sFile* file = vector_item(markfiles, j);
            char* fname = string_c_str(file->mName);
            char source[PATH_MAX];

            strcpy(source, string_c_str(dir->mPath));
            strcat(source, fname);
            
            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                int num;
                if((num = filer_file2(adir(), fname)) < 0) 
                {
                    err_msg("%s doesn't exist", fname);
                    break;
                }
                else
                {
                    filer_cursor_move(adir(), num);

                    view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                    //draw_progress_box(mark_file_num);
                    mrefresh();
                    
                    if(!file_copy(source, distination, false, false)) 
                    {
                        break;
                    }

                    gProgressMark--;
                    
                    filer_set_mark(adir(), num, FALSE);
                }
            }
        }

        vector_delete(markfiles);
        
        /*
        mclear();
        view();
        mrefresh();
        */

        dir = filer_dir(0);
        if(strcmp(distination, string_c_str(dir->mPath)) == 0) {
            filer_reread(0);
        }

        dir = filer_dir(1);
        if(strcmp(distination, string_c_str(dir->mPath)) == 0) {
            filer_reread(1);
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_mbackup(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    if(vector_size(argv) == 2) {
        gCopyOverride = kNone;
        gWriteProtected = kWPNone;

        sDir* dir = filer_dir(adir());

        /// å ///
        char distination[PATH_MAX];
        strcpy(distination, string_c_str(dir->mPath));
        strcat(distination, string_c_str(vector_item(argv, 1)));

        /// оݤ뤫ɤå ///
        if(access(distination, F_OK) == 0) {
            err_msg("distination exists");
            return FALSE;
        }

        /// go //
        sFile* file = filer_cursor_file(adir());
        
        char* fname = string_c_str(file->mName);
        char source[PATH_MAX];

        strcpy(source, string_c_str(dir->mPath));
        strcat(source, fname);
            
        if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
            int num;
            if((num = filer_file2(adir(), fname)) < 0) 
            {
                err_msg("%s doesn't exist", fname);
                return FALSE;
            }
            else
            {
                filer_cursor_move(adir(), num);

                view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                //draw_progress_box(mark_file_num);
                mrefresh();
                
                if(!file_copy(source, distination, false, false)) {
                    return FALSE;
                }

                filer_set_mark(adir(), num, FALSE);
            }
        }
        
        filer_reread(adir());

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_mmv(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }


    BOOL force = FALSE;
    int j=0;
    for(j=1; j<vector_size(argv); j++) {
        char* item = string_c_str(vector_item(argv, j));

        if(strcmp(item, "-f") == 0) {
            force = TRUE;
            string_delete(vector_item(argv, j));
            vector_erase(argv, j);
            j--;
            continue;
        }
    }

    if(vector_size(argv) == 2) {
        if(force) {
            gCopyOverride = kYesAll;
        }
        else {
            gCopyOverride = kNone;
        }

        gWriteProtected = kWPNone;

        /// å ///
        char distination[PATH_MAX];
        strcpy(distination, string_c_str(vector_item(argv, 1)));

        /// оݤǥ쥯ȥ ///
        if(distination[strlen(distination)-1] != '/') {
            strcat(distination, "/");
        }

        /// ǥ쥯ȥ̵꤬ʤ ///
        if(access(distination, F_OK) != 0)
        {
            char* str[] = {
                "yes", "no"
            };

            char buf[BUFSIZ];
            sprintf(buf, "%s doesn't exist. create?", distination);

            if(select_str(buf, str, 2, 1) == 0) {
                sprintf(buf, "mkdir -p %s", distination);
                system(buf);
            }
            else {
                err_msg("mmv: destination err(%s)", distination);
                return FALSE;
            }
        }

        /// ɸե뤬ǥ쥯ȥ꤫ɤå ///
        struct stat dstat;
        if(stat(distination, &dstat) < 0 || !S_ISDIR(dstat.st_mode)) {
            err_msg("mmv: distination is not directory");
            return FALSE;
        }

        /// go ///
        sDir* dir = filer_dir(adir());

        vector_obj* markfiles = filer_mark_files(adir());
        const int mark_file_num = vector_size(markfiles);
        gProgressMark = mark_file_num;

        int j;
        for(j=0; j<mark_file_num; j++) {
            sFile* file = vector_item(markfiles, j);
            char* fname = string_c_str(file->mName);
            char source[PATH_MAX];

            strcpy(source, string_c_str(dir->mPath));
            strcat(source, fname);

            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                int num;
                if((num = filer_file2(adir(), fname)) < 0) {
                    err_msg("%s doesn't exist", fname);
                    break;
                }
                else
                {
                    filer_cursor_move(adir(), num);

                    view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                    //draw_progress_box(mark_file_num);
                    mrefresh();
                    
                    if(!file_copy(source, distination, true, false)) {
                        break;
                    }

                    gProgressMark--;
                    
                    filer_set_mark(adir(), num, FALSE);
                }
            }
        }

        vector_delete(markfiles);
        
        /*
        mclear();
        view();
        mrefresh();
        */

        filer_reread(0);
        filer_reread(1);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_mrm(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }
                
    if(vector_size(argv) == 1) {
        gCopyOverride = kNone;
        gWriteProtected = kWPNone;

        /// go ///
        vector_obj* markfiles = filer_mark_files(adir());
        const int mark_file_num = vector_size(markfiles);
        gProgressMark = mark_file_num;

        int j;
        for(j=0; j<mark_file_num; j++) {
            sFile* file = vector_item(markfiles, j);
            char* item = string_c_str(file->mName);

            if(strcmp(item, ".") != 0 && strcmp(item, "..") != 0) {
                char source[PATH_MAX];

                sDir* dir = filer_dir(adir());
                strcpy(source, string_c_str(dir->mPath));
                strcat(source, item);

                int num;
                if((num = filer_file2(adir(), item)) < 0) {
                    err_msg("%s doesn't exist", item);
                    break;
                }
                else {
                    filer_cursor_move(adir(), num);

                    view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                    //draw_progress_box(mark_file_num);
                    mrefresh();
                    
                    if(!file_remove(source, false, true)) {
                        break;
                    }

                    gProgressMark--;
                    
                    filer_set_mark(adir(), num, FALSE);
                }
            }
        }
        
        /*
        mclear();
        view();
        mrefresh();
        */

        filer_reread(0);
        filer_reread(1);

        *rcode = 0;

        vector_delete(markfiles);
    }

    return TRUE;
}

BOOL commands_mtrashbox(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    BOOL force = FALSE;
    int j=0;
    for(j=1; j<vector_size(argv); j++) {
        char* item = string_c_str(vector_item(argv, j));

        if(strcmp(item, "-f") == 0) {
            force = TRUE;
            string_delete(vector_item(argv, j));
            vector_erase(argv, j);
            j--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(force) {
            gCopyOverride = kYesAll;
        }
        else {
            gCopyOverride = kNone;
        }

        gWriteProtected = kWPNone;

        /// å ///
        char distination[PATH_MAX];

        char* env = getenv("TRASHBOX_DIR");
        if(env) {
            strcpy(distination, env);
        }
        else {
            strcpy(distination, getenv("MF3HOME"));
            strcat(distination, "/trashbox/");
        }

        if(distination[strlen(distination)-1] != '/') {
            strcat(distination, "/");
        }

        /// ǥ쥯ȥ̵꤬ʤ ///
        if(access(distination, F_OK) != 0)
        {
            char* str[] = {
                "yes", "no"
            };

            char buf[BUFSIZ];
            sprintf(buf, "%s doesn't exist. create?", distination);

            if(select_str(buf, str, 2, 1) == 0) {
                sprintf(buf, "mkdir -p %s", distination);
                system(buf);
            }
            else {
                err_msg("mmv: destination err(%s)", distination);
                return FALSE;
            }
        }

        /// ɸե뤬ǥ쥯ȥ꤫ɤå ///
        struct stat dstat;
        if(stat(distination, &dstat) < 0 || !S_ISDIR(dstat.st_mode)) {
            err_msg("mmv: distination is not directory");
            return FALSE;
        }

        /// go ///
        sDir* dir = filer_dir(adir());

        vector_obj* markfiles = filer_mark_files(adir());
        const int mark_file_num = vector_size(markfiles);
        gProgressMark = mark_file_num;

        int j;
        for(j=0; j<mark_file_num; j++) {
            sFile* file = vector_item(markfiles, j);
            char* fname = string_c_str(file->mName);
            char source[PATH_MAX];

            strcpy(source, string_c_str(dir->mPath));
            strcat(source, fname);

            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                int num;
                if((num = filer_file2(adir(), fname)) < 0) {
                    err_msg("%s doesn't exist", fname);
                    break;
                }
                else
                {
                    filer_cursor_move(adir(), num);

                    view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                    //draw_progress_box(mark_file_num);
                    mrefresh();
                    
                    if(!file_copy(source, distination, true, false)) {
                        break;
                    }

                    gProgressMark--;
                    
                    filer_set_mark(adir(), num, FALSE);
                }
            }
        }

        vector_delete(markfiles);
        
        /*
        mclear();
        view();
        mrefresh();
        */

        filer_reread(0);
        filer_reread(1);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_mln(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    if(vector_size(argv) == 2) {
        /// å ///
        char distination[PATH_MAX];
        strcpy(distination, string_c_str(vector_item(argv, 1)));

        if(distination[strlen(distination)-1] != '/') {
            strcat(distination, "/");
        }

        /// ǥ쥯ȥ̵꤬ʤ ///
        if(access(distination, F_OK) != 0) {
            char* str[] = {
                "yes", "no"
            };

            char buf[BUFSIZ];
            sprintf(buf, "%s doesn't exist. create?", distination);

            if(select_str(buf, str, 2, 1) == 0) {
                sprintf(buf, "mkdir -p %s", distination);
                system(buf);
            }
            else {
                err_msg("mcp: destination err(%s)", distination);
                return FALSE;
            }
        }

        /// ɸǥ쥯ȥ꤬ǥ쥯ȥꤸʤʤ饨顼 ///
        struct stat dstat;
        if(stat(distination, &dstat) < 0 || !S_ISDIR(dstat.st_mode)) {
            err_msg("mcp: distination is not directory");
            return FALSE;
        }

        /// go ///
        vector_obj* markfiles = filer_mark_files(adir());
        const int mark_file_num = vector_size(markfiles);
        gProgressMark = mark_file_num;

        sDir* dir = filer_dir(adir());
        int j;
        for(j=0; j<mark_file_num; j++) {
            sFile* file = vector_item(markfiles, j);
            char* fname = string_c_str(file->mName);
            char source[PATH_MAX];

            strcpy(source, string_c_str(dir->mPath));
            strcat(source, fname);

            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                int num;
                if((num = filer_file2(adir(), fname)) < 0) 
                {
                    err_msg("%s doesn't exist", fname);
                    break;
                }
                else
                {
                    filer_cursor_move(adir(), num);

                    view(FALSE); // ϥԡξ񤭳ǧΤȤ֤˥뤬ɬפäꡢ̤ʤɤ̤ƤɬפΤɬ
                    //draw_progress_box(mark_file_num);
                    mrefresh();

                    char dfile[PATH_MAX];
                    strcpy(dfile, distination);
                    strcat(dfile, fname);

                    if(symlink(source, dfile) < 0) {
                        err_msg("can't make symlink(%s). Is it attempt to make on vfat?", dfile);
                        break;
                    }

                    gProgressMark--;
                    
                    filer_set_mark(adir(), num, FALSE);
                }
            }
        }

        vector_delete(markfiles);
        
        /*
        mclear();
        view();
        mrefresh();
        */

        dir = filer_dir(0);
        if(strcmp(distination, string_c_str(dir->mPath)) == 0) {
            filer_reread(0);
        }

        dir = filer_dir(1);
        if(strcmp(distination, string_c_str(dir->mPath)) == 0) {
            filer_reread(1);
        }
    }

    *rcode = 0;

    return TRUE;
}

BOOL commands_mclear_immediately(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    mclear_immediately();
    *rcode = 0;

    return TRUE;
}

BOOL commands_mchoise(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    if(!mis_raw_mode()) {
        err_msg("invalid terminal setting. not raw mode");
        return FALSE;
    }

    if(vector_size(argv) >= 3) {
        char* msg = string_c_str(vector_item(argv, 1));
        char** str = MALLOC(sizeof(char*)*vector_size(argv));

        int j;
        for(j=2; j<vector_size(argv); j++) {
            str[j-2] = string_c_str(vector_item(argv, j));
        }

        char* smsg = choise(msg, str, vector_size(argv) -2, -1);
        char buf[BUFSIZ];
        if(smsg == NULL) {
            sprintf(buf, "cancel");
        }
        else {
            sprintf(buf, "%s", smsg);
        }

        write(nextout, buf, strlen(buf));

        FREE(str);

        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_adir(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[256];
    sprintf(buf, "%d", adir());
    write(nextout, buf, strlen(buf));

    *rcode = 0;

    return TRUE;
}

BOOL commands_sdir(int* rcode, vector_obj* argv, int nextout, int nextin, int nexterr, char* title, BOOL input)
{
    char buf[256];
    sprintf(buf, "%d", sdir());
    write(nextout, buf, strlen(buf));

    *rcode = 0;

    return TRUE;
}

void commands_init()
{
    kitutuki_add_inner_command("quit", commands_quit);
    kitutuki_add_inner_command("keycommand", commands_keycommand);
    kitutuki_add_inner_command("keymap", commands_keymap);
    kitutuki_add_inner_command("cursor_move", commands_cursor_move);
    kitutuki_add_inner_command("mcd", commands_mcd);
    kitutuki_add_inner_command("cmdline", commands_cmdline);
    kitutuki_add_inner_command("file_num", commands_file_num);
    kitutuki_add_inner_command("file_perm", commands_file_perm);
    kitutuki_add_inner_command("file_group", commands_file_group);
    kitutuki_add_inner_command("file_user", commands_file_user);
    kitutuki_add_inner_command("file_index", commands_file_index);
    kitutuki_add_inner_command("file_ext", commands_file_ext);
    kitutuki_add_inner_command("file_name", commands_file_name);
    kitutuki_add_inner_command("path", commands_path);
    kitutuki_add_inner_command("cursor_num", commands_cursor_num);
    kitutuki_add_inner_command("external", commands_external);
    kitutuki_add_inner_command("isearch", commands_isearch);
    kitutuki_add_inner_command("mchoise", commands_mchoise);
    kitutuki_add_inner_command("activate", commands_activate);
    kitutuki_add_inner_command("defmenu", commands_defmenu);
    kitutuki_add_inner_command("addmenu", commands_addmenu);
    kitutuki_add_inner_command("menu", commands_menu);
    kitutuki_add_inner_command("reread", commands_reread);
    kitutuki_add_inner_command("markfiles", commands_markfiles);
    kitutuki_add_inner_command("allfiles", commands_allfiles);
    kitutuki_add_inner_command("mark", commands_mark);
    kitutuki_add_inner_command("marking", commands_marking);
    kitutuki_add_inner_command("mclear_immediately", commands_mclear_immediately);
    kitutuki_add_inner_command("vd", commands_vd);
    kitutuki_add_inner_command("mcp", commands_mcp);
    kitutuki_add_inner_command("mrm", commands_mrm);
    kitutuki_add_inner_command("mmv", commands_mmv);
    kitutuki_add_inner_command("mtrashbox", commands_mtrashbox);
    kitutuki_add_inner_command("mln", commands_mln);
    kitutuki_add_inner_command("mrename", commands_mrename);
    kitutuki_add_inner_command("mask", commands_mask);
    kitutuki_add_inner_command("dir_num", commands_dir_num);
    kitutuki_add_inner_command("del_dir", commands_del_dir);
    kitutuki_add_inner_command("new_dir", commands_new_dir);
    kitutuki_add_inner_command("mbackup", commands_mbackup);

    kitutuki_add_inner_command("row", commands_row);
    kitutuki_add_inner_command("row_max", commands_row_max);
    kitutuki_add_inner_command("line", commands_line);
    kitutuki_add_inner_command("line_max", commands_line_max);
    kitutuki_add_inner_command("adir", commands_adir);
    kitutuki_add_inner_command("sdir", commands_sdir);
}

void commands_final()
{
}
