#! /usr/bin/ruby

require "observer"

class Sensor
  include Observable
   def simulation
    temperatur=11
     loop do
      temperatur+=rand(2)-0.5
       print"Temperatur:#{temperatur}\n"
        changed
       notify_observers(temperatur)
      end
   end
end

class Stuff
 def initialize(sensor, limit)
  @heating=false
  @limit=limit
  sensor.add_observer(self)
 end
end

class Heating<Stuff
 def update(temperatur)
  if(temperatur<@limit) and (!@heating)
   puts"Observer module information: Heating is on!"
    @heating=true
  elsif(temperatur>=@limit) and (@heating)
   puts"Observer module information: Now it is off!"
    @heating=false
  end
 end
end

class Alarm<Stuff
 def update(temperatur)
  puts"ALARM!! ALARM!! ALARM!! ALARM!! ALARM!!  " if temperatur < @limit
 end
end

sensor=Sensor.new
Heating.new(sensor, 10)
Alarm.new(sensor, 5)
sim=Thread.new{sensor.simulation()}

sleep 2 
 
     