#!/usr/bin/ruby

# ScrollBar component for Ming 0.3.
# Version 0.2 for Ruby.
# based upon Pipey's code and SWFTools scrollbar code
# exports 2 methods: new_movie and scrollbar, but also
# exports global variable $movie, so you can add your own stuff to the timeline
# Author Pawel Karwowski pawel at baribal dot forall dot pl

require 'ming/ming'
include Ming

class SWFComponents

def new_movie(version, hoz, ver)

set_scale(20.0000000)
use_SWF_version(version)

$movie = SWFMovie.new
$movie.set_background(0xff, 0xff, 0xff)
$movie.set_dimension(hoz, ver)
end

def scrollbar(a, b, c, d)

arrow_up_inactive = SWFShape.new
dbl1 = SWFBitmap.new("pictures/arrow_up_inactive.dbl")
arrow_up_inactive.set_right_fill(arrow_up_inactive.add_fill(dbl1, SWFFill::CLIPPED_BITMAP))
   arrow_up_inactive.draw_line(dbl1.get_width, 0)
   arrow_up_inactive.draw_line(0, dbl1.get_height)
   arrow_up_inactive.draw_line(-dbl1.get_width, 0)
   arrow_up_inactive.draw_line(0, -dbl1.get_height)

arrow_up_active = SWFShape.new
dbl2 = SWFBitmap.new("pictures/arrow_up_active.dbl");
arrow_up_active.set_right_fill(arrow_up_active.add_fill(dbl2, SWFFill::CLIPPED_BITMAP))
   arrow_up_active.draw_line(dbl2.get_width, 0)
   arrow_up_active.draw_line(0, dbl2.get_height)
   arrow_up_active.draw_line(-dbl2.get_width, 0)
   arrow_up_active.draw_line(0, -dbl2.get_height)

arrow_down_inactive = SWFShape.new
dbl3 = SWFBitmap.new("pictures/arrow_down_inactive.dbl");
arrow_down_inactive.set_right_fill(arrow_down_inactive.add_fill(dbl3, SWFFill::CLIPPED_BITMAP))
   arrow_down_inactive.draw_line(dbl3.get_width, 0);
   arrow_down_inactive.draw_line(0, dbl3.get_height);
   arrow_down_inactive.draw_line(-dbl3.get_width, 0);
   arrow_down_inactive.draw_line(0, -dbl3.get_height);

arrow_down_active = SWFShape.new
dbl4 = SWFBitmap.new("pictures/arrow_down_active.dbl")
arrow_down_active.set_right_fill(arrow_down_active.add_fill(dbl4, SWFFill::CLIPPED_BITMAP))
   arrow_down_active.draw_line(dbl4.get_width, 0)
   arrow_down_active.draw_line(0, dbl4.get_height)
   arrow_down_active.draw_line(-dbl4.get_width, 0)
   arrow_down_active.draw_line(0, -dbl4.get_height)

scrollbar_inactive = SWFShape.new
dbl5 = SWFBitmap.new("pictures/scrollbar_inactive.dbl")
scrollbar_inactive.set_right_fill(scrollbar_inactive.add_fill(dbl5, SWFFill::CLIPPED_BITMAP))
   scrollbar_inactive.draw_line(dbl5.get_width, 0)
   scrollbar_inactive.draw_line(0, dbl5.get_height)
   scrollbar_inactive.draw_line(-dbl5.get_width, 0)
   scrollbar_inactive.draw_line(0, -dbl5.get_height)

scrollbar_active = SWFShape.new
dbl6 = SWFBitmap.new("pictures/scrollbar_active.dbl")
scrollbar_active.set_right_fill(scrollbar_active.add_fill(dbl6, SWFFill::CLIPPED_BITMAP))
   scrollbar_active.draw_line(dbl6.get_width, 0)
   scrollbar_active.draw_line(0, dbl6.get_height)
   scrollbar_active.draw_line(-dbl6.get_width, 0)
   scrollbar_active.draw_line(0, -dbl6.get_height)

backgroundV = SWFShape.new
dbl8 = SWFBitmap.new("pictures/backgroundV.dbl")
backgroundV.set_right_fill(backgroundV.add_fill(dbl8, SWFFill::CLIPPED_BITMAP))
   backgroundV.draw_line(dbl8.get_width, 0)
   backgroundV.draw_line(0, dbl8.get_height)
   backgroundV.draw_line(-dbl8.get_width, 0)
   backgroundV.draw_line(0, -dbl8.get_height)

ib = $movie.add(backgroundV)
  ib.set_name("BackgroundV")
  ib.scale_to(1,0.0625*d)
  ib.move_to(a+c+2,b)

backgroundH_gap = SWFShape.new
dbl9 = SWFBitmap.new("pictures/backgroundH_gap.dbl")
backgroundH_gap.set_right_fill(backgroundH_gap.add_fill(dbl9, SWFFill::CLIPPED_BITMAP))
   backgroundH_gap.draw_line(dbl9.get_width, 0)
   backgroundH_gap.draw_line(0, dbl9.get_height)
   backgroundH_gap.draw_line(-dbl9.get_width, 0)
   backgroundH_gap.draw_line(0, -dbl9.get_height)

ic = $movie.add(backgroundH_gap)
  ic.set_name("BackgroundH_gap")
  ic.move_to(a+c+2,b)

backgroundV_gap = SWFShape.new()
dbl10 = SWFBitmap.new("pictures/backgroundV_gap.dbl")
backgroundV_gap.set_right_fill(backgroundV_gap.add_fill(dbl10, SWFFill::CLIPPED_BITMAP))
   backgroundV_gap.draw_line(dbl10.get_width, 0)
   backgroundV_gap.draw_line(0, dbl10.get_height)
   backgroundV_gap.draw_line(-dbl10.get_width, 0)
   backgroundV_gap.draw_line(0, -dbl10.get_height)

id = $movie.add(backgroundV_gap)
  id.set_name("BackgroundV_gap")
  id.move_to(a+c+2,b)

backgroundH_gap2 = SWFShape.new
dbl11 = SWFBitmap.new("pictures/backgroundH_gap2.dbl")
backgroundH_gap2.set_right_fill(backgroundH_gap2.add_fill(dbl11, SWFFill::CLIPPED_BITMAP))
   backgroundH_gap2.draw_line(dbl10.get_width, 0)
   backgroundH_gap2.draw_line(0, dbl10.get_height)
   backgroundH_gap2.draw_line(-dbl10.get_width, 0)
   backgroundH_gap2.draw_line(0, -dbl10.get_height)

ie = $movie.add(backgroundH_gap2)
  ie.set_name("BackgroundH_gap2")
  ie.move_to(a+c+2,b)

backgroundV_gap2 = SWFShape.new
dbl12 = SWFBitmap.new("pictures/backgroundV_gap2.dbl")
backgroundV_gap2.set_right_fill(backgroundV_gap2.add_fill(dbl12, SWFFill::CLIPPED_BITMAP))
   backgroundV_gap2.draw_line(dbl12.get_width, 0)
   backgroundV_gap2.draw_line(0, dbl12.get_height)
   backgroundV_gap2.draw_line(-dbl12.get_width, 0)
   backgroundV_gap2.draw_line(0, -dbl12.get_height)

ikf = $movie.add(backgroundV_gap2)
  ikf.set_name("BackgroundV_gap2")
  ikf.move_to(a+c+2,b)

dragbutton = SWFMovieClip.new
but = SWFButton.new
  but.add_shape(scrollbar_inactive, SWFButton::HIT | SWFButton::UP | SWFButton::OVER)
  but.add_shape(scrollbar_active, SWFButton::HIT | SWFButton::DOWN)
  but.add_action(SWFAction.new("
  		DragButton._x = a+c+3;
		Dragging = true;
		startDrag(DragButton, true, _parent.UpButton._y + 16, a+c+3, _parent.DownButton._y - 17 , a+c+3 );
		Dragging = true;
		idInt_Drag = setInterval(_parent.Revalue, 5);"), SWFButton::MOUSE_DOWN)
  but.add_action(SWFAction.new("  
  		Dragging = false;
		clearInterval(idInt_Drag);
		stopDrag();	
		_parent.Revalue();"), SWFButton::MOUSE_UP | SWFButton::MOUSE_UP_OUTSIDE  | SWFButton::DRAG_OUT | SWFButton::DRAG_OVER)
  dragbutton.add(but)
  dragbutton.next_frame

ir = $movie.add(dragbutton)
  ir.set_name("DragButton")
  ir.move_to(a+c+3,b+16)

upbutton = SWFButton.new
upbutton.add_shape(arrow_up_inactive, SWFButton::HIT | SWFButton::UP | SWFButton::OVER)
upbutton.add_shape(arrow_up_active, SWFButton::HIT | SWFButton::DOWN)
upbutton.add_action(SWFAction.new("
	Up_pressed();
	function Up_pressed() {
	if (Value > MinValue) {
	Value = Value - Increment;
	}
	if (Value < MinValue) {
	Value = MinValue;
	}
	Reposition();
	}
	idInt_Up_pressed = setInterval(Up_pressed, 100);"), SWFButton::MOUSE_DOWN)
upbutton.add_action(SWFAction.new("clearInterval(idInt_Up_pressed);"), SWFButton::MOUSE_UP | SWFButton::MOUSE_UP_OUTSIDE)

is=$movie.add(upbutton)
is.set_name("UpButton")
is.move_to(a+c+3,b)

downbutton = SWFButton.new
downbutton.add_shape(arrow_down_inactive, SWFButton::HIT | SWFButton::UP | SWFButton::OVER)
downbutton.add_shape(arrow_down_active, SWFButton::HIT | SWFButton::DOWN)
downbutton.add_action(SWFAction.new("
	Down_pressed();
	function Down_pressed() {
	if (Value < MaxValue) {
	Value = Value + Increment;
	}
	if (Value > MaxValue) {
	Value = MaxValue;
	}
	Reposition();
	}
	idInt_Down_pressed = setInterval(Down_pressed, 100);"), SWFButton::MOUSE_DOWN);
downbutton.add_action(SWFAction.new("clearInterval(idInt_Down_pressed);"), SWFButton::MOUSE_UP |SWFButton::DRAG_OUT | SWFButton::MOUSE_UP_OUTSIDE)

iw=$movie.add(downbutton);
iw.set_name("DownButton");
iw.move_to(a+c+3,b+d-15);

$movie.add(SWFAction.new("


ASSetPropFlags(class.prototype, null, 0, 1024);

function updateOutput() {
txf= TextField.StyleSheet;
  myStyleSheet = new txf();
  myStyleSheet.parseCSS(mycss);
  txtFld.styleSheet = myStyleSheet;
  txtFld.htmlText = str;
}

txtFld.scrollWheelEnabled = true;


myListener = new Object();
myListener.onScroller = function() {
  MaxValue = txtFld.maxscroll;
  MouseOverText();
}; 

txtFld.addListener(myListener);


txtFld.htmlText = str;
updateOutput();

MinValue =1;
Increment =1;
TextField = new Object(_root.txtFld);
MaxValue = txtFld.maxscroll;
Initialize();

function UpdateBar() {
	_parent.txtFld = TextField.scroll;
	Value = TextField.scroll;
	DragButton._y = ((Value-MinValue)/(MaxValue-MinValue)*(d-48));
	Reposition();
};

function MouseOverText() {
	if (TextField._ymouse > 0){
		if (TextField._ymouse < TextField._height) {
		if (TextField._xmouse < TextField._width) {
		if (TextField._xmouse > 0) {
		UpdateBar();
		}
		}
		}
	}
};
  
function Initialise() {
        DownButton._x = a+c+2;
	DownButton._y = d - 37;
	BackgroundV._yscale = (((d / 16))*100) + 1;
	BackgroundV_gap2._y = d - 1;
	Value = MinValue;
	Reposition();
};

function Reposition() {

	DragButton._y = ((Value-MinValue)/(MaxValue-MinValue)*(d-48))+b+16;
	TextField.scroll = Value;
};

function Revalue() {
	Value = (((DragButton._y-b-16)/(d-48))*(MaxValue-MinValue)) + MinValue;
	DragButton._x = a+c+3;
	Value = int(Value/Increment)*Increment;
	TextField.scroll = Value;
	if (dragging == 'false') {
	Reposition();
	}
};
	idmouseText = setInterval(MouseOverText, 300);

"))
 end
end
