/**
 * # CHAPTER #
 * ============================================================================
 * xtclassifyѤڴϢإå
 * ============================================================================
 */

#ifndef _TREE_H
#define _TREE_H

#include <condition.h>
#include <classTable.h>

/**
 * # STRUCT #
 *ĥ꡼ΥΡɹ¤
 */
struct Node {
  int            nodeType;  /*0:Leaf, 1:Node*/
  int            pruned;    /*0:not, 1:pruned leaf*/
  struct Node   *parent;    /*nodeؤΥݥ*/
  struct Node   *uNode;     /*unmatch nodeؤΥݥ*/
  struct Node   *mNode;     /*match nodeؤΥݥ*/
  struct CndCnt  trnCnt;    /*match,unmatch*/
  int            attType;   /*nodeǻȤä°(pat:0 num:1 cat:2)*/
  int            attFldNo;  /*nodeǻȤä°ιֹ(줾0)*/
  int            attPatNo;  /*nodeǻȤäpat°ֹ(줾°Ǥ)*/
                            /*嵭3Ĥ°ޤ*/
  double         numTH;     /*ͤξ*/
  char          *catList;   /*ƥ꡼ξΥƥ꡼ͥꥹ*/
  int            level;     /*ĥ꡼ο*/
  int            cls;       /*nodeˤClass*/
  int            mulCls;    /*Classʣ뤫ɤեå*/

  double         estErrNode;/*ΥΡɤΥ顼*/
  double         estErrLeaf;/*ΥΡɰʲΥ顼*/

  double         costNode;  /*ΥΡɤΥ*/
  double         costLeaf;  /*ΥΡɰʲΥ*/
};

/**
 * # STRUCT #
 *ĥ꡼Τι¤
 */
struct Tree {
  struct Node    *topNode;   /*ĥ꡼ΥȥåץΡ*/
  struct Data    *dat;       /*ڤΥǡ(¥ǡʳ)*/
  struct ClsTbl  *trnRsl;    /*ȥ졼˥󥰥ǡˤ*/
  struct ClsTbl  *tstRsl;    /*ƥȥǡˤ*/
  int             leafCnt;   /*Leafο*/
  int             deepest;   /*ǿ٥*/
};

/**
 * # PROTOTYPE #
 */
struct Tree *decisionTree(struct Data *trn,struct Data *tst,struct Cost *cost);
struct Tree *updateTree( struct Tree *tree, struct Tree *betterTree);
void showTree(struct Tree *tree,struct Cost *cost, struct mssFPW *fpw);
void showTreePMML(struct Tree *tree,struct Cost *cost, struct mssFPW *fpw);
void freeTree(struct Tree *tree);
void showProgressTree(struct Data *dat, struct Tree *tree);

#endif
