/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤXMLtableǡϴϢδؿ
 * 20040123 mssReadFRKؿΥХ
 * ============================================================================
 */

#include <musashi/mssHeader.h>
#include <musashi/mssXtTag.h>
#include <musashi/mssInput.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <float.h>
#include <zlib.h>

#include <fnmatch.h>
#include <sys/time.h>

/*quick sortϢ*/
void qsort5(char *base, int nel, int size, int (*cmp));
unsigned int ass_cnt;

/**
 * # MACRO #
 * 󥰥ХåեˤơΥ塼(a)μΥ塼ֹ׻롣
 * bˤϥ塼οꤹ롣bϣ߾ǤʤФʤʤ
 */
#define NextQue(a,b) ((a+1)&(b-1))

/**
 * # MACRO #
 * 󥰥ХåեˤơΥ塼(a)Υ塼ֹ׻롣
 * bˤϥ塼οꤹ롣bϣ߾ǤʤФʤʤ
 */
#define PrevQue(a,b) ((a-1)&(b-1))

/* ############ Хѿ ##############*/
/*ե뤫ɤ߹ߤEOFȤʤäȤʼ*/
/*ΤǤϤʤɥ쥹ȤѤƤ롣*/
static char readEnd[2]={0xff,0};



/*ե̾*/
static char TFname[MssFileNameMaxLen];

extern struct mssGlobalVariables mssGV;

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ȴϢ
 * ----------------------------------------------------------------------------
 * 륳ޥɤxmlTableݤ˻˥Ȥ뤳Ȥɬפʻ
 * mssReopenFPRؿƤӽФǡ΢ǻưŪ¤ٴ뤳ȤǤ롣
 * κݤ΢Ǽ¹Ԥ륽ȴϢδؿstaticѿǡ饤֥Ѽ
 * ϤδؿռɬפϤʤ
 * mssReopenFPRؿƤӽФȡޤ˰ʲ˼褦ʽԤ롣
 * 1. ϥǡ򤢤ɤ߹
 * 2. ʬǡquickȤ
 * 3. ϥǡɤ߹ޤ1,2ν򷫤֤
 *    ̤ȤnĤΥȺѥե뤬夬롣
 * 4. nĤΥե򡢥ե"PWayS"İʲˤʤޤǥޡ롣
 *    ΥޡPWaySĤΥեޡ롣
 *    κݡȡʥȥĥ꡼ץ饤ƥ塼ȤѤ롣
 * 嵭νԤä塢桼ϡmssReadFldRecʤɤΥǡɤ߹ߴؿ
 * ǤȤռ̾եƱͤ˰ȤǤ褦ˤʤ롣
 *
 * ڥȡʥȥĥ꡼ιͤ
 * Algorithm by N.Katoh in Maui 2001/06/16-22
 *
 * ޤǤϡĤΥեޡ뤳ȤꤷƤ롣
 * 1. ꡼դˤϳƥեΥȹԤΥͤåȤ(a)
 *    ֤ǤϥΡɤˤͤϥåȤƤʤ
 * 2. ˡȡʥԤͥԤ(b)
 * 3. ͥԤΥǡ񤭽Ф
 * 4. ͥԤΥ꡼դ˼ιԤΥͤ򥻥åȤ(c)
 * 5. ˥åȤ줿꡼դΤߥȡʥԤͥԤ(d)
 * 6. ǡɤڤޤ3-5ν򷫤֤
 *
 *        ( )             (a)             (a)             (b)
 *     +---+---+       +---+---+       +---+---+       +---+---+
 *     |       |       |       |       |       |       |       |
 *    ( )     ( )     (a)     (b)     (a)     (b)     (e)     (b)
 *   +-+-+   +-+-+   +-+-+   +-+-+   +-+-+   +-+-+   +-+-+   +-+-+
 *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
 *   g   a   c   b   g   a   c   b   g  [e]  c   b   g   e   c   b
 *       [a]           [b]           [d]           [d]
 */

static int CmpRevNum;    /*Ȥˤ륭Ӥ*/
                         /* 0:ñƬʸӤǹԤ*/
                         /* 1:͡սθӤԤ*/
struct mssFields *SortFld; /*ȹܹ¤(initSDǥå)*/

/**
 * # FUNCTION #
 * ӥ롼
 * CmpRevNumOnλs1,s2(char **)˥㥹ȤѤƤ롣
 * s1ξ-1 s2ξ1֤ Ʊξ0֤
 * ȡʥȥĥ꡼ˤѤ롣
 */
static int cmpKeyStr(char *s1, char *s2)
{
  int i;
  int no; /*ֹ*/
  int cmp; /*strcmpη*/
  double n1,n2;

  if(!CmpRevNum){
    /*̾ξstrcmpη̤餱ʤ*/
    /*s1<s2 -> -1 , s1>s2 -> 1, s1==s2 -> 0*/
    return(strcmp(s1,s2));
  }else{
    if(s1==readEnd) return(1);  /*s1λʤs2ξ*/
    if(s2==readEnd) return(-1); /*s2λʤs1ξ*/
    for(i=0; i<SortFld->cnt; i++){
      no=MssFlds2num(SortFld,i);
      if(MssFlds2numFlg(SortFld,i)){
        if(MssIsNull(*((char **)s1+no))) n1=-DBL_MAX;
        else                         n1=atof(*((char **)s1+no));
        if(MssIsNull(*((char **)s2+no))) n2=-DBL_MAX;
        else                         n2=atof(*((char **)s2+no));

        if(n1 > n2){
          /*礭λ n1>n2 -> n1ξ*/
          if(MssFlds2revFlg(SortFld,i)) return(-1);
          /*;λ n1>n2 -> n2ξ*/
          else                          return(1);
        }else if(n1 < n2){
          /*礭λ n1<n2 -> n2ξ*/
          if(MssFlds2revFlg(SortFld,i)) return(1);
          /*;λ n1<n2 -> n1ξ*/
          else                           return(-1);
        }
      }else{
        /*ʸξstrcmpη̤餱ʤ*/
        if(0 != (cmp=strcmp( *((char **)s1+no),*((char **)s2+no))) ){
          if(MssFlds2revFlg(SortFld,i)) return(cmp*(-1));
          else                          return(cmp);
        }
      }
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * ӥ롼(quickȴؿ)
 * CmpRevNumOnλs1,s2(char **)˥㥹ȤѤƤ롣
 * s1ξ-1 s2ξ1֤ Ʊξ0֤
 */
static int cmpKeyQst(const void **s1,const void **s2)
{
  register int i,no,cmp;
  double n1,n2;

  if(!CmpRevNum){
    return (strcmp( *s1,*s2));
  }else{
    for(i=0; i<SortFld->cnt; i++){
      no=MssFlds2num(SortFld,i);
      if(MssFlds2numFlg(SortFld,i)){
        if(MssIsNull(*((char **)s1+no))) n1=-DBL_MAX;
        else                         n1=atof(*((char **)s1+no));
        if(MssIsNull(*((char **)s2+no))) n2=-DBL_MAX;
        else                         n2=atof(*((char **)s2+no));
        if(n1 > n2){
          /*礭λ n1>n2 -> n1ξ*/
          if(MssFlds2revFlg(SortFld,i)) return(-1);

          /*;λ n1>n2 -> n2ξ*/
          else                    return(1);
        }else if(n1 < n2){
          /*礭λ n1<n2 -> n2ξ*/
          if(MssFlds2revFlg(SortFld,i)) return(1);
          /*;λ n1<n2 -> n1ξ*/
          else                    return(-1);
        }
      }else{
        /*ʸξstrcmpη̤餱ʤ*/
        if(0 != (cmp=strcmp( *((char **)s1+no),*((char **)s2+no))) ){
          if(MssFlds2revFlg(SortFld,i)) return(cmp*(-1));
          else                    return(cmp);
        }
      }
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * ȡʥȥĥ꡼(ҡ)ν
 * ȡʥȥĥ꡼(ʲTT)γƥΡɤTTnode¤Ρ
 * ꡼դβޤcntͿTTΥȥåץΡɤ֤
 * TTι¤ϰʲ̤ꡣ
 *
 *                   a(1)
 *           +-------+--------+     
 *           |                |     
 *           a(2)             k(3)  
 *     +-----+------+     +---+--+   
 *     |            |     |      |   
 *     a(4)         b(5)  z(6)   k(7)
 *   +--+--+     +--+--+
 *   |     |     |     |
 *   d(8)  a(9)  c(10) b(11)
 * ƻҷδط
 * ֹܿͤ = n Ȥ
 *   Ƥֹ   = int(n/2)  ex) 5ο=int(5/2)=2 8ο=int(8/2)=4
 *   ֹ = ⤷nʤ n+1 ʤ n-1
 * ȡʥȤϥ꡼դӤƤΤǡҤƤ򤿤ɤ뤳ȤȤʤ롣
 * äƿƤ鸫ҤɤֹΤäƤɬѤϤʤ
 */
static struct TTnode *TTinit(int cnt)
{
  int i;

  struct TTnode *top; /*ĥ꡼ΥȥåפȤʤ륢ɥ쥹*/

  /*ΡɤȥΥ*/
  top     =mssMalloc(sizeof(struct TTnode)*(2*cnt),"ttInitNode");
  top->key=mssMalloc(sizeof(struct TTkey) *(2*cnt),"ttInitKey");

  /*ȥåץΡ*/
  (top+1)->parent   = NULL;
  (top+1)->brother  = NULL; 
  (top+1)->num      = 1;
  (top+1)->key      = top->key+1;
  (top+1)->key->str = NULL;
  (top+1)->key->bkt = 0;

  for(i=2; i<=2*cnt-1; i++){
    /*--------*/
    (top+i)->num      = i;
    (top+i)->key      = top->key+i;
    (top+i)->key->str = NULL;
    (top+i)->key->bkt = 0;

    /*--------ƥΡ*/
    (top+i)->parent = top+i/2;

    /*--------Ρ*/
    if(i==i/2*2){ /**/
      (top+i)->brother=top+i+1; 
    }else{        /**/
      (top+i)->brother=top+i-1; 
    }
  }

  return(top);
}

/**
 * # FUNCTION #
 * TTnode¤ΤΥΰ賫*
 * TTĥ꡼ΥȥåפȤʤ륢ɥ쥹Ϳ
 */
static void TTfree(struct TTnode *top)
{
  mssFree(top->key);
  mssFree(top);
}

/**
 * # FUNCTION #
 *ȡʥȥĥ꡼Υ꡼դ˥ǡ򥻥åȤ롣
 *  ݥԤǡǡμΤ̤ξˤ뤳Ȥ
 */
static void TTsetLeaf(
  struct TTkey  *key, /*åȤʸʤɤξ*/
  struct TTnode *node,/*ȥåץΡ*/
  int num){           /*ĥ꡼ΤǲܤΥΡɤ˥åȤ뤫*/

  (node+num)->key->bkt=key->bkt;
  (node+num)->key->str=key->str;
}

/**
 * # FUNCTION #
 *ȡʥȥĥ꡼˿ǡ
 *  insertȤ뤬ºݤˤϴ¸Τ꡼(num)˿ǡ򥻥åȤ
 *  Υ꡼դϤޤԤǡ꡼դΤǤϤʤ
 *  ꡼դ餱ǡʾԤȤ̵̣Ǥꡢ
 *  ԤʤȤˤꡢ崧ι®ԤǤ뤬̤
 */
static void TTinsert(
  struct TTkey  *key, /*åȤʸʤɤξ*/
  struct TTnode *node,/*ȥåץΡ*/
  int num){           /*ĥ꡼ΤǲܤΥΡ(꡼)˥åȤ뤫*/

  TTsetLeaf(key,node,num);

  while(num>=2){
    /*Ԥ(ƥΡɤϿ)*/
    /*(-1) (0or1)*/
    if( 0>cmpKeyStr((node+num)->key->str, (node+num)->brother->key->str) ){
      (node+num)->parent->key=(node+num)->key;
    }else{
      (node+num)->parent->key=(node+num)->brother->key;
    }
    num=(node+num)->parent->num;
  }
}

/**
 * # FUNCTION #
 *ǽ˥꡼դ˥ǡ򥻥åȤˡƤΥȡʥԤؿ
 *  TTinsertλˤϡΥ󥵡Ȥ줿꡼դΤ߻ԤФ褤
 *  ΤǤδؿϻȤʤ
 */
static void TTevaluate(
  struct TTnode *node,/*ȥåץΡ*/
  int cnt){            /*դäѤο*/
  int i;

  /*Ԥ(ƥΡɤϿ)*/
  for(i=cnt*2-1; i>=3; i=i-2){
    if( 0>cmpKeyStr((node+i)->key->str, (node+i)->brother->key->str) ){
      (node+i)->parent->key=(node+i)->key;
    }else{
      (node+i-1)->parent->key=(node+i)->brother->key;
    }
  }
}

/**
 * # FUNCTION #
 * TTnodeɽ(ǥХå)
 * TTprintTreeؿƤӽФ롣
 */
static void TTptree(
  struct TTnode *p,
  int num,   /*Ρֹ*/
  int h,     /*ڤο*/
  int max) { /*Ρֹκ()*/
  int i;

  if(num<=max){
    TTptree(p, num*2, h+1, max);

    for(i=1; i<=h; i++) printf("   ");
    if( (p+num)->key->str == readEnd ){
      printf("%d NULL\n",(p+num)->num);
    }else{
      if(CmpRevNum){
        printf("%d ", (p+num)->num);
        for(i=0; i<4; i++){
          printf("'%s'",*((char **)(p+num)->key->str+i));
        }
        printf(" %d\n", (p+num)->key->bkt);
      }else{
        printf("%d '%s' %d\n",
               (p+num)->num,(p+num)->key->str,(p+num)->key->bkt);
      }
    }

    TTptree(p, num*2+1, h+1, max);
  }
}

/**
 * # FUNCTION #
 * TTĥ꡼ɽ(ǥХå)
 */
void TTprintTree(
  char *s,
  struct TTnode *top,
  int cnt){ /*դäѤο*/
  printf("%s\n",s);
  TTptree(top,1,0,cnt*2-1);
  printf("------end\n");
}

/**
 * # FUNCTION #
 * ǡɤڤäˤϡƥ꡼դʼåȤ롣
 * Ϳʸʼɤ򸡽Ф뤿δؿ
 */
static int isReadEndTT(char *str)
{
  if(str==readEnd) return(1);
  else             return(0);
}

/**
 * # FUNCTION #
 *դʸǤstrcpy(ͤϥԡμΥɥ쥹)
 * ΰϳݤʤΤǡʸtoˤʸfrom򥳥ԡ˽ʬΰ
 * 뤳Ȥ
 */
static char *strChrCpy(
  char *to,   /*ԡΰ*/
  char *from, /*ԡʸ*/
  char end){  /*դʸ*/
  
  while(*from!='\0'){
    *to++=*from++;
  }
  *to++=end;
  return(to);
} 

/**
 * # FUNCTION #
 *ե̾μ
 */
static char *getFname(char *prefix, int num)
{
  sprintf(TFname,"%s%d",prefix,num);
  return(TFname);
}

/**
 * # FUNCTION #
 * qsortη̤ե˽񤭹ؿ
 * wrkPnt˳ƹԤƬɥ쥹wrkCnt
 */
static void writeBuf(char **wrkPnt,int wrkCnt, char *fname)
{
  int i;
  struct mssFPW      *outFile;

  outFile=mssOpenFPW(fname,0,0);
  for(i=0; i<wrkCnt; i++){
    mssWriteStr(*(wrkPnt+i),outFile);
    mssWriteRet(outFile);
  }
  mssCloseFPW(outFile);
}

/**
 * # FUNCTION #
 * ttKey˰ɤ߹
 * ʣΥХåȤΤbkt֤Υե뤫 rec¤Τɤ߹
 * Υɥ쥹TTkey¤Τ˥åȤ롣
 *  in setFirstLineTT,mergeTT,readFPRfile
 */
static void readTTkey(
  struct TTkey *ttKey,
  struct mssSortDat *sd,
  int bkt){

  /*ս硢ͥȤξ*/
  if(CmpRevNum){
    if(EOF==mssReadFldRec(sd->iFile[bkt],sd->fr[bkt])){
      ttKey->str=readEnd;           /*EOFλʼ*/
      ttKey->bkt=bkt;               /*ХåֹΥå*/
    }else{
      /*Ǥϥѥηٹ򤱤뤿˰öchar **char **/
      /*˥㥹ȤƤºݤӥ롼(cmpKeyStr)Ǥϡ*/
      /*Υɥ쥹Ƥchar **˥㥹ȤơܤȤӤԤäƤ롣*/
      ttKey->str=(char *)sd->fr[bkt]->pnt; /*ɤߤʸƬɥ쥹*/
      ttKey->bkt=bkt;                      /*ХåֹΥå*/
    }
  /*ʸ󥽡Ȥξ*/
  }else{
    if(EOF==mssReadRec(sd->iFile[bkt],sd->rec[bkt])){
      ttKey->str=readEnd;           /*EOFλʼ*/
      ttKey->bkt=bkt;               /*ХåֹΥå*/
    }else{
      ttKey->str=sd->rec[bkt]->pnt; /*ɤߤʸƬɥ쥹*/
      ttKey->bkt=bkt;               /*ХåֹΥå*/
    }
  }
}


/**
 * # FUNCTION #
 * ܤ¤ٴΡ¤Ӥȿ¤ӤбꥹȤؿ
 * ǡ̾:a b c d    k=b,d λ
 *       ܤ b d a c ˹ܤ¤ٴ롢
 *
 * conv[0..3]
 * 0 -> b-> 1
 * 1 -> d-> 3
 * 2 -> a-> 0
 * 3 -> c-> 2
 */
static void setConv(struct mssSortDat *sd)
{
  int i,j;
  int tmp[MssFieldMaxLen];

  for(i=0; i<sd->fldCnt; i++) tmp[i]=0;
  for(i=0; i<sd->flds->cnt; i++){
    tmp[MssFlds2num(sd->flds,i)]=1;
  } 

  for(i=0; i<sd->fldCnt;  i++){
    if(i<sd->flds->cnt){
      sd->conv[i]=MssFlds2num(sd->flds,i);
    }else{
      for(j=0; j<sd->fldCnt; j++){
        if(tmp[j]==0){
          tmp[j]=1;
          break;
        }
      }
      sd->conv[i]=j;
    }
  }
}

/**
 * # FUNCTION #
 * ƥХåȤκǽιԤTT塼ɤ߹
 * mergeTT,preSortƤӽФ
 * iFromiToޤǤΥեƬԤTT塼
 */
static void setFirstLineTT(
  struct mssSortDat *sd, /*iFile,tt򥻥åȤ*/
  int iFrom,          /*ϥեֹ*/
  int iTo){           /*λեֹ*/

  struct TTkey ttKey;     /*TT塼ǡι¤*/
  int bkt;                /*߽ΥХåֹ(0Ϥޤ)*/
  int i;

  /*Хåȿ*/
  sd->bktCnt=iTo-iFrom+1;

  /*ȡʥȥĥ꡼ν*/
  sd->tt=TTinit(sd->bktCnt);

  bkt=0;
  for(i=iFrom; i<=iTo; i++){
    /*iܤΥХåȤΥץ*/
    sd->iFile[bkt]=mssOpenFPR(getFname(sd->prefix,i),4);
    /*ХåȤɤ߹ttKey˥å*/
    readTTkey(&ttKey, sd, bkt);

    /*åȤttKeyȡʥȥĥ꡼˥꡼դȤƥå*/
    /*Ρɿ:2*sd->bktCnt-1, դäѿ:sd->bktCnt;*/
    /*äդäѤκǽΥΡֹ:2*sd->bktCnt-1-sd->bktCnt+1=sd->bktCnt*/
    TTsetLeaf(&ttKey,sd->tt,sd->bktCnt+bkt);
    bkt++;
  }

  /*ȡʥȥĥ꡼ǡͥԤ*/
  TTevaluate(sd->tt,sd->bktCnt);

  /*TTprintTree("############ before",sd->tt,sd->bktCnt);*/
}

/**
 * # FUNCTION #
 * TT塼ѤPWayޡ
 * ¤ѤäƤХå(iCnt)ʻ礷Ƥ
 * ǸΰĤˤʤޤʻϤʤ
 * PWaySĤ꾯ʤʤäȤʻߤ
 */
static void mergeTT( struct mssSortDat *sd )
{

  int    bkt;              /*PWayʻΥХåֹ*/
  struct TTkey   ttKey;    /*ץ饤ƥ塼Υǡ¤*/
  struct TTnode *node;     /*popˤƼΡɤǼ*/

  struct mssFPW *oFile;       /*ϥեݥ*/

  int    iStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    iEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    oStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    oEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    iFrom,iTo;        /*ʻ礹Υեֹ*/
  int    k;
  int    i;

  /*Υ롼פin,outswapΤǡǤϵդ*/
  iStart=sd->iEnd+1;
  iEnd  =sd->iEnd+1;
  oStart=sd->iStart;
  oEnd  =sd->iEnd;

  /*եʻ礹롼 iCntPWaySĤ礭ޤ³*/
  while(1){
    mssSwapInt(&iStart,&oStart);
    mssSwapInt(&iEnd  ,&oEnd  );
    oEnd=oStart;

    /*ϥեPWaySʲʤнλ*/
    if(iEnd-iStart+1 <= PWayS){
      sd->iStart = iStart;
      sd->iEnd   = iEnd;
      break;
    }

    /* "PwayĤiFileĤoFile˽񤭽Ф"򷫤֤롼*/
    k=0;
    while(1){

      /*ƥХåȤκǽԤ򥭥塼*/
      iFrom= k   *PWayS+iStart;
      iTo  =(k+1)*PWayS+iStart-1;
      if(iTo>iEnd) iTo=iEnd;
      setFirstLineTT(sd, iFrom,iTo);

      /*ϥե륪ץ*/
      oFile=mssOpenFPW(getFname(sd->prefix,oEnd),0,0);

      /*ƥХåȤԤŤɤ߹߽񤭽Ф롼*/
      while(1) {
        node=sd->tt+1;                           /*塼ԼФ*/
        if(isReadEndTT(node->key->str)) break;   /*readEnd(ʼ)ʤ齪λ*/
        bkt=node->key->bkt;                      /*ФΥХåֹ*/
        /*Խ񤭽Ф*/
        if(CmpRevNum){
          mssWriteFld((char **)node->key->str,sd->fldCnt,"\n",oFile);
        }else{
          mssWriteStr(node->key->str,oFile);
          mssWriteRet(oFile);
        }
        readTTkey(&ttKey, sd, bkt);              /*ιԤɤ߹*/
        TTinsert(&ttKey,sd->tt,sd->bktCnt+bkt);  /*򥭥塼ɲ*/
        /*TTprintTree("############ before",sd->tt,sd->bktCnt);*/
      }

      TTfree(sd->tt);             /*塼γ*/
      for(i=0; i<=iTo-iFrom; i++) /*ϥեΥ*/
        mssCloseFPR(sd->iFile[i]);
      mssCloseFPW(oFile);            /*ϥեΥ*/
      if(iTo==iEnd)break;         /*ǸΥХåȤޤǤнλ*/
      oEnd++;                     /*ϥեֹ楫ȥå*/
      k++;                        /*ʻȥå*/
    }

    /*ϥեκ*/
    for(i=iStart; i<=iEnd; i++){
      unlink(getFname(sd->prefix,i));
    }
  }
}

/**
 * # FUNCTION #
 * iCntΥХåȤơquick sort롣
 * strChrCpyǥХåեΰ˥ԡˡեХåե򤽤Τޤ޻Ȥ
 * ®Ǥǽ롣ܤ¤ٴΤꡣ
 */
static void sort(
  struct mssSortDat *sd,   /*convϤȤƻȤ¾Ͻλ֤εϿ*/
  struct mssFPR *inFile){

  struct mssFldRec *fr;       /*ϥե򥭡¤ٴ뤿ΥХåե*/
  int            rf;       /*ϥե뤫ɤ߹ʸ*/
  int    iCnt;             /*ϥեΥȥåѿ*/
  int    wrkCnt;           /*bufferԿ*/
  char  *wrkBuf;           /*ǡΤbuffer*/
  char **wrkPnt;           /*ǡΤФݥ*/
  char  *curBuf;           /*ϥեwrkBuf˥ԡݤcurrent*/
  int    i;

  /*ǡѥΰ*/
  wrkBuf=mssMalloc((MaxMemS+MssRecordMaxLen)*sizeof(char  ),"sorting error");
  /*ǡؤΥݥѥΰ*/
  wrkPnt=mssMalloc( MaxLineS * sizeof(char *),"sorting error");

  /*---------------------------------------------*/
  /*ƥХåȤΥ(qsort)*/
  /*---------------------------------------------*/
  /*ǡХåʬ䤷ƥХå¤ٴ*/
  /*iCnt˥ե*/
  curBuf=wrkBuf;
  iCnt=0;
  wrkCnt=0;
  fr=mssInitFldRec(sd->fldCnt); /*FldRecν*/
  while(1){
    /*ǡɤ߹*/
    rf = mssReadFldRec(inFile,fr);

    /*եؤν񤭽Ф*/
    if( curBuf-wrkBuf >= MaxMemS || wrkCnt >= MaxLineS || rf==EOF){
/*
      qsort(wrkPnt,wrkCnt,sizeof(char *),
             (int (*)(const void *,const void *))cmpKeyQst);
*/
      qsort5((char *)wrkPnt,wrkCnt,sizeof(char *),
             (int (*))cmpKeyQst);
      writeBuf(wrkPnt,wrkCnt,getFname(sd->prefix,iCnt));
      iCnt++;
      wrkCnt=0; curBuf=wrkBuf;
      if(rf==EOF) break;
    }

    sd->recCnt++; /*쥳ɿȥå*/

    /*ХåեؤΥԡ*/
    *(wrkPnt+wrkCnt)=curBuf;
    wrkCnt++;

    for(i=0; i<sd->fldCnt-1; i++){
      curBuf=strChrCpy(curBuf,*(fr->pnt+sd->conv[i]),MssFieldDelim);
    }
    curBuf=strChrCpy(curBuf,*(fr->pnt+sd->conv[i]),'\0');
  }
  mssFreeFldRec(fr);
  mssFree(wrkBuf);
  mssFree(wrkPnt);

  sd->iStart = 0;
  sd->iEnd   = iCnt-1;
}

/**
 * # FUNCTION #
 *iCntΥХåȤơquick sort롣(͡սС)
 *strChrCpyǥХåեΰ˥ԡˡեХåե򤽤Τޤ޻Ȥ
 *®Ǥǽ롣ܤ¤ٴΤꡣ
 */
static void sort2(
  struct mssSortDat *sd,   /*convϤȤƻȤ¾Ͻλ֤εϿ*/
  struct mssFPR *inFile){

  struct mssFPW *fpw;
  struct mssFldRecMax *frm;   /*ϥե򥭡¤ٴ뤿ΥХåե*/
  int    iCnt;             /*ϥեΥȥåѿ*/
  int    i;

  /*---------------------------------------------*/
  /*ƥХåȤΥ(qsort)*/
  /*---------------------------------------------*/
  /*ǡХåʬ䤷ƥХå¤ٴ*/
  /*iCnt˥ե*/
  iCnt=0;
  frm=mssInitFRM(sd->fldCnt); /*FldRecν*/
  while(EOF != mssReadFRM(inFile,frm) ){

    sd->recCnt+=frm->recCnt; /*쥳ɿȥå*/

/*
    qsort(frm->pnt, frm->recCnt, sizeof(char *)*frm->fldCnt,
           (int (*)(const void *,const void *))cmpKeyQst);
*/
    qsort5((char *)frm->pnt, frm->recCnt, sizeof(char *)*frm->fldCnt,
             (int (*))cmpKeyQst);

    fpw=mssOpenFPW(getFname(sd->prefix,iCnt),0,0);
    for(i=0; i<frm->recCnt; i++){
      mssWriteFld(frm->pnt+i*frm->fldCnt,frm->fldCnt,"\n",fpw);
    }
    mssCloseFPW(fpw);
    iCnt++;
  }
  mssFreeFRM(frm);

  sd->iStart = 0;
  sd->iEnd   = iCnt-1;
}

/*
Ʊ쥳ޥɤʣmssReopenFPRsort¹Ԥpidǥե
Ǥʤʤ롣ΤᡢinitSDƤӽФsecNum򥫥ȥåפ
ֹե̾ΰ˴ޤᡢ򤹤롣
*/
int secNum=0;

/**
 * # FUNCTION #
 * mssSortDat¤Τν
 */
static struct mssSortDat *initSD(struct mssFields *flds, int fldCnt, char *tmpDir)
{
  struct mssSortDat *sd;
  int i;
  int    pid;              /*ץID(ե̾ΰ)*/

  /*ս硢ͥȻ꤬On(Global)*/
  CmpRevNum=0;
  for(i=0; i<flds->cnt; i++){
    if( MssFlds2revFlg(flds,i) || MssFlds2numFlg(flds,i) ){
      CmpRevNum=1;
    }
  }

  /*Хѿ˥å*/
  SortFld=flds;

  sd=mssCalloc(sizeof(struct mssSortDat),"initSD");

  sd->flds=flds; /*ȹܹ¤ΤΥå*/

  /*ս硢ͥȤξFldRec¤ΤȤ*/
  if(CmpRevNum){
    for(i=0; i<PWayS; i++) sd->fr[i]=mssInitFldRec(fldCnt);

  /*ʸ󥽡ȤξRec¤ΤȤ*/
  }else{
    for(i=0; i<PWayS; i++) sd->rec[i]=mssInitRec();
  }

  sd->fldCnt=fldCnt;

  /*ե̾Υץեå*/
  pid=getpid();
  if(tmpDir==NULL){
    mssShowErrMsg("path name of work directory is null");
    mssEnd(mssErrorNoDefault);
  }
  if(strlen(tmpDir) > MssFileNameMaxLen - 50 ) {
    mssShowErrMsg("length of path name must be less than %d",MssFileNameMaxLen-50);
    mssEnd(mssErrorNoDefault);
  }
  sprintf(sd->prefix,"%s/xt##%d-%d-PreSrt-",tmpDir,pid,secNum);

  /*ʥϥɥ*/
  mssGV.usedTempFileFlg=1;
  mssSetSignalHandler();

  secNum++;
  return(sd);
}

/**
 * # FUNCTION #
 *mssSortDat¤Τγ
 */
static void freeSD(struct mssSortDat *sd)
{
  int i;

  TTfree(sd->tt); /*ȡʥȥĥ꡼Υ塼γ*/

  if(CmpRevNum){
    for(i=0; i<PWayS; i++) mssFreeFldRec(sd->fr[i]);
  }else{
    for(i=0; i<PWayS; i++) mssFreeRec(sd->rec[i]);
  }

  mssFree(sd);
}

/**
 * # FUNCTION #
 * ޡȤǻȤäեκ
 */
static void endPreSort(struct mssSortDat *sd)
{
  int i;

  /*ХåեΤˡϥեϤǽƥ*/
  for(i=0; i<=sd->iEnd-sd->iStart; i++){
    mssCloseFPR(sd->iFile[i]);
  }

  /*եκ*/
  for(i=sd->iStart; i<=sd->iEnd; i++){
    unlink(getFname(sd->prefix,i));
  }
}


/**
 * # FUNCTION #
 * Хåqsort+ȡʥȥĥ꡼ˤPWayޡ
 */
static void preSort(
  struct mssSortDat *sd,
  struct mssFPR     *inFile){


  if(CmpRevNum){/*ս硢ͥȻ꤬ initSDǥå*/
    sort2(sd,inFile);
  }else{
    setConv(sd);
    sort(sd,inFile);
  }
  mergeTT(sd);
  setFirstLineTT(sd, sd->iStart,sd->iEnd);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ϥեϢδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * եμ
 * fNameͿ줿xmlTableեˤĤơmaxCntԤɤ߹
 * mssFileInfo¤ΤιԿܿʤɤ򥻥åȤι¤ΤΥɥ쥹֤
 */
struct mssFileInfo *mssGetFileInfo(char *fName, int maxCnt)
{

  int cnt;     /*쥳ɿ򥫥*/
  struct mssFileInfo *fi;
  struct stat fStat;
  struct mssFPR   *fpr;      /*ϥե빽¤*/
  struct mssHeader *hdi; /*ϥեheaderǼ¤*/
  struct mssRec    *rec=NULL; /*ԥХåե¤*/

  fi=mssMalloc(sizeof(struct mssFileInfo),"chkFile");
  if(-1 == stat(fName,&fStat)){
    mssShowErrMsg("cannot get file status:%s",fName);
    mssEnd(mssErrorNoDefault);
  }

  fi->maxCnt    = maxCnt;
  fi->fName     = fName;
  fi->totalSize = fStat.st_size;
  fi->readEnd   = 1;

  fpr=mssOpenFPR(fName,4); /*ե륪ץ*/
  hdi=mssReadHeader(fpr);  /*̾ɤ߹*/
  fi->fldCnt   = hdi->flds->cnt;
  mssFreeHeader(hdi);     /*ϥإåΰ賫*/

  rec=mssInitRec();
  cnt=0;
  fi->bodySize=0;
  while(EOF != mssReadRec(fpr,rec)){
    fi->bodySize += rec->chrCnt;
    if(maxCnt<=++cnt && maxCnt!=0){
      fi->readEnd = 0;
      break;
    }
  }
  fi->recCnt =cnt;
  mssFreeRec(rec);
  mssCloseFPR(fpr);

  return(fi);
}

/**
 * # FUNCTION #
 * mssFPR¤fpϥǡɤ߹ɤ(EOF)򸡽Ф롣
 * :1=EOF, 0:not EOF
 */
static int isEOF(struct mssFPR *fp)
{
  if( fp->last ){ /*eofޤɤ߹ߤ򤷤?*/
    if(*fp->curPnt=='\0' || 0==strncmp(fp->curPnt,MssEndBodyString,10)){
      return(1);
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * ܿۤʤerroråɽ&λ
 */
static void fldCntErr(char **pnt, int fldCnt, int j, struct mssFPR *fp)
{
  if(fp->fName==NULL){
    mssShowErrMsg("detected different number of fields in line %d(header has %d, but a record has %d) : %s",mssGV.inCnt+1,fldCnt,j,"stdin");
    mssEnd(mssErrorNoDefault);
  }else{
    mssShowErrMsg("detected different number of fields in line %d(header has %d, but a record has %d) : %s",mssGV.inCnt+1,fldCnt,j,fp->fName);
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * # FUNCTION #
 * mssFPRΥ󥰥Хåեθ֤߰ιԤǥڡdelimitorȤƥȡʬ
 * ȡʬ䤵줿(ʸ)ϡ*(pnt+i)˳Ǽ롣
 * äơpntѿϡδؿƤӽФˡΰݤƤɬפ롣
 * ʸκǸʸ'\n'Ǥ'\0'ǤOK
 *     -> '\0'Ϥ٤(Ϣ³'\0'򥹥åפΤϴ)
 * ʤϢ³'\n'⤷'\0'ϥåפ롣
 * ܿۤʤХ顼λ
 * ιԤƬ֤֤
 */
static char *strToken(char **pnt, int fldCnt, int *chrCnt, struct mssFPR *fp)
{
  char *str=fp->curPnt;
  int j;


  /*̾եξ⤷ϥȥեǿ͡ս祽Ȥξ*/
  if(fp->sd==NULL || CmpRevNum){
    j=0; /*ܿ*/
    while(1){
      switch(*str){
      case MssFieldDelim:
        *str='\0';
        str++;
        break;
      case '\n':
      case '\0':
        if(fldCnt != j){
          fldCntErr(pnt,fldCnt,j,fp);
        }
        *str='\0';
        str++;
        *chrCnt+=str-fp->curPnt; /*ʸι*/
        return(str);
        break;
      default:
        /*֤ܰϿ*/
        if(j<fldCnt) *(pnt+j)=str;
        j++;
        /*MssFieldDelim(⤷EOL)ޤǥå*/
        while(*str!=MssFieldDelim && *str!='\n' && *str!='\0') str++;
        break;
      }
    }

  /*ȥեξ*/
  }else{
    j=0; /*ȥեιֹ conv[j]ǸΥեֹ*/
    while(1){
      switch(*str){
      case MssFieldDelim:
        *str='\0';
        str++;
        break;
      case '\n':
      case '\0':
        if(fldCnt != j){
          fldCntErr(pnt,fldCnt,j,fp);
        }
        *str='\0';
        str++;
        *chrCnt+=str-fp->curPnt; /*ʸι*/
        return(str);
        break;
      default:
        /*֤ܰϿ*/
        if(j<fldCnt) *(pnt+fp->sd->conv[j]) = str;
        j++;
        /*MssFieldDelim(⤷EOL)ޤǥå*/
        while(*str!=MssFieldDelim && *str!='\n' && *str!='\0') str++;
        break;
      }
    }
  }

  /*returnϤʤѥٹɤ*/
  return(str);
}

/**
 * # FUNCTION #
 * 󥰥Хåեؤϥǡɤ߹
 * ringBuffer
 *
 *     buf[0]        buf[1]      .... buf[n]
 *    +------+      +------+
 *   A|      |  +-->|   x  |
 *    +------+  |   +------+  +
 *   B|      | copy |      |  |
 *    |      |  |   |      |  |  ɤ߹
 *    +------+  |   +------+  |
 *   C|   x  |--+   |      |  |
 *    +------+      +------+  +
 *       x:fp->curPnt
 *
 *  readؿˤɤ߹ΰ : B+C -> BktSize * BktCnt = ReadSize
 *  fp->curPntCΰˤСΥХåե˰ܤ롣
 *  κݡC򼡤ΥХåեA˥ԡƱcurPntư롣
 *
 *                     buf[0]
 *                buf[n]     buf[1] +---->fp->deq
 *              buf[.]          buf[2]
 *                buf[.]     buf[3]+---->fp->cuq
 *                     buf[4]+------>fp->enq
 * 
 *  deq : ¸Ƥ٤Хåեγϰ
 *  enq : ˥ǡɤ߹Хåե
 *  cuq : оݤȤʤäƤХåե(curPntޤޤΰ)
 *
 *  δؿeofθФϹԤʤ
 *  ReadSize꾯ʤ'\0'ɲ
 *  Хåեfull֤λɤ߹⤦Ȥ-1֤¾ξ1֤
 */
static int readFPRfile(struct mssFPR *fp)
{

  /*̾ե*/
  register int size; /*readؿɤߤ*/
  register int i;

  /*sortե*/
  struct TTnode *node;     /*popˤƼΡɤǼ*/
  struct TTkey   ttKey;    /*ץ饤ƥ塼Υǡ¤*/
  int bkt;

  /*塼full*/
  if(fp->full) return(-1);

  /*̾եξ*/
  if(!fp->sort){
    /*enqƬʤХХåեǸMssRecordMaxLenʸХåեƬ˥ԡ*/
    if(fp->enq==0){
      memcpy(fp->buf, fp->buf+fp->queSize*fp->queCnt, MssRecordMaxLen);
      fp->curPnt=fp->curPnt-fp->queSize*fp->queCnt; /*curPntΰư*/
    }
    /*եɤ߹*/
    for(i=0; i<ReadCnt; i++){
      if(fp->zflg){
        size = gzread(fp->zfd,
                      fp->buf+fp->enq*fp->queSize+PipeSize*i+MssRecordMaxLen,
                      PipeSize);
      }else{
        size = fread(fp->buf+fp->enq*fp->queSize+PipeSize*i+MssRecordMaxLen,
                     sizeof(char) ,PipeSize, fp->fp);
      }

      if( 0 > size ) {
        mssShowErrMsg("file read error");
        mssEnd(mssErrorNoDefault);
      }

      /*eofޤɤ߹ߤξ硢eofΰΤ'\0'ɲ*/
      if(size<PipeSize){
        *(fp->buf+fp->enq*fp->queSize+PipeSize*i+MssRecordMaxLen+size) = '\0';
        fp->last=1;
        break;

      /*size0꾮Ȥϡɤ߼ꥨ顼*/
      }else if(size<0){
        mssShowErrMsg("file read error");
        mssEnd(mssErrorNoDefault);
      }
    }

    /*enqueueоݥХåե򣱤Ŀʤ*/
    fp->enq=NextQue(fp->enq,fp->queCnt);
  
    /*ХåեfullȽ*/
    if(fp->enq == fp->deq) fp->full=1;

  /*sortեξ*/
  /*̾եƱƯ򤹤*/
  /*ۤʤϡñ̤Ǥɤ߹ߤΤᡢqueSizeۤǡϼque*/
  /*ɤߤޤ롣ΤᡢbufferIsFullȽdeq+2==enqλˤʤ롣*/
  /*ޤbufferκǸqueμˤoverFlowBuffer뤳ȤȤʤ롣*/
  }else{
    /*enqƬʤХХåեǸMssRecordMaxLen*2ʸХåեƬ˥ԡ*/
    if(fp->enq==0){
      /*MssRecordMaxLen*22overFlowBufferʬ*/
      memcpy(fp->buf, fp->buf+fp->queSize*fp->queCnt, MssRecordMaxLen*2);
      fp->curPnt =fp->curPnt -fp->queSize*fp->queCnt; /*curPntΰư*/
      fp->readPnt=fp->readPnt-fp->queSize*fp->queCnt; /*curPntΰư*/
    }

    /*ȡʥȥĥ꡼ɤ߹(queSizeۤޤstrcpy)*/
    while(1){
      /*readPntenqΰۤɤ߹߽λ*/
      if(fp->readPnt>=fp->buf+(fp->enq+1)*fp->queSize+MssRecordMaxLen){
        break;
      }

      node=fp->sd->tt+1;              /*塼ԼФ*/
      if(isReadEndTT(node->key->str)){  /*readEnd(ʼ)Ф齪λ*/
        *fp->readPnt='\0';
        fp->last=1;
        break;
        return(1); /*ꤢ*/
      }
      bkt=node->key->bkt;     /*ФΥХåֹ*/

      /*͡ս祽ȤξtnTree˹ܤڤäƤΤ᤹*/
      /*ν̵̤Τ褦˻פ뤬mssReadRec,mssReadFldRecʤɤ*/
      /*̤readؿ̾Ʊ˰Τǥƥʥ󥹤ڡ*/
      if(CmpRevNum){
        for(i=0; i<fp->sd->fldCnt-1; i++){
          fp->readPnt=strChrCpy(fp->readPnt,*((char **)node->key->str+i),
                                MssFieldDelim);
        }
        fp->readPnt=strChrCpy(fp->readPnt,*((char **)node->key->str+i),'\n');
      }else{
        fp->readPnt=strChrCpy(fp->readPnt,node->key->str,'\n');
      }
      readTTkey(&ttKey, fp->sd, bkt);                /*ιԤɤ߹*/
      TTinsert(&ttKey,fp->sd->tt,fp->sd->bktCnt+bkt);/*塼ɲ*/
    }
    /*enqueueоݥХåե򣱤Ŀʤ*/
    fp->enq=NextQue(fp->enq,fp->queCnt);

    /*ХåեfullȽ(enqμΥХåեˤǡäƤΤ)*/
    if(NextQue(fp->enq,fp->queCnt) == fp->deq) fp->full=1;
  }
  return(1); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * readFileɬѤ뤫ɤ
 */
static int needFileRead(struct mssFPR *fp)
{

  if(fp->last)return(0);

  /*MssRecordMaxLenƬζΰ褬Τǡ+-Ǿä*/
  if(fp->curPnt >= fp->buf+(PrevQue(fp->enq,fp->queCnt)+1)*fp->queSize)
    return(1);
  else
    return(0);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ñ̤ɤ߹ߴؿϢ
 * ----------------------------------------------------------------------------
 * xmlTableΥǡɤ߹ˡʲΣѰդƤ롣
 * 1.ñ̤Ǥɤ߹(mssReadRec)
 *   ԤȤɤ߹ࡣܤΥȡʬϹԤʤΤǹ®Ǥ롣
 * 2.Թñ̤ɤ߹(mssReadFldRec)
 *   ԤȤɤ߹ߡܤȡʬ䤵롣
 * 3.Թñ̤ɤ߹(mssReadFRD)
 *   ˥ǡԤԥפʤɤ߹ࡣ֥졼
 * 4.ñ̤ɤ߹(mssReadFRK)
 *   ƱͤΥǡöɤ߹ࡣ
 *   ǡ̤礭аեȤ
 * 5.ꤵ줿Хȿޤɤ߹(mssReadFRM)
 *   󥰥ХåեäѤˤʤޤɤ߹ޤ롣
 */

/**
 * # FUNCTION #
 * mssRec¤Τν
 */
struct mssRec *mssInitRec(void)
{
  struct mssRec *rec;
  rec=mssMalloc(sizeof(struct mssRec), "initRec");
  rec->chrCnt=0;
  rec->eof   =0;
  return(rec);
}

/**
 * # FUNCTION #
 * mssRec¤Τγ
 */
void mssFreeRec(struct mssRec *rec)
{
  mssFree(rec);
}

/**
 * # FUNCTION #
 * mssRec¤Τإǡɤ߹
 * ɤ߹ޤ줿ǡؤϡrec->pntǻȲǽ
 * βԤϾʤ롣
 */
int mssReadRec(struct mssFPR *fp, struct mssRec *rec)
{
  register int i; /*®Τregisterѿ*/

  /*֤߰ХåեǸMssRecordMaxLenʸˤäƤեɤ߹*/
  if(needFileRead(fp)){
    readFPRfile(fp);
    /*ñ̤ɤ߹ߤξϾdeqenqΣ*/
    fp->deq=PrevQue(fp->enq,fp->queCnt);
  }
  /*eofθ*/
  if(isEOF(fp)){
    rec->eof=1;
    return(EOF);
  }

  /* '\n'delimitorȤưԤڤФ*/
  rec->pnt=fp->curPnt;
  i=0;
  while( '\n' != *fp->curPnt++ ){
    if(i++>=MssRecordMaxLen){
      mssShowErrMsg("exceed %d characters per record\n",MssRecordMaxLen);
      mssEnd(mssErrorNoDefault);
    }
  }
  *(fp->curPnt-1)='\0';

  fp->chrCnt+=i+1;
  fp->recCnt++;
  rec->chrCnt=fp->curPnt-rec->pnt;

  return(1); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * mssFldRec¤Τν
 * ˹ܿͿ롣ºݤɤ߹ݤ˹ܿۤʤХ顼λ롣
 */
struct mssFldRec *mssInitFldRec(int fldCnt)
{
  struct mssFldRec *fr;
  fr=mssMalloc(sizeof(struct mssFldRec), "initFldRec");
  fr->pnt=mssCalloc(sizeof(char *)*fldCnt,"initFldRec");
  fr->fldCnt=fldCnt;
  fr->chrCnt=0;
  fr->eof   =0;
  return(fr);
}

/**
 * # FUNCTION #
 * mssFldRec¤Τγ
 */
void mssFreeFldRec(struct mssFldRec* fr)
{
  if(fr==NULL) return;
  mssFree(fr->pnt);
  mssFree(fr);
}

/**
 * # FUNCTION #
 * mssFldRec¤Τ˥ǡɤ߹
 * ɤ߹ޤ줿ǡؤϡ*(rec->pnt+i)ǻȲǽ(i0Ϥޤֹ)
 * βԤϾʤ롣
 */
int mssReadFldRec(struct mssFPR *fp, struct mssFldRec *fr)
{

  /*֤߰ХåեǸMssRecordMaxLenʸˤäƤ
    եɤ߹*/
  if(needFileRead(fp)){
    readFPRfile(fp);
    /*ñ̤ɤ߹ߤξϾdeqenqΣ*/
    fp->deq=PrevQue(fp->enq,fp->queCnt);
  }

  /*eofθ*/
  if(isEOF(fp)){
    fr->eof=1;
    return(EOF);
  }

  /*ڡdelimitorȤƥȡʬ*/
  fp->recCnt++;
  fp->curPnt=strToken(fr->pnt, fr->fldCnt, &fp->chrCnt, fp);

  /*ʸ򥻥å(Ǹ\0ޤ:ԡ)*/
  fr->chrCnt=fp->curPnt-*fr->pnt;
  return(1); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * Ĺեλꤵ줿ԤFldRec¤Τɤ߹
 * ॢ(FPR¤Τ˸Ĺե饰Ĥ٤)
 */
int mssReadRandFldRec(
  struct mssFPR *fp,
  struct mssFldRec *fr,
  int recNo,  /*seek쥳ֹ*/
  int datTop, /*ǡƬ*/
  int recLen) /*쥳Ĺ*/
{    /*쥳Ĺ*/

  char *buf;
  int cnt;

  buf=mssMalloc(sizeof(char)*MssRecordMaxLen,"readRandFldRec");

  fp->curPnt=buf; /*ޤ褯ʤˡ(ƤӽФ¦mssFree)*/
  fseek(fp->fp,datTop+recLen*recNo,SEEK_SET);
  fread(buf,sizeof(char),MssRecordMaxLen,fp->fp);

  strToken(fr->pnt, fr->fldCnt, &cnt, fp);

  return(1);
}

/**
 * # FUNCTION #
 * mssFldRecDbl¤Τν
 */
struct mssFldRecDbl *mssInitFRD(int fldCnt)
{

  struct mssFldRecDbl *frd;

  frd=mssMalloc(sizeof(struct mssFldRecDbl),"initFRD");
  frd->pnt[0]=mssCalloc(sizeof(char *)*fldCnt,"initFRD");
  frd->pnt[1]=mssCalloc(sizeof(char *)*fldCnt,"initFRD");

  frd->eof=0;

  frd->new=0;
  frd->old=1;

  frd->newChrCnt=0;
  frd->oldChrCnt=0;

  /*ǽιԤɤߤȤåȤ*/
  frd->firstRead=1;

  frd->fldCnt=fldCnt;

  return(frd);
}

/**
 * # FUNCTION #
 * mssFldRecDbl¤Τγ
 */
void mssFreeFRD(struct mssFldRecDbl *frd)
{

  mssFree(frd->pnt[0]);
  mssFree(frd->pnt[1]);
  mssFree(frd);
}

/**
 * # FUNCTION #
 * mssFldRecDbl¤Τˤǡɤ߹ߤΥ֥쥤Ƚ
 *  1:֥졼 0:֥졼Ǥʤ
 * ƬԤɤ߹߻ϥ֥졼Ƚꤷʤ
 * EOFɤ߹߻ϥ֥졼Ƚꤷ롣
 * opeKey->diffSame 1ξ(԰ۤʤ륭ͤȸ)Ͼ1֤
 * opeKey->diffSame 0ξ(Ʊͤȸ)Ͼ0֤
 */
int mssKeyBreak(struct mssFldRecDbl *frd, MssOptKEY *optKey)
{
  int i,fn;

  /*ǽԤλϥ֥졼Ǥʤ*/
  if(frd->firstRead){
    /*multi keyб뤿˰ʲifʸɲ*/
    if(frd->new){
      return(0);
    }else{
      frd->firstRead=0;
    }
  }

  /*ǽԤλϥ֥졼*/
  if(frd->eof == 1) return(1);

  switch(optKey->diffSame){

  /*ưۤʤͤȸϥ֥졼*/
  case 1:
    return(1);

  /*Ʊͤȸϥ֥졼*/
  case 2:
    return(0);

  default:
    for(i=0; i<optKey->flds->cnt; i++){
      fn=MssFlds2num(optKey->flds,i);
      if( 0 != strcmp(*(frd->pnt[frd->new]+fn),*(frd->pnt[frd->old]+fn)) )
         return(1);
    }

    /*嵭ξ򥯥ꥢȤȤϥ֥졼Ǥʤ*/
    /*(key->cnt0ȤȤϡ-kλ꤬ʤΤǥ֥졼Ǥʤ)*/
    return(0);
  }
}


/**
 * # FUNCTION #
 * mssFldRecDbl¤Τ˥ǡɤ߹
 * ɤ߹ޤ줿ǡΥȹԤؤϡ*(frd->pnt[frd->new]+i)
 * ιԤؤ*(frd->pnt[frd->old]+i) ǻȲǽ(i0Ϥޤֹ)
 * ƬԤɤ߹Ȥ¸ߤʤΤ*(frd->pnt[frd->old]+i)ϡ
 * NULLȤʤ롣
 * EOFɤ߹ȤϡEOF֤
 */
int mssReadFRD(struct mssFPR *fp, struct mssFldRecDbl *frd)
{
  char *start;

  if(frd->eof) return(EOF);

  /*֤߰ХåեǸMssRecordMaxLenʸˤäƤեɤ߹*/
  if(needFileRead(fp)){
    readFPRfile(fp);
    /*ñ̤ɤ߹ߤǤ⡢queCntϺ4ɬ*/
    fp->deq=PrevQue(fp->enq,fp->queCnt);
  }

  /*eofθ ǽ˥ӤΤϡstrcmpӤ򸺤餹*/
  if(isEOF(fp)){ /* ߤɤ߹ߥݥ󥿤</body>ʤ*/
    if(frd->newChrCnt==0)return(EOF); /*ǡԤʤȤ˰ä*/
    frd->eof=1;
    mssSwapInt(&frd->new,&frd->old);
    return(1);
  }

  /*new˿Ԥι֤ܰ򤤤뤿ˡnewold촹*/
  mssSwapInt(&frd->new,&frd->old);

  /*ڡdelimitorȤƥȡʬ*/
  start=fp->curPnt; /*ߤΰ֤*/
  fp->recCnt++;
  fp->curPnt=strToken(frd->pnt[frd->new], frd->fldCnt,&fp->chrCnt,fp);

  /*new,oldԤʸ򥻥å(Ǹ\0ޤ:ԡ)*/
  frd->oldChrCnt=frd->newChrCnt;
  frd->newChrCnt=start-*frd->pnt[frd->new]+1;

  return(1);     /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * mssFldRecMax¤Τν
 */
struct mssFldRecMax *mssInitFRM(int fldCnt)
{
  struct mssFldRecMax *frm;
  frm=mssMalloc(sizeof(struct mssFldRecMax),"initFRM");
  frm->fldCnt=fldCnt;
  frm->chrCnt=0;
  frm->eof   =0;
  frm->recCnt=0;
  frm->recMax=MaxPntSize/(fldCnt*sizeof(char *));

  /*ݥΰγ(freeΤ˺ʬΤ߳)*/
  frm->pnt=mssMalloc(sizeof(char *)*frm->fldCnt*frm->recMax,"initFRM");
  return(frm);
}

/**
 * # FUNCTION #
 * mssFldRecMax¤Τγ
 */
void mssFreeFRM(struct mssFldRecMax *frm)
{
  mssFree(frm->pnt);
  mssFree(frm);
}

/**
 * # FUNCTION #
 * mssFldRecMax¤Τ˼ΤξƤ֡ǡɤ߹³롣
 *  1. ꤵ줿쥳ɿ(MaxPntSize/(ܿ*sizeof(char *)))Ķʤ
 *  2. 󥰥Хåե(mssOpenFPRؿǷޤ)FULLǤʤ
 * ɤ߹ޤ줿ǡϡñ̤frm->pntѤƤ
 * 㤨 "a b c","x y z"ΣԤΥǡɤ߹硢
 * *(pnt+0)="a",*(pnt+1)="b",*(pnt+2)="c",*(pnt+3)="x",*(pnt+4)="y",*(pnt+5)="z"
 * Ȥʤ롣ǡn(0Ϥޤ)m(0Ϥޤ)˥
 * ϡ*(frm->pnt+frm->fldCnt*n+m)Ȥ롣
 * ƬԤȤEOFɤ߹ȤϡEOF֤
 */
int mssReadFRM(struct mssFPR *fp, struct mssFldRecMax *frm)
{

  if(frm->eof){
    return(EOF);
  }

  frm->recCnt=0;

  while(1){

    /*ݥ󥿥ХåեfullǤХ꥿*/
    if(frm->recCnt>=frm->recMax){
      fp->deq = PrevQue(fp->enq,fp->queCnt);
      fp->full=0;
      return(1);
    }

    /*֤߰ХåեǸMssRecordMaxLenʸˤäƤեɤ߹*/
    if(needFileRead(fp)){
      /*ǡХåեfullǤнλ*/
      if(-1==readFPRfile(fp)){
        fp->deq = PrevQue(fp->enq,fp->queCnt);
        fp ->full=0;
        return(1);
      }
    }

    /*ǡeofθ*/
    if(isEOF(fp)){
      frm->eof=1;
      return(1);
    }else{
      /*ڡdelimitorȤƥȡʬ*/
      fp->recCnt++;
      fp->curPnt=strToken(frm->pnt+frm->recCnt*frm->fldCnt, frm->fldCnt,&fp->chrCnt,fp);
      frm->recCnt++;
    }
  }
  return(1);
}

/**
 * # FUNCTION #
 * mssFldRecKey¤Τν
 */
struct mssFldRecKey *mssInitFRK(int fldCnt, MssOptKEY *optKey, char *path)
{

  struct mssFldRecKey *frk;
  int pid;

  /*FRK¤ΰγ*/
  frk=mssMalloc(sizeof(struct mssFldRecKey),"initFRK");

  /**/
  frk->frPnt     = NULL;
  frk->pnt       = mssMalloc(sizeof(char *)*fldCnt,"readFldRecFRK");
  frk->fldCnt    = fldCnt;
  frk->chrCnt    = 0;
  frk->eof       = 0;
  frk->keyRecCnt = 0;
  frk->keyNo     = 0;
  frk->firstRead = 1;
  frk->alcRecCnt = 0;
  frk->recPnt    = 0;
  frk->optKey    = optKey;
  frk->byFile    = 0;
  frk->curRecNo  = 0;
  frk->fpw       = NULL;
  frk->fpr       = NULL;
  frk->fr        = NULL;
  
  pid=getpid();
  sprintf(frk->fName,"%s/xt##%d-FRK",path,pid);

  /*ʥϥɥ*/
  mssGV.usedTempFileFlg=1;
  mssSetSignalHandler();

  return(frk);
}

/**
 * # FUNCTION #
 * mssFldRecKey¤Τγ
 */
void mssFreeFRK(struct mssFldRecKey *frk)
{
  if(frk==NULL) return;
  if(0==access(frk->fName,R_OK & W_OK)) unlink(frk->fName);
  mssFree(frk->pnt);
  mssFree(frk->frPnt);
  mssFree(frk);
  mssFreeFldRec(frk->fr);
  mssCloseFPR(frk->fpr);
}

/**
 * # FUNCTION #
 * readFRKѤ륭֥졼Ƚ
 * ƱͤĺǽιԤȸɤ߹ԤӤ롣
 */
static int keyBreakFRK(struct mssFldRecKey *frk)
{
  int i,fn;

  /*ɤ߹ߤϥ֥졼Ǥʤ*/
  if(frk->firstRead){
    frk->firstRead=0;
    return(0);
  }

  /*ǽԤλϥ֥졼*/
  if(frk->eof == 1) return(1);

  switch(frk->optKey->diffSame){

  /*k=#allDiff#ξϥ֥졼*/
  case 1:
    return(1);

  /*k=#allSame#ξnot֥졼*/
  case 2:
    return(0);

  default:
    for(i=0; i<frk->optKey->flds->cnt; i++){
      fn=MssFlds2num(frk->optKey->flds,i);
      if( 0 != strcmp(*(frk->frPnt+(frk->recPnt-1)*frk->fldCnt+fn) ,
                      *(frk->frPnt+(frk->recPnt  )*frk->fldCnt+fn)) )
         return(1);
    }

    /*嵭ξ򥯥ꥢȤȤϥ֥졼Ǥʤ*/
    return(0);
  }
}

/**
 * # FUNCTION #
 * mssFldRecKey¤ΤfrPntХåեˤ,recNoܤΥ쥳ɤ񤭽Ф
 */
static void writeRecFRK(struct mssFldRecKey *frk,int recNo)
{
  int j;

  for(j=0; j<frk->fldCnt; j++){
    mssWriteStr(*(frk->frPnt+frk->fldCnt*recNo+j),frk->fpw);
    if(frk->fldCnt-1 == j) mssWriteRet(frk->fpw);
    else                   mssWriteDlm(frk->fpw);
  }
}

/**
 * # FUNCTION #
 * mssFldRecKey¤Τ˻ΥܤƱͤιԤɤ߹
 * եХåեFULLˤʤСե˽񤭽Ф
 * äơեѤ뤫ɤϡopenFPRǻꤷque˰¸
 * ɤ߹ޤ줿ǡؤϡmssReadFldRecFRKˤƥǤ롣
 * EOFɤ߹ȤϡEOF֤
 *
 * frPntؤΥǡѤˤĤ
 * 㤨 "a b c","x y z"ΣԤΥǡɤ߹硢
 * *(frPnt+0)="a",*(frPnt+1)="b",*(frPnt+2)="c",*(frPnt+3)="x",*(frPnt+4)="y",*(frPnt+5)="z"
 * Ȥʤ롣
 * δؿǤƱͤĹԤɤ߹िᡢԿξ¤ϻ
 * 狼ʤǡreallocؿˤưŪΰݤ롣
 * frk->alcRecCnt˸allocؿǳݤԿϿƤ롣
 * alcRecCntϡδؿθƤӽФ˥ꥢ뤳ȤϤʤ
 */
int mssReadFRK(struct mssFPR *fp, struct mssFldRecKey *frk)
{
  int i;

  if(frk->eof) return(EOF);

  /**/
  frk->keyRecCnt=0;
  frk->byFile=0;
  frk->curRecNo=0;
  mssCloseFPR(frk->fpr);
  frk->fpr=NULL;
  mssFreeFldRec(frk->fr);

 /* 2004/01/23 mssFreeFldRecθ˺ƤmssFreeFldRecƤӽФǽ뤿ᡢfrk->frNULLꥢ */
  frk->fr=NULL;

  /*κǽ쥳ɤfrPntƬ˥ԡ롣*/
  if(!frk->firstRead){
    for(i=0; i<frk->fldCnt; i++){
      *(frk->frPnt+i)=*(frk->frPnt+frk->fldCnt*frk->recPnt+i);
    }
    frk->keyRecCnt=1;

    /*ɤ߹֤߰frPnt+1*/
    frk->recPnt=1;
  }

  while(1){

    /*ǡɤ߹*/
    if(needFileRead(fp)){
      /*ǡХåեfull(-1)ǤХե񤭽Ф*/
      if(-1==readFPRfile(fp)){
        /*write˥ե륪ץ*/
        if(!frk->byFile) {
          frk->fpw=mssOpenFPW(frk->fName,0,0);
        }

        /*frPntƤǽԤưեwrite*/
        for(i=0; i<frk->recPnt-1; i++){
          writeRecFRK(frk, i);
        }

        /*frPntǽԤfrPntƬԤ˥ԡ(keyBreakΤ)*/
        for(i=0; i<frk->fldCnt; i++){
          *(frk->frPnt+i)=*(frk->frPnt+frk->fldCnt*(frk->recPnt-1)+i);
        }
        fp->deq = PrevQue(fp->enq,fp->queCnt);
        frk->byFile=1;
        fp->full=0;
        frk->recPnt=1; /*ɤ߹ߤfrPntΣܤ*/
        continue;
      }
    }

    /*eofθ*/
    if(isEOF(fp)){
      frk->eof=1;
      if(frk->firstRead) return(EOF); /*NULL ǡξ*/
    }else{
      /*ڡdelimitorȤƥȡʬ*/
      if(frk->alcRecCnt<=frk->recPnt){
        frk->frPnt=mssRealloc(frk->frPnt,
                            sizeof(char *)*(frk->recPnt+1)*frk->fldCnt,
                            "readFRK");
        frk->alcRecCnt++;
      }
      fp->curPnt=strToken(frk->frPnt+frk->recPnt*frk->fldCnt, frk->fldCnt,
                          &fp->chrCnt,fp);
      fp->recCnt++;
    }

    if(keyBreakFRK(frk)){
      if(frk->byFile){
        for(i=0; i<frk->recPnt; i++){
          writeRecFRK(frk, i);
        }
        mssCloseFPW(frk->fpw);
        frk->fpr=mssOpenFPR(frk->fName,4);
        frk->fr=mssInitFldRec(frk->fldCnt);
      }

      fp->deq = PrevQue(fp->enq,fp->queCnt);
      frk->keyNo++; /*ֹ̤򥫥ȥå*/
      frk->curRecNo=0;
      return(1);
    }

    /*frk->frPntɤ߹߹԰֤򥫥ȥå*/
    frk->recPnt++;

    /*Υ쥳ɿ򥫥ȥå*/
    frk->keyRecCnt++;
  }
  return(1);
}

/**
 * # FUNCTION #
 * mssFldRecKey¤Τˤơɤ߹pnt˳ƹʸ򥻥åȤ롣
 * ɤ߹ǡʤEOF֤
 */
int mssReadFldRecFRK(struct mssFldRecKey *frk){
  int i;

  if(frk->curRecNo>=frk->keyRecCnt)return(EOF);

  if(frk->byFile){
    if(EOF==mssReadFldRec(frk->fpr,frk->fr)){
      return(EOF);
    }else{
      for(i=0; i<frk->fldCnt; i++){
        *(frk->pnt+i)=*(frk->fr->pnt+i);
      }
    }
   
  }else{
    for(i=0; i<frk->fldCnt; i++){
      *(frk->pnt+i)=*(frk->frPnt+frk->curRecNo*frk->fldCnt+i);
    }
  }
  frk->curRecNo++;
  return(1);
}

/**
 * # FUNCTION #
 * mssFldRecKey¤ΤˤơƬ˥
 */
void mssSeekTopFRK(struct mssFldRecKey *frk)
{
  frk->curRecNo=0;
  if(frk->byFile){
    mssCloseFPR(frk->fpr);
    frk->fpr=mssOpenFPR(frk->fName,4);
    mssFreeFldRec(frk->fr);
    frk->fr=mssInitFldRec(frk->fldCnt);
  }
}

/**
 * # FUNCTION #
 * ǡƬԤɤ߹ߡ֤ܿEOFɤ߹ȤEOF֤
 * ǡɤ߹ߤ򤪤ʤfp->curưʤ
 * äƤδؿμmssReadFldRecʤɤɤߤС⤦٥ȥå׹Ԥ
 * ɤߤޤ뤳Ȥˤʤ
 * fpΥХåեϤäѹʤ
 * Τꡢ˥mallocǳݤؤΥݥ󥿤rec¤
 * ˥åȤ롣
 */
int mssGetFldCntOnData(struct mssFPR *fp)
{
           char *start;
           int spcCnt;
  register int i; /*®Τregisterѿ*/

  /*֤߰ХåեǸMssRecordMaxLenʸˤäƤեɤ߹*/
  if(needFileRead(fp)){
    readFPRfile(fp);
    /*ñ̤ɤ߹ߤξϾdeqenqΣ*/
    fp->deq=PrevQue(fp->enq,fp->queCnt);
  }

  /*eofθ*/
  if(isEOF(fp)) return(EOF);

  start=fp->curPnt; /*fp->curưʤΤ*/
  spcCnt=0;
  i=1;
  while( *start != '\n' ){
    if(*start==MssFieldDelim) spcCnt++;
    start++; i++;
    if(i>=MssRecordMaxLen){
      mssShowErrMsg("exceed %d characters per record\n",MssRecordMaxLen);
      mssEnd(mssErrorNoDefault);
    }
  }

  return(++spcCnt); /*ڡο+1ܿ*/
}

/**
 * # FUNCTION #
 * ƬԤ˥(եƬǤϤʤ)
 * ɸϤФƤϡδؿѤȥ顼Ȥʤ롣
 * mssReopenFPRsortؿѸǤѲǽ
 */
void mssSeekTopFPR(struct mssFPR *fp)
{

  if(0==fp->fName && !fp->sort){
    mssShowErrMsg("can not seek on stdin");
    mssEnd(mssErrorNoDefault);
  }
  fp->curPnt = 0;

  /*󥭥塼ǥ塼ݥ󥿤ν*/
  /*enq==deq then , deq-1=enq then full*/
  fp->deq =0;
  fp->enq =0;
  fp->full=0;
  fp->last=0;

  fp->recCnt = 0;
  fp->chrCnt = 0;

  /*ȥݥ󥿡Υå*/
  fp->curPnt=fp->buf+fp->queSize*fp->queCnt+MssRecordMaxLen;

  if(fp->sort){
    fp->readPnt=fp->curPnt;
    setFirstLineTT(fp->sd, fp->sd->iStart,fp->sd->iEnd);
  }else{
    gzseek(fp->zfd, 0, 0);
    mssSkipToBody(fp);
  }
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ե륪ץ󥯥Ϣ
 * ----------------------------------------------------------------------------
 * MUSASHIǤϡXMLtableΰ˴ؤơʲΣĤεǽ¸Ƥ롣
 * 1. ̥ǡ®˰Υ󥰥Хåեμ
 * 2. ̥եμư(εǽˤꡢ̥եǤäƤ⡢
 *    ̾եƱͤΰǽȤʤ롣)
 * 3. ֥졼ե֤Υޥå󥰽Τˡ륭
 *    ˤ¤ٴ΢ǻưŪ˼¹Ԥ롣
 * νơƼopenؿǽ⤷ϼ¹Ԥ롣
 * mssOpenFPRmssOloseFPRϡ1,2εǽƤꡢmssReopenFPRsort3
 * ǽô
 *
 * ˡMUSASHIǤϡmssOpenFPUؿǹեΰ⥵ݡȤƤ롣
 */

/**
 * # FUNCTION #
 * եΥץ󥨥顼ɽߡ
 */
static void fileOpenErr(char *fName)
{
  mssShowErrMsg("file open error :\"%s\"",fName);
  mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * ɤ߹ߥץ
 * ե̾(fileName)NULLʤСɸϤΥץȤʤ롣
 * queCnt: 󥰥Хåեˤ륭塼ο
 *         塼ΥϡReadCnt(default:4)*PipeSize(default:4096)Ƿޤ롣
 *         ʤǥեȤǤ16K*queCntХȤΥХåեȤʤ롣
 *         queCnt2ζҾǤʤФʤʤ,ex. 2,4,8,16...
 * queCnt4ꤹСǥեȤ16K*4=64KХȤΥǡХåե
 * ݤ뤳Ȥˤʤ롣
 */
struct mssFPR *mssOpenFPR(char *fileName,int queCnt)
{
  struct mssFPR *fp;

  fp=mssMalloc(sizeof(struct mssFPR), "openFPR");

  /*gzopen*/
  if(fileName == NULL){
    fp->zfd=gzdopen(0,"rb"); /*stdin*/
  }else{
    fp->zfd=gzopen(fileName,"rb");
  }
  if(fp->zfd == NULL) fileOpenErr(fileName);

  /*󥭥塼ǥ塼ݥ󥿤ν*/
  fp->sort=0;
  fp->deq =0;
  fp->enq =0;
  fp->full=0;
  fp->last=0;
  fp->queCnt =queCnt;
  fp->queSize=ReadCnt*PipeSize;
  if(fileName==NULL){
    fp->fName=mssMalloc(sizeof(char)*10,"openFPR");
    strcpy(fp->fName,"stdin");
  }else{
    fp->fName=mssMalloc(sizeof(char)*(strlen(fileName)+1),"openFPR");
    strcpy(fp->fName,fileName);
  }

  /*Хåեΰγ*/
  fp->buf=mssMalloc(sizeof(char)*fp->queSize*fp->queCnt+MssRecordMaxLen, "openFPR");

  /*ȥݥ󥿤ХåեκǸ+1ˤäƤ(readFileΤ)*/
  fp->curPnt=fp->buf+fp->queSize*fp->queCnt+MssRecordMaxLen;

  fp->readPnt=NULL;
  fp->sd     =NULL;
  fp->zflg   =1;

  fp->recCnt=0;
  fp->chrCnt=0;
  return(fp);
}

/**
 * # FUNCTION #
 * ǡ򥽡Ȥƥեɤ߹ߺƥץ
 * ̾եȤƥץ󤷤inFileΥǡ򡢻Υȹflds
 * Ū˥ƥ󥰤ɤ߹ߥեȤƺƥץ󤹤롣
 * δؿƤӽФϡ̾mssOpenFPRǥץ󤷤Ʊͤ˰Ȥ
 * ǽ
 * fldCntˤϡǡܿꤹ롣
 * queCnt: ˺ƥץ󤵤󥰥Хåեˤ륭塼ο
 *         塼ΥϡReadCnt(default:4)*PipeSize(default:4096)Ƿޤ롣
 *         ʤǥեȤǤ16K*queCntХȤΥХåեȤʤ롣
 *         queCnt2ζҾǤʤФʤʤ,ex. 2,4,8,16...
 * queCnt4ꤹСǥեȤ16K*4=64KХȤΥǡХåե
 * ݤ뤳Ȥˤʤ롣
 */
struct mssFPR *mssReopenFPRsort(
  struct mssFPR *inFile,
  int queCnt,
  struct mssFields *flds, /*ȹ*/
  int fldCnt,       /*ܿ*/
  char *tmpPath)    /*եѥ̾*/
{     /*եѥ̾*/

  struct mssFPR *fp;

  /*󥭥塼ǥ塼ݥ󥿤ν(mssOpenFPRƱȤ򤹤)*/
  fp=mssMalloc(sizeof(struct mssFPR), "openFPR");
  fp->recCnt=0;
  fp->chrCnt=0;
  fp->deq =0;
  fp->enq =0;
  fp->full=0;
  fp->last=0;
  fp->queCnt =queCnt;
  fp->queSize=ReadCnt*PipeSize; /*FPRqueSizeƱˤƤ*/

  fp->fName=mssMalloc(sizeof(char)*(strlen(inFile->fName)+1),"reopenFPRsort");
  strcpy(fp->fName,inFile->fName);

  /*Хåեΰγ*/
  fp->buf=mssMalloc(sizeof(char)*fp->queSize*fp->queCnt+MssRecordMaxLen*2,"initDAT");

  /*ȥݥ󥿤ХåեκǸ+1ˤäƤ(readFileΤ)*/
  fp->curPnt =fp->buf+fp->queSize*fp->queCnt+MssRecordMaxLen;

  /*--------------------------- ʲΥѡȤmssOpenFPRˤʤ*/
  /*ɤ߹ߥݥ󥿤Υå*/
  fp->readPnt=fp->curPnt;

  /*ȥǡ¤ν*/
  fp->sd=initSD(flds,fldCnt,tmpPath);
  /*preSortμ¹*/
  preSort(fp->sd,inFile);

  /*preSortʹߤϡreadFPRfileǤΥե饰ˤäơ*/
  /*tnTreeɤ߹ळȤˤʤ*/
  fp->sort=1;

  /*ϥեĤ*/

  mssCloseFPR(inFile);

  return(fp);
}

/**
 * # FUNCTION #
 * ɤ߹ߥե륯
 */
void mssCloseFPR(struct mssFPR *fp)
{

  if(fp==NULL)return;

  if(fp->sort){
    endPreSort(fp->sd);
    freeSD(fp->sd);
    /*close(fp->fd);*/
  }else{
    gzclose(fp->zfd);
  }
  mssFree(fp->fName);
  mssFree(fp->buf);
  mssFree(fp);
}

/**
 * # FUNCTION #
 * ե륪ץ
 * ɸϤӰ̥եϹեȤƥץǤʤ
 * queCnt: 󥰥Хåեˤ륭塼ο
 *         塼ΥϡReadCnt(default:4)*PipeSize(default:4096)Ƿޤ롣
 *         ʤǥեȤǤ16K*queCntХȤΥХåեȤʤ롣
 *         queCnt2ζҾǤʤФʤʤ,ex. 2,4,8,16...
 * queCnt4ꤹСǥեȤ16K*4=64KХȤΥǡХåե
 * ݤ뤳Ȥˤʤ롣
 */
struct mssFPR *mssOpenFPU(char *fileName, int queCnt)
{
  struct mssFPR *fp;

  fp=mssMalloc(sizeof(struct mssFPR), "openFPR");

  if(fileName == NULL){
    mssShowErrMsg("cannot open stdin as update file"); /*stdin*/
    mssEnd(mssErrorNoDefault);
  }else{
    fp->fp=fopen(fileName,"rb+");
  }
  if(fp->fp == NULL) fileOpenErr(fileName);

  /*󥭥塼ǥ塼ݥ󥿤ν*/
  fp->sort=0;
  fp->deq =0;
  fp->enq =0;
  fp->full=0;
  fp->last=0;
  fp->queCnt =queCnt;
  fp->queSize=ReadCnt*PipeSize;
  if(fileName==NULL){
    fp->fName=mssMalloc(sizeof(char)*10,"openFPU");
    strcpy(fp->fName,"stdin");
  }else{
    fp->fName=mssMalloc(sizeof(char)*(strlen(fileName)+1),"openFPU");
    strcpy(fp->fName,fileName);
  }

  /*Хåեΰγ*/
  fp->buf=mssMalloc(sizeof(char)*fp->queSize*fp->queCnt+MssRecordMaxLen, "openFPU");

  /*ȥݥ󥿤ХåեκǸ+1ˤäƤ(readFileΤ)*/
  fp->curPnt=fp->buf+fp->queSize*fp->queCnt+MssRecordMaxLen;

  fp->readPnt=NULL;
  fp->sd     =NULL;
  fp->zflg   =0;

  fp->recCnt=0;
  fp->chrCnt=0;
  return(fp);
}

/**
 * # FUNCTION #
 * ե륯
 */
void mssCloseFPU(struct mssFPR *fp)
{

  fclose(fp->fp);
  mssFree(fp->fName);
  mssFree(fp->buf);
  mssFree(fp);
}



