/*----------------------------------------------------------------------
    Character / Text line recognition library   nhocr.h
      Rev. 090510
        Written by H.Goto, Jan. 2009
        Revised by H.Goto, Jan. 2009
        Revised by H.Goto, May  2009
----------------------------------------------------------------------*/

/*--------------
  Copyright 2008,2009  Hideaki Goto

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
--------------*/


#ifndef	_nhocr_h
#define	_nhocr_h

#include	"ocrbase.h"
#include	"codelist.h"


class CharBox {
public:
	int	xs,xe;
	int	ys,ye;
	int	charcore;
	int	conn_R;
	int	poshint, sizehint;
	int	ascii;
	int	nbox;	// Number of boxes for a character.
			// nbox=0 shows the end of array.
	int	parent;	// -1: The CharBox is the leftmost one or is not merged.
			// non-negative: Parent ID

	int	xc(){ return((xs+xe)/2); }
	int	width(){ return(xe-xs+1); }
	int	height(){ return(ye-ys+1); }
	int	iscore(int refsize);
		CharBox(void);
};




class NHrec {
    private:
	RecBase	Rec;

	int	rec_addstr(char *line, char *str, int bufsize);
	int	rec_character(SIPImage *image, CharBox *cb);

    protected:
	char	*nhocrlibdir;
	char	*cctablefile;
	char	*dicfile;

    public:
	int	debug;

	int	n_cat;
	int	n_top;
	CharCode	*cclist;

	// Basic functions
	int	setlibdir(char *path);
	int	setdicfile(char *dicname, char *cctablename);
	int	open();
	int	close();

	int	rec_character(SIPImage *image, \
			int x0, int y0, int width, int height, \
			RecResultItem *resultTable);

	int	rec_line(SIPImage *image, char *resultline, int bufsize);

	// Utilities
	int	binarize_otsu(SIPImage *src, SIPImage *dst, int csize, int interpolate);
	int	auto_invert(SIPImage *image);

		NHrec();
		~NHrec();
};

#endif	// _nhocr_h
