/*
 * output.h: header for output.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2000 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$Id: output.h,v 1.19 2000/04/01 07:39:58 mrg Exp $
 *
 * additions/modifications by Joshua J. Drake
 */

#ifndef __output_h_
#define __output_h_

/* ircII compatability */
#define yell		put_error
#define say		put_info
#define put_it		put_raw
#define help_put_it	put_help

/* ninja compatability heheh */
#define put_file	cat_file

#ifdef HAVE_STDARG_H
	void   	put_raw _((char *, ...));
	void   	put_info _((char *, ...));
	void   	put_error _((char *, ...));
	void   	put_help _((u_char *, char *, ...));

	void   	send_to_server _((char *, ...));
#else
	void   	put_raw _(());
	void   	put_info _(());
	void   	put_error _(());
	void   	put_help _(());

	void   	send_to_server _(());
#endif

	void	refresh_screen _((u_int, u_char *));
extern	int	do_refresh_screen;
	void	init_screen _((void));
	void	put_file _((u_char *));

extern	FILE	*irclog_fp;

#endif
