/*
 * server.h: header for server.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2000 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$Id: server.h,v 1.50 2000/04/01 07:39:59 mrg Exp $
 * 
 * addition/modifications written by Joshua J. Drake
 */

#ifndef __server_h_
#define __server_h_

/*
 * macros to distinguish diff. server versions
 * (soon to remove obsoletes)
 */

#ifdef SUPPORT_ICB
# define ServerICB	-1
#endif
#define Server2_5	0
#define Server2_6	1
#define Server2_7	2
#define Server2_8	3
#define Server2_8_hyb	4
#define Server2_9	5
#define Server2_10	6
#define Server2_11	7

/*
 * Server
 * a type definition for the structured linked list data.
 *
 */
typedef	struct
{
	u_char	*name;			/* the name of the server */
	u_char	*itsname;		/* the server's idea of its name */
	u_char	*password;		/* password for that server */
	int	port;			/* port number on that server */
	u_char	*nickname;		/* nickname for this server */
   /* extra from information */
   u_char	*username;		/* the username the server sees */
   u_char	*hostname;		/* the hostname the server sees */
   u_char	*usermode;		/* the usermode to set on the server */
   /* away stuff */
	u_char	*away;			/* away message for this server */
	time_t	away_set;		/* time that the person was set away */
	u_long	away_count;		/* count of away messages logged */

	int	operator;		/* true if operator */
	int	version;		/* the version of the server -
					 * defined above */
	u_char	*version_string;	/* what is says */
	int	whois;			/* true if server sends numeric 318 */
	u_long	flags;			/* Various flags */
	int	connected;		/* true if connection is assured */
	int	write;			/* write descriptor */
	int	read;			/* read descriptior */
	pid_t	pid;			/* process id of server */
	int	eof;			/* eof flag for server */
	int	motd;			/* motd flag (used in notice.c) */
	int	sent;			/* set if something has been sent,
					 * used for redirect */
   /* these are used for lag checking */
	int	lag;			/* lag in seconds */
	time_t	lag_time;		/* last lag check time */
	int	in_ping;		/* if we're ping'n */
   
	u_char	*buffer;		/* buffer of what dgets() doesn't get */
	WhoisQueue	*WQ_head;	/* WHOIS Queue head */
	WhoisQueue	*WQ_tail;	/* WHOIS Queue tail */
	WhoisStuff	whois_stuff;	/* Whois Queue current collection buffer */
	int	close_serv;		/* server to close when we are LOGGED_IN */
        time_t	ctcp_last_reply_time;   /* used to limit flooding */
        time_t	ctcp_flood_time;
        int	ctcp_backlog_size;
        int	*ctcp_send_size;
	struct in_addr local_addr;	/* ip address of this connection */
#ifdef SUPPORT_ICB   
        u_char	*group;			/* ICB group */
        u_char	*icbmode;	       	/* ICB initial mode */
#endif
        Channel	*chan_list;		/* list of channels for this server */
   	void	(*parse_server) _((u_char *));	/* pointer to parser for this server */
   
   /* what channel/usermode the server allows obtained from #004 */
   	u_char	*cmodes;		/* the server's allowed channel modes */
   	u_char	*umodes;		/* the server's allowed user modes */
   /* this is used to keep track of who we've done a /who on when they joined
    * a channel...  sloppy i know..
    */
   	u_char	*who_nicks;
}	Server;

typedef struct ser_group_list
{
	struct ser_group_list	*next;
	u_char	*name;
	int	number;
}	SGroup;

	int	find_server_group _((u_char *, int));
	u_char *	find_server_group_name _((int));
	void	add_to_server_list _((u_char *, int, u_char *, u_char *, u_char *, int));
	void	build_server_list _((u_char *));
	int	connect_to_server _((u_char *, int, u_char *, int));
	void	get_connected _((int));
	int	read_server_file _((void));
	void	display_server_list _((void));
	void	do_server _((fd_set *, fd_set *));
#ifdef HAVE_STDARG_H
	void	send_to_server _((char *, ...));
#else
	void	send_to_server _(());
#endif /* HAVE_STDARG_H */
	int	get_server_whois _((int));

	WhoisStuff	*get_server_whois_stuff _((int));
	WhoisQueue	*get_server_qhead _((int));
	WhoisQueue	*get_server_qtail _((int));

extern	int	save_chan_from;	/* to keep the channel list if all servers
				 * are lost */

extern	int	attempting_to_connect;
extern	int	number_of_servers;
extern	int	connected_to_server;
extern	int	never_connected;
extern	int	using_server_process;
extern	int	primary_server;
extern	int	from_server;
extern	u_char	*connect_next_nick;
extern	u_char	*connect_next_umode;
extern	u_char	*connect_next_password;
#ifdef SUPPORT_ICB
extern	u_char	*connect_next_icbmode;
extern	u_char	*connect_next_icbgroup;
#endif
extern	int	parsing_server_index;
#ifdef SUPPORT_ICB
extern	int	connect_next_as_icb;
extern	int	connect_next_as_irc;
#endif
extern	SGroup	*server_group_list;

	void	servercmd _((u_char *, u_char *, u_char *));
	u_char	*get_server_nickname _((int));
	u_char	*get_server_name _((int));
	u_char	*get_server_itsname _((int));
	void	set_server_flag _((int, int, int));
	int	find_in_server_list _((u_char *, int, u_char *));
	u_char	*create_server_list _((void));
	void	remove_from_server_list _((int));
	void	set_server_motd _((int, int));
	int	get_server_motd _((int));
	int	get_server_operator _((int));
	int	get_server_2_6_2 _((int));
	int	get_server_version _((int));
	u_char	*get_server_password _((int));
#ifdef SUPPORT_ICB
	u_char	*get_server_icbgroup _((int));
	u_char	*get_server_icbmode _((int));
#endif
	void	close_server _((int, u_char *));
	void	MarkAllAway _((u_char *, u_char *));
	int	is_server_connected _((int));
	void	flush_server _((void));
	int	get_server_flag _((int, int));
	void	set_server_operator _((int, int));
	void	server_is_connected _((int, int));
	int	parse_server_index _((u_char *));
	void	parse_server_info _((u_char **, u_char **, u_char **, u_char **, u_char **, u_char **));
	void	set_server_bits _((fd_set *, fd_set *));
	void	set_server_itsname _((int, u_char *));
	void	set_server_version _((int, int));
	int	is_server_open _((int));
	int	get_server_port _((int));
	u_char	*set_server_password _((int, u_char *));
	void	set_server_nickname _((int, u_char *));
	void	set_server_usermode _((int, u_char *));
	void	set_server_2_6_2 _((int, int));
	void	set_server_qhead _((int, WhoisQueue *));
	void	set_server_qtail _((int, WhoisQueue *));
	void	set_server_whois _((int, int));
#ifdef SUPPORT_ICB
	void	set_server_icbgroup _((int, u_char *));
	void	set_server_icbmode _((int, u_char *));
#endif
	void	close_all_server _((void));
	void	disconnectcmd _((u_char *, u_char *, u_char *));
	void	ctcp_reply_backlog_change _((int));

/* ninja extensions */
	void	reconnect _((u_char *, u_char *, u_char *));
	int	get_server_lag _((int));
	void	set_server_lag _((int));

	/* server_list: the list of servers that the user can connect to,etc */
	extern	Server	*server_list;

/*
 * valid server flags..
 */
#define	SERVER_2_6_2	0x00000001

#define PROXY_CONNECTED	0x00000010
#define PROXY_AUTH_SENT 0x00000020
#define PROXY_AUTH_OK	0x00000040
#define PROXY_LOGIN_SENT 0x00000080
#define PROXY_LOGIN_OK	0x00000100
#define PROXY_CONNECT_SENT 0x00000200
#define PROXY_CONNECT_OK 0x00000400
#define PROXY_ALL_OK	(PROXY_CONNECTED|PROXY_AUTH_SENT|PROXY_AUTH_OK|PROXY_LOGIN_SENT|PROXY_LOGIN_OK|PROXY_CONNECT_SENT|PROXY_CONNECT_OK)

#define SRV_CONNECTED	0x00001000
#define LOGGED_IN	0x00002000
#define CLEAR_PENDING	0x00004000
#define DELETE_PENDING	0x00008000
#define CLOSE_PENDING	0x00010000

#define	USER_MODE_I	0x00100000
#define	USER_MODE_W	0x00200000
#define	USER_MODE_S	0x00400000
#define USER_MODE_Z	0x00800000
#define USER_MODE_C	0x01000000
#define USER_MODE_R	0x02000000
#define USER_MODE_K	0x04000000
#define USER_MODE_F	0x08000000
#define USER_MODE_Y	0x10000000
#define USER_MODE_D	0x20000000
#define USER_MODE_N	0x40000000

#ifdef SUPPORT_ICB
# define	CHOOSE_PORT	(connect_next_as_icb || (!connect_next_as_irc && client_default_icb)) ? icb_port : irc_port
#else
# define	CHOOSE_PORT	irc_port
#endif

#endif
