/*
 * operview.c: toggle of operview
 *
 * written by Kraig Amador and Joshua J. Drake
 */

#include "irc.h"
#include "operview.h"
#include "window.h"
#include "server.h"
#include "output.h"
#include "dma.h"

int oper_view = 0;

static	void	operview _((int));

void
toggle_operview(u_int dumb, u_char *dumber)
{
   oper_view = oper_view ? 0 : 1;
   put_info("OperView is now %s", oper_view ? "on" : "off");
   operview(oper_view);
}

static void
operview(int on)
{
   // int old_window_display = window_display;
   u_char *tmp = NULL;

   // window_display = 0;
   if (!on)
     {
	dma_strcpy(&tmp, "goto operview kill");
	windowcmd(NULL, tmp, NULL);
	send_to_server("MODE %s -%s", get_server_nickname(from_server), "wsckf");
	dma_Free(&tmp);
     }
   else
     {
	dma_strcpy(&tmp, "level ALL new name operview goto 1");
	windowcmd(NULL, tmp, NULL);
	send_to_server("MODE %s +%s", get_server_nickname(from_server), "wsckf");
	dma_Free(&tmp);
     }
   // window_display = old_window_display;
}
