/*
 * orignick.c: Original nick (this needs a new name)
 * 
 * when you have your orignick set, your client will grab the nickname when it becomes free
 * 
 * Written by Kraig Amador and Joshua J. Drake
 */

#include "orignick.h"
#include "ircaux.h"
#include "server.h"
#include "output.h"
#include "dma.h"
#include "whois.h"

#include "ninja.h"

u_char *orignickname = UNULL;

void
orignick_cmd(command, args, subargs)
    u_char *command, *args, *subargs;
{
   u_char *nick, *ptr;
   if (args && *args)
     {
	ptr = next_arg(args, &args);
	nick = next_arg(args, &args);
	if (!my_stricmp(ptr, "OFF"))
	  dma_Free(&orignickname);
	else if (!my_stricmp(ptr, "ON"))
	  {
	     if (!nick)
	       {
		  usage("orignick", "on <nick> OR off");
		  return;
	       }
	     dma_strcpy(&orignickname, nick);
	  }
	else
	  {
	     usage("orignick", "on <nick> OR off");
	     return;
	  }
     }
   if (orignickname)
     put_info("Original nick is now ON, with nick: %s", orignickname);
   else
     put_info("Original nick is now OFF");
}


void
orignick_queue(stuff, nick, args)
    WhoisStuff *stuff;
    u_char *nick, *args;
{
   if (!stuff || !stuff->nick || !nick || !my_strcmp(stuff->user, "<UNKNOWN>") || my_stricmp(stuff->nick, nick))
     send_to_server("NICK %s", orignickname);
}

void
nchk_orignick(nick)
    u_char *nick;
{
   if (nick && !my_stricmp(nick, get_server_nickname(from_server)))
     return;
   if (nick == NULL && orignickname && my_stricmp(get_server_nickname(from_server), orignickname))
     add_to_whois_queue(orignickname, orignick_queue, "%s", orignickname);
   else if (orignickname && my_stricmp(get_server_nickname(from_server), orignickname))
     if (!my_stricmp(nick, orignickname))
       add_to_whois_queue(orignickname, orignick_queue, "%s", orignickname);
}

