/*
 * strsep.c
 *
 * just in case your machine doesn't have strsep()
 * 
 * written by Kraig Amador
 */

#include "irc.h"
#include "strsep.h"

#ifndef HAVE_STRSEP

char *
strsep(char **pp, const char *delim)
{
   char *p, *q;

   if (!(p = *pp))
      return 0;
   if ((q = (char *)strpbrk(p, delim)))
     {
	*pp = q + 1;
	*q = '\0';
     }
   else
      *pp = 0;
   return p;
}

#endif
