# prime08.rb: Module for the PRIME 0.8 protocol
# $Id: prime08.rb,v 1.2 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2005 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

module Prime08
  def initialize_prime08 ()
    @session_prime08 = PrimeSessionPrime08.new()
  end

  def close ()
    @session_prime08.close()
  end
  def update ()
    @session_prime08.update()
  end
  def refresh ()
    initialize_rc()
    @session_prime08.refresh()
  end

  def get_label (pattern)
    return @session_prime08.get_label(pattern)
  end

  def preedit_convert_input (pattern)
    return @session_prime08.preedit_convert_input(pattern)
  end

  def set_context (context)
    @session_prime08.set_context(context)
  end

  def learn_word (pron, literal, pos = "",
                  context = "", suffix = "", rest = "")
    @session_prime08.learn_word(pron, literal, pos, context, suffix, rest)
  end

  def lookup (string)
    return @session_prime08.lookup(string)
  end
  def lookup_all (string)
    return @session_prime08.lookup_all(string)
  end

  def lookup_hybrid (string)
    return @session_prime08.lookup_hybrid(string)
  end
  def lookup_hybrid_all (string)
    return @session_prime08.lookup_hybrid_all(string)
  end

  def lookup_direct (string)
    return @session_prime08.lookup_direct(string)
  end
  def lookup_direct_all (string)
    return @session_prime08.lookup_direct_all(string)
  end

  def lookup_compact (string)
    return @session_prime08.lookup_compact(string)
  end
  def lookup_compact_all (string)
    return @session_prime08.lookup_compact_all(string)
  end

  def lookup_prefix (string)
    return @session_prime08.lookup_prefix(string)
  end
  def lookup_prefix_ex (string)
    return @session_prime08.lookup_prefix_ex(string)
  end

  def lookup_exact (string)
    return @session_prime08.lookup_exact(string)
  end

  def lookup_overall (string)
    return @session_prime08.lookup_overall(string)
  end

  def lookup_expansion (string)
    return @session_prime08.lookup_expansion(string)
  end
  def lookup_mixed (string)
    return @session_prime08.lookup_mixed(string)
  end
end
