#!/usr/bin/ruby

#############################
# get word list
#############################
wordlist = Proc.new do
	lines = []
	entries = []

	dicfile = File.new($filename, "r")
		lines = dicfile.readlines
	dicfile.close

	dicfile = File.new($dicname, "w")

	lines.length.times do |num|
		entries = lines[num].split("	")

		if entries[1] == "#T35"
			dicfile.puts entries[0] + \
				"	名詞	" + \
				entries[3].chomp + \
				"	" + \
				entries[2]
		end

		if entries[1] == "#T30"
			dicfile.puts entries[0] + \
				"	サ行(する)&名詞	" + \
				entries[3].chomp + \
				"	" + \
				entries[2]
		end

		if entries[1] == "#JN"
			dicfile.puts entries[0] + \
				"	人名	" + \
				entries[3].chomp + \
				"	" + \
				entries[2]
		end
	end

	dicfile.close
end


#############################
# main
#############################
targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby wordlist.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".list"
	wordlist.call
end
