
/* creverse.q: fast list reversal using an external C function 12-17-99,
   revised 03-05-02 AG */

/*

This example illustrates the use of the C interface in Q version 2.0 or later
(cf. Q info file, Section "C Language Interface"). Currently this is supported
under Linux (and other systems providing SUN's dlopen interface) and Windows.

The corresponding C module is in creverse.c, which you have to translate to a
shared object which can be loaded at runtime by the interpreter. This can be
done using the qcc program as follows:

	qcc creverse.c

You might have to add -I and -L options or similar if your C compiler needs
them to find the Q library and header file. E.g.:

	qcc creverse.c -- -I/somewhere/include --link -L/somewhere/lib

The generated output dll is searched by the interpreter on its path, which
normally includes the current directory. Having compiled the creverse.c
module, you can run this script with the interpreter, and try the following:

	==> stacksize 200000; def l = [1..50000]
	==> def x = qreverse l; stats
	==> def x = creverse l; stats

You will probably notice that the C function is much faster. This is due to
the extra pattern matching, value extraction and function call overhead
of the interpreter.

*/

public extern creverse Xs;

public qreverse Xs;

qreverse Xs:List	= foldl push [] Xs;
