
/* globexamp.q: extended "globbing" functions */

/* match a filename against a list of glob patterns */

fnmatch [] S:String      = false;
fnmatch [P:String|Ps] S:String
			 = fnmatch P S or else fnmatch Ps S;

/* glob with a list of patterns */

glob Ps:List             = rmdups (sort (<) (cat (map glob Ps)));

/* remove adjacent duplicates from a list */

rmdups []		 = [];
rmdups [X,X|Xs]      	 = rmdups [X|Xs];
rmdups [X|Xs]      	 = [X|rmdups Xs] otherwise;
