
/* $Id: font_test.q,v 1.10 2007/09/29 08:50:14 agraef Exp $ */

/* font_test.q: Little test script showing how to render text using Q-GGI's
   font interface. NOTE: This requires FreeType2 to work. */

import ggi, system;

// config section; edit the following settings as needed

def // directories to search for font files
  FONT_DIRS = ["/usr/X11R6/lib/X11/fonts/truetype",
	       "/windows/fonts", "/winnt/fonts"],
  // name of font file
  FONT = "times.ttf",
  // for some font types you also have to set a font metric file here
  FONT_METRIC = (),
  // face index (0 will do for most purposes)
  INDEX = 0,
  // pt size and display resolution in pixels
  SIZE = 80, RES = 72,
  // some colors to play with
  RED = (0xffff,0,0), GREEN = (0,0xffff,0), BLUE = (0,0,0xffff),
  BLACK = (0,0,0), WHITE = (0xffff,0xffff,0xffff);

// set up the display

def VIS = ggi_open (), _ = ggi_set_mode VIS "640x480" ||
  ggi_set_foreground VIS WHITE ||
  ggi_set_font VIS (search_font FONT) INDEX ||
  ggi_set_font_metrics VIS (search_font FONT_METRIC) ||
  ggi_set_char_size VIS SIZE RES;

search_font FONT
= FONT where [FONT|_] = cat (map (glob.(++("/"++FONT))) FONT_DIRS);
= printf "Warning: %s could not be found -- using default font instead\n" FONT
    otherwise;

// set foreground and background color

fg COL		= ggi_set_foreground VIS COL;
bg COL		= ggi_set_background VIS COL;

// clear the display

clr		= ggi_clear VIS;

// change the font size

size SIZE	= ggi_set_char_size VIS SIZE RES;

// change the antialiasing mode

antialias FLAG	= ggi_set_antialias VIS FLAG;

// set transform vector and matrix

transform VECT MATRIX
		= ggi_set_transform VIS VECT MATRIX;

// print text in the current font

print P MSG	= ggi_puts VIS P MSG ||
		  // indicate bounding box
		  ggi_draw_hline VIS (0,Y) 640 ||
		  ggi_draw_hline VIS (0,Y+H-1) 640 ||
		  ggi_draw_vline VIS (X,0) 480 ||
		  ggi_draw_vline VIS (X+W-1,0) 480
		    where (X,Y) = P, (W,H) = ggi_get_string_size VIS MSG;

// center text at the given point

center (X,Y) MSG
		= ggi_puts VIS P MSG ||
		  ggi_draw_hline VIS (X-10,Y) 20 ||
		  ggi_draw_vline VIS (X,Y-10) 20
		    where (W,H) = ggi_get_string_size VIS MSG,
		      P = (X - W div 2, Y - H div 2);

// rotate text around the given point

rotate A (X,Y) MSG
		= transform (0,0) (cos A,-sin A,sin A, cos A) ||
		  center (X,Y) MSG;

// a little demo: rotate a text around a point until key hit

def PI = 4.0*atan 1.0, P = (320,240), MSG = "Hello, world!";

demo		= // make sure that async mode is set
		  ggi_set_flags VIS GGI_FLAG_ASYNC ||
		  writes "Hit any key in the GGI window to stop\n" ||
		  flush || loop 0 ||
		  // reset flag to original state
		  ggi_set_flags VIS FLAGS ||
		  // reset transform to default
		  transform (0,0) (1,0,0,1) || ()
		    where FLAGS = ggi_get_flags VIS;

loop K		= ggi_getc VIS || () if ggi_kbhit VIS;
		= clr || rotate (K*PI/18) P MSG || ggi_flush VIS ||
		  // 0.02 = 50 fps, change this as necessary
		  sleep 0.02 ||
		  // advance by PI/18 (= 10 degrees)
		  loop (K+1 mod 16) otherwise;
