
/* swig.q: SWIG runtime support
   $Id: swig.q,v 1.3 2007/05/20 21:06:41 agraef Exp $ */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option) any
   later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

import stdlib, clib;

/* This module implements the necessary runtime support for SWIG-generated
   modules. The SWIGPtr type encapsulates opaque C/C++ data objects (pointers,
   structures, C++ objects, etc., i.e., anything which is not a primitive C
   type or a char*). These objects can be passed around safely between
   different wrapper functions, just as you would in a C/C++ program. The main
   difference is that you cannot dereference a SWIGPtr object since the memory
   layout of the referenced object is not known in Q land. (But see below for
   a few SWIGPtr inspection operations provided by this module.)

   When a SWIGPtr object is garbage-collected, the SWIG runtime system
   automatically invokes the corresponding C++ destructor, if there is one. It
   also frees other dynamically allocated objects which have been marked with
   %newobject in the SWIG interface. */

public extern type SWIGPtr;

public is_swigptr X;

is_swigptr _:SWIGPtr	= true;
is_swigptr _		= false otherwise;

/* The following value can be used to denote a NULL pointer, which can be
   given as an argument wherever a SWIGPtr is needed. Although this has the
   potential to cause a crash, NULL pointers are also sometimes used as
   sentinel values or to denote a missing/empty value. Therefore, SWIG leaves
   NULL pointer checking up to the application. */

public extern swig_nullptr;
public const var NULL = swig_nullptr;

/* Check for NULL pointers. */

public extern swig_null PTR;
public stdlib::null PTR;
null PTR:SWIGPtr	= swig_null PTR;

/* The following operations are provided for inspecting SWIGPtr objects. The
   swig_type function returns the SWIG type identifier of a SWIG pointer, as a
   string. Likewise, the corresponding C/C++ type name is returned by the
   swig_ctype function. The swig_addr function returns the value of the pointer
   as an unsigned integer; this is useful for debugging purposes and also
   provides a convenient way of indexing SWIGPtr objects in a dictionary. */

public extern swig_type PTR;
public extern swig_ctype PTR;
public extern swig_addr PTR;

/* The swig_get and swig_put operations are used to transfer data between the
   memory pointed to by a SWIGPtr object and a byte string. The swig_get
   function returns the data at the given offset with the given size as a byte
   string. The swig_put function stores the contents of the given byte string
   at the memory location designated by the given offset and returns (). Both
   offsets and data sizes are given as numbers of bytes.

   CAVEAT: While these operations can be useful at times to manipulate the
   contents of a SWIGPtr object with known size and structure (such as a C
   buffer containing character data), they should be used with utmost care.
   As there is no way to check the actual memory layout of a SWIGPtr object,
   specifying a wrong offset or data size is a sure way to make your program
   crash. */

public extern swig_get PTR OFFS SIZE;
public extern swig_put PTR OFFS B;

/* The swig_up function arranges to redirect a method call to the C++
   superclass of a director class instance, and returns its argument. After
   applying this function to the corresponding SWIGPtr object, the next call
   to the method will invoke the C++ method instead of the overriding Q
   method. */

public extern swig_up PTR;
