
/* $Id: recipes.q,v 1.2 2004/09/09 23:43:17 agraef Exp $
   recipes.q: Demonstration of the xslt interface. */

/* This program illustrates how to format existing XML data using an XSLT
   stylesheet. Both the XML data and the stylesheet are contained in text
   files on disk. (Sample data pilfered from Jay Greenspan's xml/xslt tutorial
   on http://webmonkey.wired.com.) */

import xml;

/* Parse the data in the XML document. Note that we use the included DTD to
   validate the document. */

def DOC = xml_load_file "recipes.xml" XML_DTDVALID;

/* Parse the stylesheet. */

def STY = xslt_load_stylesheet "recipes.xsl";

/* Apply the stylesheet to the data and save the resulting html in a file.
   Just invoke the html function and open recipes.html in your favourite
   browser to view the result. That's all. Note that libxml/libxslt does all
   the hard work. */

html = xslt_save_result_file "recipes.html" RES STY 0
	 where RES:XMLDoc = xslt_apply_stylesheet STY DOC ();
