
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "qdefs.h"

char           *code = "q.out";

/* iscode(): check whether file is a valid Q bytecode file (return 1
   if current version, -1 if other Q version). */

int iscode(FILE *fp)
{
  static char *_outid = OUTID;
  char magic[MAXSTRLEN], *p;
  fread(magic, sizeof(char), strlen(outid)+1, fp);
  if (ferror(fp))
    return 0;
  else if (strcmp(magic, outid))
    if ((p = strchr(_outid, '%')) && strncmp(magic, outid, p-_outid) == 0)
      return -1;
    else
      return 0;
  else
    return 1;
}

/* readtables(): read in the code file. */

void readtables(void)
{
  FILE           *fp;
  static char     s[MAXSTRLEN];
  char		  msg[MAXSTRLEN], outid1[MAXSTRLEN];
  int             modno;

  if (!chkfile(searchlib(s, code)) || (fp = fopen(s, "rb")) == NULL) {
    sprintf(msg, qmmsg[FILE_NOT_FOUND], code);
    fatal(msg);
  } else
    code = s;

  /* read header information: */

  fread(outid1, sizeof(char), strlen(outid)+1, fp);
  if (ferror(fp) || strcmp(outid1, outid))
    fatal(qmmsg[FILE_FORMAT_ERR]);
  fread(&mainno, sizeof mainno, 1, fp);
  fread(&codespsz, sizeof codespsz, 1, fp);
  fread(&strspsz, sizeof strspsz, 1, fp);
  fread(&limbspsz, sizeof limbspsz, 1, fp);
  fread(&hashtbsz, sizeof hashtbsz, 1, fp);
  fread(&symtbsz, sizeof symtbsz, 1, fp);
  fread(&statetbsz, sizeof statetbsz, 1, fp);
  fread(&transtbsz, sizeof transtbsz, 1, fp);
  fread(&roffstbsz, sizeof roffstbsz, 1, fp);
  fread(&matchtbsz, sizeof matchtbsz, 1, fp);
  fread(&inittbsz, sizeof inittbsz, 1, fp);
  fread(&modtbsz, sizeof modtbsz, 1, fp);
  fread(&imptbsz, sizeof imptbsz, 1, fp);

  if (ferror(fp))
    fatal(qmmsg[CODE_FILE_ERR]);

  /* allocate tables: */

  if ((codespsz > 0 &&
       (codesp = (OPREC *) aalloc(codespsz, sizeof(OPREC)))
       == NULL) ||
      (strspsz + atmpspsz > 0 &&
       (strsp = (char *) arealloc(NULL, strspsz, atmpspsz,
				  sizeof(char)))
       == NULL) ||
      (limbspsz > 0 &&
       (limbsp = (mp_limb_t *) aalloc(limbspsz, sizeof(mp_limb_t)))
       == NULL) ||
      (hashtb = (int *) aalloc(hashtbsz, sizeof(int)))
      == NULL ||
      (symtbsz + atmptbsz > 0 &&
       (symtb = (SYMREC *) arealloc(NULL, symtbsz, atmptbsz,
				    sizeof(SYMREC)))
       == NULL) ||
      (statetbsz > 0 &&
       (statetb = (STATEREC *) aalloc(statetbsz, sizeof(STATEREC)))
       == NULL) ||
      (transtbsz > 0 &&
       (transtb = (TRANSREC *) aalloc(transtbsz, sizeof(TRANSREC)))
       == NULL) ||
      (roffstbsz > 0 &&
       (roffstb = (int *) aalloc(roffstbsz, sizeof(int)))
       == NULL) ||
      (matchtbsz > 0 &&
       (matchtb = (int *) aalloc(matchtbsz, sizeof(int)))
       == NULL) ||
      (inittbsz > 0 &&
       (inittb = (int *) aalloc(inittbsz, sizeof(int)))
       == NULL) ||
      (modtbsz > 0 &&
       (modtb = (int *) aalloc(modtbsz, sizeof(int)))
       == NULL) ||
      (modtbsz > 0 &&
       (fnametb = (int *) aalloc(modtbsz, sizeof(int)))
       == NULL) ||
      (modtbsz > 0 &&
       (globs = (byte *) aalloc(modtbsz, sizeof(byte)))
       == NULL) ||
      (modtbsz > 0 &&
       (imports = (int *) aalloc(modtbsz, sizeof(int)))
       == NULL) ||
      (imptbsz > 0 &&
       (imptb = (int *) aalloc(imptbsz, sizeof(int)))
       == NULL) ||
      (imptbsz > 0 &&
       (impib = (byte *) aalloc(imptbsz, sizeof(int)))
       == NULL))
    fatal(qmmsg[MEM_OVF]);

  /* read the tables: */
  
  fread(codesp, sizeof(OPREC), codespsz, fp);
  fread(strsp, sizeof(char), strspsz, fp);
  fread(limbsp, sizeof(mp_limb_t), limbspsz, fp);
  fread(hashtb, sizeof(int), hashtbsz, fp);
  fread(symtb, sizeof(SYMREC), symtbsz, fp);
  fread(statetb, sizeof(STATEREC), statetbsz, fp);
  fread(transtb, sizeof(TRANSREC), transtbsz, fp);
  fread(roffstb, sizeof(int), roffstbsz, fp);
  fread(matchtb, sizeof(int), matchtbsz, fp);
  fread(inittb, sizeof(int), inittbsz, fp);
  fread(modtb, sizeof(int), modtbsz, fp);
  fread(fnametb, sizeof(int), modtbsz, fp);
  fread(imports, sizeof(int), modtbsz, fp);
  fread(imptb, sizeof(int), imptbsz, fp);
  fread(impib, sizeof(byte), imptbsz, fp);

  if (ferror(fp))
    fatal(qmmsg[CODE_FILE_ERR]);

  fclose(fp);

  /* enter the lambda destructor into the symbol table (we cannot do this at
     compile time since this is a function pointer only available at
     runtime) */

  symtb[FUNCTIONTYPE].f = qmlambda_dtor;

  /* construct the global imports table: */

  modno = (mainno>=0)?mainno:0;
  if (modno < modtbsz) {
    int i, i1, i2;
    for (i = 0; i < modtbsz; i++)
      globs[i] = 0;
    i1 = imports[modno];
    i2 = (modno+1<modtbsz)?imports[modno+1]:imptbsz;
    for (i = i1; i < i2; i++)
      globs[imptb[i]] = impib[i] | 4;
  }

}
